//
//  AlertPanelChange.m
//  BwanaDik
//
//  Created by John Schilling on 6/9/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import "AlertPanelChange.h"
#import "NSStringExtras.h"

#define DEFAULT_AUTOCLOSE_SECS      300.0
#define DEFAULT_ANIME_SPEED         1.250

@implementation AlertPanelChange

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark

- (id)init
{
    if( ![super init] ) return nil;
    _lastAppPath = [[NSMutableString alloc] init];
    _alertOpen = NO;
    return self;
}

- (void)awakeFromNib
{
    _mainText       = [[NSString alloc] initWithString:[_alertPanelMainTextField stringValue]];
    _currentIPText  = [[NSString alloc] initWithString:[_alertPanelCurrentTextField stringValue]];
    _previousIPText = [[NSString alloc] initWithString:[_alertPanelPreviousTextField stringValue]];
}

- (BOOL)windowShouldClose:(id)sender
{
    [self killAlert];
    return YES;
}

- (void)dealloc
{

    [_mainText release];
    _mainText = nil;
    
    [_currentIPText release];
    _currentIPText = nil;
    
    [_previousIPText release];
    _previousIPText = nil;

    [_lastAppPath release];
    _lastAppPath = nil;
    
    [super dealloc];
}





- (void)runAlertPanelChangedAddress:(NSString *)CurrentAddress 
                    PreviousAddress:(NSString *)PreviousAddress 
                         changeType:(int)changeType 
                          autoClose:(BOOL)autoClose
{
    _alertOpen = YES;

    NSString *change;
    if (changeType == 0)
    {
        change = [[NSString alloc] initWithString:@"LAN"];
    } else {
        change = [[NSString alloc] initWithString:@"WAN"];
    }
    
    NSMutableString *newMain = [[NSMutableString alloc] initWithString:_mainText];
    [newMain replaceOccurrencesOfString:@"<@>" withString:change options:NSCaseInsensitiveSearch range:NSMakeRange(0, [newMain length])];
    NSMutableString *newCurrent = [[NSMutableString alloc] initWithString:_currentIPText];
    [newCurrent replaceOccurrencesOfString:@"<@>" withString:change options:NSCaseInsensitiveSearch range:NSMakeRange(0, [newCurrent length])];
    NSMutableString *newPrevious = [[NSMutableString alloc] initWithString:_previousIPText];
    [newPrevious replaceOccurrencesOfString:@"<@>" withString:change options:NSCaseInsensitiveSearch range:NSMakeRange(0, [newPrevious length])];
    
    [_alertPanelMainTextField setStringValue: newMain];
    [_alertPanelCurrentTextField setStringValue: newCurrent];
    [_alertPanelPreviousTextField setStringValue: newPrevious];
    
    [_alertPanelCurrentIPField setStringValue: CurrentAddress];
    [_alertPanelPreviousIPField setStringValue: PreviousAddress];
    
    [self setLastApplicationPath];
    [NSApp activateIgnoringOtherApps:YES];
    [[self window] center];
    [[self window] makeKeyAndOrderFront:self];
    [[self window] display];
    
    if (autoClose) [self startCloseTimer];
    [self startAnimeTimer];
    
    [change release];
    [newMain release];
    [newCurrent release];
    [newPrevious release];
}

- (void)killAlert
{
    if (!_alertOpen) return;
    _alertOpen = NO;
    
    [self stopCloseTimer];
    [self stopAnimeTimer];
    [[self window] close];
    [self returnFocusToLastApplication];
    
    [_alertPanelMainTextField setStringValue:_mainText];
    [_alertPanelCurrentTextField setStringValue:_currentIPText];
    [_alertPanelPreviousTextField setStringValue:_previousIPText];
}

- (void)startCloseTimer
{
    [self stopCloseTimer];
    
    NSTimer *timer = [NSTimer scheduledTimerWithTimeInterval:(float)DEFAULT_AUTOCLOSE_SECS
                            target:self 
                            selector:@selector(closeTimerFired:) 
                            userInfo:nil 
                            repeats:NO];
    if (timer) _closeTimer = [timer retain];
}

- (void)stopCloseTimer
{
    if (_closeTimer) [_closeTimer invalidate];
    if (_closeTimer) [_closeTimer release];
    _closeTimer = nil;
}

- (void)closeTimerFired:(NSTimer *)timer
{
    [self killAlert];
}


- (void)startAnimeTimer
{
    [self stopAnimeTimer];
    
    NSTimer *timer = [NSTimer scheduledTimerWithTimeInterval:(float)DEFAULT_ANIME_SPEED
                            target:self 
                            selector:@selector(animeTimerFired:) 
                            userInfo:nil 
                            repeats:YES];
    if (timer) _animeTimer = [timer retain];
}

- (void)stopAnimeTimer
{
    if (_animeTimer) [_animeTimer invalidate];
    if (_animeTimer) [_animeTimer release];
    _animeTimer = nil;
    _animeSwitch = YES;
}

- (void)animeTimerFired:(NSTimer *)timer
{
    _animeSwitch = !_animeSwitch;
    [_alertPanelImageView setImage:[NSImage imageNamed:[NSString stringWithFormat:@"Alert%d.tif", _animeSwitch]]];
}






- (void)setLastApplicationPath
{
    NSDictionary *appDict = [[NSWorkspace sharedWorkspace] activeApplication];
    if (appDict == nil) {
        _lastAppPath = nil;
        return;
    }
    NSString *myPath = [[NSBundle mainBundle] bundlePath];
    NSString *appPath = [appDict objectForKey:@"NSApplicationPath"];
    if (![myPath isEqualToString:appPath]) {
        [_lastAppPath setString: appPath];
    }
}

- (void)returnFocusToLastApplication
{
    if (_lastAppPath == nil || ([_lastAppPath length] < 1)) return;
    NSArray *activeApps = [[NSWorkspace sharedWorkspace] launchedApplications];
    
    NSEnumerator *appsEnum = [activeApps objectEnumerator];
    id anApp;
    while (anApp = [appsEnum nextObject]) {
        NSString *appPath = [anApp objectForKey:@"NSApplicationPath"];
        NSString *appName = [anApp objectForKey:@"NSApplicationName"];
        if ([appPath isEqualToString:_lastAppPath] && ![appName isEqualToString:@"Finder"]) {
            [[NSWorkspace sharedWorkspace] launchApplication: _lastAppPath];
        }
    }
    [_lastAppPath setString:@""];
}
          

@end
