//
//  ClickableText.m
//
//  Created by Ben Haller on Tue Jul 15 2003.
//
//  This code is hereby released into the public domain.  Do with it as you wish.
//

#import "ClickableText.h"

@implementation ClickableText

- (void)finishInitialization
{
    [self setBordered:NO];
    [self setBezeled:NO];
    [self setDrawsBackground:NO];
    [self setEditable:NO];
    [self setSelectable:NO];
    [self setEnabled:YES];
    [self setTextColor:[NSColor blackColor]];
}

- (id)initWithCoder:(NSCoder *)decoder
{
    if (self = [super initWithCoder:decoder])
    {
        [self finishInitialization];
    }
    
    return self;
}

- (id)initWithFrame:(NSRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        [self finishInitialization];
    }
    
    return self;
}


- (void)dealloc
{
    if (_rectTag) [self removeTrackingRect: _rectTag];
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

- (void)awakeFromNib
{

}

- (void)viewDidMoveToWindow
{
    [self setupTrackingRect];
}

- (void)frameDidChange:(NSNotification *)aNotification
{
    [self resetTrackingRect];
}

- (void)removeFromSuperview
{
    if (_rectTag) [self removeTrackingRect: _rectTag];
    [super removeFromSuperview];
}

- (void)setupTrackingRect
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(frameDidChange:) name:NSViewFrameDidChangeNotification object:[[self window] contentView]];
    [self setPostsFrameChangedNotifications: YES];
    [self resetTrackingRect];
}

- (void)resetTrackingRect
{
    if (_rectTag) [self removeTrackingRect: _rectTag];
    NSRect trackingRect = [self frame];
    trackingRect.origin = NSZeroPoint;
    _rectTag = [self addTrackingRect: trackingRect owner:self userData: nil assumeInside: NO];
}


















- (void)mouseDown:(NSEvent *)event
{
    BOOL mouseInside = YES;
    
    beingClicked = YES;
    [self setTextColor:[NSColor colorWithCalibratedRed:0.1 green:0.1 blue:0.8 alpha:1.0]];
    
    while (beingClicked && (event = [[self window] nextEventMatchingMask:(NSLeftMouseUpMask | NSLeftMouseDraggedMask)]))
    {
        NSEventType type = [event type];
        NSPoint location = [event locationInWindow];
        
        location = [self convertPoint:location fromView:nil];
        mouseInside = NSPointInRect(location, [self bounds]);
        
        if (mouseInside)
                [self setTextColor:[NSColor blackColor]];
        else if (beenClicked)
                [self setTextColor:[NSColor blackColor]];
        else
                [self setTextColor:[NSColor blackColor]];
        
        if (type == NSLeftMouseUp)
                beingClicked = NO;
    }
    
    if (mouseInside)
    {
        beenClicked = YES;
        [self setTextColor:[NSColor blackColor]];
        [self sendAction:[self action] to:[self target]];
    }
}

- (void)mouseEntered:(NSEvent *)theEvent
{
    #if defined(MAC_OS_X_VERSION_10_3) && (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_3)
        [[NSCursor pointingHandCursor] set];
    #endif
    [self setTextColor:[NSColor colorWithCalibratedRed:0.1 green:0.1 blue:0.8 alpha:1.0]];
    return;
}

- (void)mouseExited:(NSEvent *)theEvent
{
    #if defined(MAC_OS_X_VERSION_10_3) && (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_3)
        [[NSCursor arrowCursor] set];
    #endif
    [self setTextColor:[NSColor blackColor]];
    return;
}



@end
