/*
 * Decompiled with CFR 0.152.
 */
package auto;

import auto.hackFactory;
import java.util.Vector;
import prpobjects.Pageid;
import prpobjects.Pagetype;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectdesc;
import prpobjects.Uruobjectref;
import prpobjects.Urustring;
import prpobjects.plClusterGroup;
import prpobjects.prpfile;
import prpobjects.x0000Scenenode;
import shared.FindAllDescendants;
import shared.m;

public class fixCraters {
    public static void fixCraters(prpfile prp, String agename, String pagename, String outfolder, Pageid pid) {
        m.msg("Creating alternate page for Minkata craters.");
        PrpRootObject sn = hackFactory.createSceneNode(agename + "_" + pagename, pid);
        PrpRootObject so = hackFactory.createSceneObject(sn, pagename + "_so", pid);
        sn.castToSceneNode().addToObjectrefs1(so.header.desc.toRef());
        PrpRootObject[] clustergroups = prp.FindAllObjectsOfType(Typeid.plClusterGroup);
        Vector<PrpRootObject> movedobjects = new Vector<PrpRootObject>();
        for (PrpRootObject clustergroup : clustergroups) {
            plClusterGroup plcg = (plClusterGroup)clustergroup.castTo();
            plcg.count2 = 0;
            plcg.fRegions = new Uruobjectref[0];
            clustergroup.header.desc.objectname = Urustring.createFromString(clustergroup.header.desc.objectname.toString() + "_" + pagename);
            PrpRootObject movedCG = fixCraters.movePrpRootObject(clustergroup, movedobjects, pid, sn, prp, false);
            clustergroup.tagDeleted = true;
            sn.castTo(x0000Scenenode.class).addToObjectrefs2(movedCG.header.desc.toRef());
        }
        movedobjects.add(so);
        movedobjects.add(sn);
        prpfile newprp = prpfile.createFromObjectsAndInfo(movedobjects, agename, pagename, pid, Pagetype.createDefault());
        newprp.saveAsFile(outfolder + "/dat/" + agename + "_District_" + pagename + ".prp");
    }

    public static PrpRootObject movePrpRootObject(PrpRootObject objToMove, Vector<PrpRootObject> movedObjects, Pageid pid, PrpRootObject scenenode, prpfile prp, boolean deleteOriginal) {
        if (deleteOriginal) {
            objToMove.tagDeleted = true;
        }
        Uruobjectdesc desc = Uruobjectdesc.createDefaultWithTypeNamePage(objToMove.header.desc.objecttype, objToMove.header.desc.objectname.toString(), pid);
        PrpRootObject newclustergroup = PrpRootObject.createFromDescAndObject(desc, objToMove.getObject());
        m.msg("moving object from ", objToMove.header.desc.toString() + " to " + newclustergroup.header.desc.toString());
        movedObjects.add(newclustergroup);
        Vector<Uruobjectref> refs = FindAllDescendants.FindAllDescendantsByClass(Uruobjectref.class, newclustergroup);
        for (Uruobjectref ref : refs) {
            if (!ref.hasref()) continue;
            if (ref.xdesc.objecttype == Typeid.plSceneNode) {
                m.msg("modifying scenenode from ", ref.xdesc.toString() + " to " + scenenode.header.desc.toString());
                ref.xdesc = scenenode.header.desc;
                continue;
            }
            if (fixCraters.objectsContainDesc(movedObjects, ref.xdesc)) {
                m.msg("already moved obj ", ref.xdesc.toString() + " new pageid is " + pid.toString());
                ref.xdesc.pageid = pid;
                continue;
            }
            if (ref.xdesc.objecttype == Typeid.plCubicEnvironMap || ref.xdesc.objecttype == Typeid.plMipMap) {
                m.msg("not moving texture ", ref.xdesc.toString());
                continue;
            }
            PrpRootObject dependency = prp.findObjectWithRef(ref);
            fixCraters.movePrpRootObject(dependency, movedObjects, pid, scenenode, prp, deleteOriginal);
            ref.xdesc.pageid = pid;
        }
        return newclustergroup;
    }

    public static boolean objectsContainDesc(Vector<PrpRootObject> objs, Uruobjectdesc desc) {
        for (PrpRootObject obj : objs) {
            if (!obj.header.desc.objectname.equals(desc.objectname) || !obj.header.desc.objecttype.equals(desc.objecttype)) continue;
            return true;
        }
        return false;
    }
}

