/*
 * Decompiled with CFR 0.152.
 */
package pythondec3.ast;

import java.util.ArrayDeque;
import java.util.Iterator;
import pythondec3.ast.Ast;
import pythondec3.ast.Stmt;
import pythondec3.ast.StmtAssign;
import shared.m;

public class sgen {
    private int indentation = 0;
    private StringBuilder s = new StringBuilder();
    private static final String tab = "    ";
    private static final String endl = "\n";
    private ArrayDeque stack = new ArrayDeque();

    public String getGeneratedSource() {
        return this.s.toString();
    }

    private static void genModule(Ast mod, sgen s) {
        mod.gen(s);
        s.endline();
        s.endline();
    }

    void visit(Ast ast) {
        this.stack.push(ast);
    }

    void leave() {
        this.stack.pop();
    }

    void increaseindentation() {
        ++this.indentation;
    }

    void decreaseindentation() {
        --this.indentation;
        if (this.indentation < 0) {
            m.throwUncaughtException("Indentation went below zero.");
        }
    }

    void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.s.append(tab);
        }
    }

    void endline() {
        this.s.append(endl);
    }

    void out(String str) {
        this.s.append(str);
    }

    Ast getFirstImportantAncestor() {
        Iterator i = this.stack.descendingIterator();
        while (i.hasNext()) {
            Ast anc = (Ast)i.next();
            if (!anc.isimportant()) continue;
            return anc;
        }
        return null;
    }

    boolean isInFunction() {
        for (Ast anc : this.stack) {
            if (anc instanceof StmtAssign && ((StmtAssign)anc).isfunction) {
                return true;
            }
            if (!(anc instanceof Stmt.Classdef)) continue;
            return false;
        }
        return false;
    }

    public <T> T getFirstAncestorOfClass(Class<T> klass) {
        Iterator i = this.stack.descendingIterator();
        while (i.hasNext()) {
            Ast anc = (Ast)i.next();
            if (anc.getClass() != klass) continue;
            return (T)anc;
        }
        return null;
    }
}

