/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.bbox.JosmMapViewer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;

public class CoordinateInfoViewer
extends HistoryBrowserPanel {
    private LatLonViewer referenceLatLonViewer;
    private LatLonViewer currentLatLonViewer;
    private DistanceViewer distanceViewer;
    private MapViewer mapViewer;

    protected void build() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 0);
        gc.fill = 2;
        gc.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.anchor = 18;
        this.referenceLatLonViewer = new LatLonViewer(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceLatLonViewer, gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.anchor = 18;
        this.currentLatLonViewer = new LatLonViewer(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentLatLonViewer, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.distanceViewer = new DistanceViewer(this.model);
        this.add((Component)this.distanceViewer, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.mapViewer = new MapViewer(this.model);
        this.add((Component)this.mapViewer, gc);
        this.mapViewer.setZoomControlsVisible(false);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new RestoreCoordinateAction());
        this.setComponentPopupMenu(popupMenu);
        this.mapViewer.setComponentPopupMenu(popupMenu);
    }

    public CoordinateInfoViewer(HistoryBrowserModel model) {
        CheckParameterUtil.ensureParameterNotNull(model, "model");
        this.setModel(model);
        this.build();
        this.registerAsChangeListener(model);
    }

    @Override
    protected void unregisterAsChangeListener(HistoryBrowserModel model) {
        super.unregisterAsChangeListener(model);
        if (this.currentLatLonViewer != null) {
            model.removeChangeListener(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            model.removeChangeListener(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            model.removeChangeListener(this.distanceViewer);
        }
        if (this.mapViewer != null) {
            model.removeChangeListener(this.mapViewer);
        }
    }

    @Override
    protected void registerAsChangeListener(HistoryBrowserModel model) {
        super.registerAsChangeListener(model);
        if (this.currentLatLonViewer != null) {
            model.addChangeListener(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            model.addChangeListener(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            model.addChangeListener(this.distanceViewer);
        }
        if (this.mapViewer != null) {
            model.addChangeListener(this.mapViewer);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.referenceLatLonViewer.destroy();
        this.currentLatLonViewer.destroy();
        this.distanceViewer.destroy();
    }

    public void setDisplayToFitMapMarkers() {
        this.mapViewer.setDisplayToFitMapMarkers();
    }

    private static JosmTextArea newTextArea() {
        JosmTextArea area = new JosmTextArea();
        GuiHelper.setBackgroundReadable(area, Color.WHITE);
        area.setEditable(false);
        area.setOpaque(true);
        area.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        area.setFont(UIManager.getFont("Label.font"));
        return area;
    }

    static /* synthetic */ JosmTextArea access$000() {
        return CoordinateInfoViewer.newTextArea();
    }

    private static class LatLonViewer
    extends JPanel
    implements ChangeListener,
    Destroyable {
        private final JosmTextArea lblLat = CoordinateInfoViewer.access$000();
        private final JosmTextArea lblLon = CoordinateInfoViewer.access$000();
        private final transient Updater updater;
        private final Color modifiedColor;

        protected void build() {
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Latitude: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.lblLat, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Longitude: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.lblLon, gc);
        }

        LatLonViewer(HistoryBrowserModel model, PointInTimeType role) {
            super(new GridBagLayout());
            this.updater = new Updater(model, role);
            this.modifiedColor = PointInTimeType.CURRENT_POINT_IN_TIME == role ? TwoColumnDiff.Item.DiffItemType.INSERTED.getColor() : TwoColumnDiff.Item.DiffItemType.DELETED.getColor();
            this.build();
        }

        protected void refresh() {
            Pair<LatLon, LatLon> coordinates = this.updater.getCoordinates();
            if (coordinates == null) {
                return;
            }
            LatLon coord = (LatLon)coordinates.a;
            LatLon oppositeCoord = (LatLon)coordinates.b;
            this.lblLat.setText(coord != null ? DecimalDegreesCoordinateFormat.INSTANCE.latToString(coord) : I18n.tr("(none)", new Object[0]));
            this.lblLon.setText(coord != null ? DecimalDegreesCoordinateFormat.INSTANCE.lonToString(coord) : I18n.tr("(none)", new Object[0]));
            if (coord == oppositeCoord || coord != null && oppositeCoord != null && coord.lat() == oppositeCoord.lat()) {
                GuiHelper.setBackgroundReadable(this.lblLat, Color.WHITE);
            } else {
                GuiHelper.setBackgroundReadable(this.lblLat, this.modifiedColor);
            }
            if (coord == oppositeCoord || coord != null && oppositeCoord != null && coord.lon() == oppositeCoord.lon()) {
                GuiHelper.setBackgroundReadable(this.lblLon, Color.WHITE);
            } else {
                GuiHelper.setBackgroundReadable(this.lblLon, this.modifiedColor);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        @Override
        public void destroy() {
            this.lblLat.destroy();
            this.lblLon.destroy();
        }
    }

    private static class DistanceViewer
    extends JPanel
    implements ChangeListener,
    Destroyable {
        private final JosmTextArea lblDistance = CoordinateInfoViewer.access$000();
        private final transient Updater updater;

        DistanceViewer(HistoryBrowserModel model) {
            super(new GridBagLayout());
            this.updater = new Updater(model, PointInTimeType.REFERENCE_POINT_IN_TIME);
            this.build();
        }

        protected void build() {
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Distance: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.lblDistance, gc);
        }

        protected void refresh() {
            Pair<LatLon, LatLon> coordinates = this.updater.getCoordinates();
            if (coordinates == null) {
                return;
            }
            LatLon coord = (LatLon)coordinates.a;
            LatLon oppositeCoord = (LatLon)coordinates.b;
            if (coord != null && oppositeCoord != null) {
                double distance = coord.greatCircleDistance(oppositeCoord);
                GuiHelper.setBackgroundReadable(this.lblDistance, distance > 0.0 ? TwoColumnDiff.Item.DiffItemType.CHANGED.getColor() : Color.WHITE);
                this.lblDistance.setText(NavigatableComponent.getDistText(distance));
            } else {
                GuiHelper.setBackgroundReadable(this.lblDistance, coord != oppositeCoord ? TwoColumnDiff.Item.DiffItemType.CHANGED.getColor() : Color.WHITE);
                this.lblDistance.setText(I18n.tr("(none)", new Object[0]));
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        @Override
        public void destroy() {
            this.lblDistance.destroy();
        }
    }

    private static class MapViewer
    extends JosmMapViewer
    implements ChangeListener {
        private final transient Updater updater;

        MapViewer(HistoryBrowserModel model) {
            this.updater = new Updater(model, PointInTimeType.REFERENCE_POINT_IN_TIME);
            this.setTileSource(JosmMapViewer.DefaultOsmTileSourceProvider.get());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.getAttribution().handleAttribution(e.getPoint(), true);
                    }
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Pair<LatLon, LatLon> coordinates = this.updater.getCoordinates();
            if (coordinates == null) {
                return;
            }
            this.removeAllMapMarkers();
            if (coordinates.a != null) {
                MapMarkerDot oldMarker = new MapMarkerDot(((LatLon)coordinates.a).lat(), ((LatLon)coordinates.a).lon());
                oldMarker.setBackColor(TwoColumnDiff.Item.DiffItemType.DELETED.getColor());
                this.addMapMarker(oldMarker);
            }
            if (coordinates.b != null) {
                MapMarkerDot newMarker = new MapMarkerDot(((LatLon)coordinates.b).lat(), ((LatLon)coordinates.b).lon());
                newMarker.setBackColor(TwoColumnDiff.Item.DiffItemType.INSERTED.getColor());
                this.addMapMarker(newMarker);
            }
            super.setDisplayToFitMapMarkers();
        }
    }

    private class RestoreCoordinateAction
    extends AbstractAction {
        RestoreCoordinateAction() {
            super(I18n.tr("Restore", new Object[0]));
            new ImageProvider("undo").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OsmPrimitive primitive = CoordinateInfoViewer.this.getPrimitiveFromDataSet(PointInTimeType.REFERENCE_POINT_IN_TIME);
            if (!(primitive instanceof Node)) {
                return;
            }
            HistoryOsmPrimitive historyPrimitive = CoordinateInfoViewer.this.model.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
            if (!(historyPrimitive instanceof HistoryNode) || ((HistoryNode)historyPrimitive).getCoords() == null) {
                return;
            }
            MoveCommand command = new MoveCommand((Node)primitive, ((HistoryNode)historyPrimitive).getCoords());
            UndoRedoHandler.getInstance().add(command);
        }
    }

    private static class Updater {
        private final HistoryBrowserModel model;
        private final PointInTimeType role;

        protected Updater(HistoryBrowserModel model, PointInTimeType role) {
            this.model = model;
            this.role = role;
        }

        protected HistoryOsmPrimitive getPrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role);
        }

        protected HistoryOsmPrimitive getOppositePrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role.opposite());
        }

        protected final Pair<LatLon, LatLon> getCoordinates() {
            HistoryOsmPrimitive p = this.getPrimitive();
            if (!(p instanceof HistoryNode)) {
                return null;
            }
            HistoryOsmPrimitive opposite = this.getOppositePrimitive();
            if (!(opposite instanceof HistoryNode)) {
                return null;
            }
            HistoryNode node = (HistoryNode)p;
            HistoryNode oppositeNode = (HistoryNode)opposite;
            return Pair.create(node.getCoords(), oppositeNode.getCoords());
        }
    }
}

