/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.preferences;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractPreferences
implements IPreferences {
    @Override
    public synchronized String get(String key, String def) {
        return (String)this.getSetting(key, new StringSetting(def), StringSetting.class).getValue();
    }

    @Override
    public boolean put(String key, String value) {
        return this.putSetting(key, value == null || value.isEmpty() ? null : new StringSetting(value));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return Boolean.parseBoolean(this.get(key, Boolean.toString(def)));
    }

    @Override
    public boolean putBoolean(String key, boolean value) {
        return this.put(key, Boolean.toString(value));
    }

    @Override
    public synchronized int getInt(String key, int def) {
        String v = this.get(key, Integer.toString(def));
        if (v.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return def;
        }
    }

    @Override
    public boolean putInt(String key, int value) {
        return this.put(key, Integer.toString(value));
    }

    @Override
    public long getLong(String key, long def) {
        String v = this.get(key, Long.toString(def));
        if (null == v) {
            return def;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return def;
        }
    }

    @Override
    public boolean putLong(String key, long value) {
        return this.put(key, Long.toString(value));
    }

    @Override
    public synchronized double getDouble(String key, double def) {
        String v = this.get(key, Double.toString(def));
        if (null == v) {
            return def;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return def;
        }
    }

    @Override
    public boolean putDouble(String key, double value) {
        return this.put(key, Double.toString(value));
    }

    @Override
    public List<String> getList(String key, List<String> def) {
        return (List)this.getSetting(key, new ListSetting(def), ListSetting.class).getValue();
    }

    @Override
    public boolean putList(String key, List<String> value) {
        return this.putSetting(key, value == null ? null : new ListSetting(value));
    }

    @Override
    public List<List<String>> getListOfLists(String key, List<List<String>> def) {
        return (List)this.getSetting(key, new ListListSetting(def), ListListSetting.class).getValue();
    }

    @Override
    public boolean putListOfLists(String key, List<List<String>> value) {
        return this.putSetting(key, value == null ? null : new ListListSetting(value));
    }

    @Override
    public List<Map<String, String>> getListOfMaps(String key, List<Map<String, String>> def) {
        return (List)this.getSetting(key, new MapListSetting(def), MapListSetting.class).getValue();
    }

    @Override
    public boolean putListOfMaps(String key, List<Map<String, String>> value) {
        return this.putSetting(key, value == null ? null : new MapListSetting(value));
    }

    public abstract Map<String, Setting<?>> getAllSettings();

    public abstract boolean putSetting(String var1, Setting<?> var2);

    public abstract <T extends Setting<?>> T getSetting(String var1, T var2, Class<T> var3);

    public Map<String, String> getAllPrefix(String prefix) {
        return this.getAllSettings().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix) && e.getValue() instanceof StringSetting).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((StringSetting)e.getValue()).getValue(), (a, b) -> b, TreeMap::new));
    }

    public List<String> getAllPrefixCollectionKeys(String prefix) {
        return this.getAllSettings().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix) && entry.getValue() instanceof ListSetting).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedList::new));
    }
}

