/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookOsx
implements PlatformHook,
InvocationHandler {
    private String oSBuildNumber;
    private PlatformHook.NativeOsCallback osCallback;

    @Override
    public Platform getPlatform() {
        return Platform.OSX;
    }

    @Override
    public void preStartupHook() {
        Utils.updateSystemProperty("apple.laf.useScreenMenuBar", "true");
        Utils.updateSystemProperty("apple.awt.application.name", "JOSM");
    }

    @Override
    public void startupHook(PlatformHook.JavaExpirationCallback javaCallback, PlatformHook.WebStartMigrationCallback webStartCallback) {
        try {
            Class<?> eawtApplication = Class.forName("com.apple.eawt.Application");
            Class<?> quitHandler = this.findHandlerClass("QuitHandler");
            Class<?> aboutHandler = this.findHandlerClass("AboutHandler");
            Class<?> openFilesHandler = this.findHandlerClass("OpenFilesHandler");
            Class<?> preferencesHandler = this.findHandlerClass("PreferencesHandler");
            Object proxy = Proxy.newProxyInstance(PlatformHookOsx.class.getClassLoader(), new Class[]{quitHandler, aboutHandler, openFilesHandler, preferencesHandler}, (InvocationHandler)this);
            Object appli = eawtApplication.getConstructor(null).newInstance(null);
            if (Utils.getJavaVersion() < 9) {
                this.setHandlers(eawtApplication, quitHandler, aboutHandler, openFilesHandler, preferencesHandler, proxy, appli);
                eawtApplication.getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE).invoke(appli, Boolean.TRUE);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setHandlers(Desktop.class, quitHandler, aboutHandler, openFilesHandler, preferencesHandler, proxy, Desktop.getDesktop());
            }
            eawtApplication.getDeclaredMethod("setDockIconImage", Image.class).invoke(appli, Optional.ofNullable(new ImageProvider(Config.getUrls().getJOSMWebsite() + "/logo-macos.png").setOptional(true).get()).orElse(ImageProvider.get("logo")).getImage());
            PlatformHookOsx.enableOSXFullscreen(MainApplication.getMainFrame());
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            Logging.warn("Failed to register with macOS: " + ex);
        }
        this.checkExpiredJava(javaCallback);
        this.checkWebStartMigration(webStartCallback);
    }

    @Override
    public int getMenuShortcutKeyMaskEx() {
        return 256;
    }

    protected void setHandlers(Class<?> appClass, Class<?> quitHandler, Class<?> aboutHandler, Class<?> openFilesHandler, Class<?> preferencesHandler, Object proxy, Object appInstance) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        appClass.getDeclaredMethod("setQuitHandler", quitHandler).invoke(appInstance, proxy);
        appClass.getDeclaredMethod("setAboutHandler", aboutHandler).invoke(appInstance, proxy);
        appClass.getDeclaredMethod("setOpenFileHandler", openFilesHandler).invoke(appInstance, proxy);
        appClass.getDeclaredMethod("setPreferencesHandler", preferencesHandler).invoke(appInstance, proxy);
    }

    protected Class<?> findHandlerClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName("com.apple.eawt." + className);
        }
        catch (ClassNotFoundException e) {
            Logging.trace(e);
            return Class.forName("java.awt.desktop." + className);
        }
    }

    public static void enableOSXFullscreen(Window window) {
        CheckParameterUtil.ensureParameterNotNull(window, "window");
        try {
            Class<?> eawtFullScreenUtilities = Class.forName("com.apple.eawt.FullScreenUtilities");
            eawtFullScreenUtilities.getDeclaredMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE).invoke(eawtFullScreenUtilities, window, Boolean.TRUE);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            Logging.warn("Failed to register with macOS: " + e);
        }
    }

    @Override
    public void setNativeOsCallback(PlatformHook.NativeOsCallback callback) {
        this.osCallback = Objects.requireNonNull(callback);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Logging.isDebugEnabled()) {
            Logging.debug("macOS handler: {0} - {1}", method.getName(), Arrays.toString(args));
        }
        switch (method.getName()) {
            case "openFiles": {
                if (args[0] == null) break;
                try {
                    Object oFiles = args[0].getClass().getMethod("getFiles", new Class[0]).invoke(args[0], new Object[0]);
                    if (!(oFiles instanceof List)) break;
                    this.osCallback.openFiles((List)oFiles);
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                    Logging.warn("Failed to access open files event: " + ex);
                }
                break;
            }
            case "handleQuitRequestWith": {
                boolean closed = this.osCallback.handleQuitRequest();
                if (args[1] == null) break;
                try {
                    args[1].getClass().getDeclaredMethod(closed ? "performQuit" : "cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
                }
                catch (IllegalAccessException e) {
                    Logging.debug(e);
                    Class.forName("java.awt.desktop.QuitResponse").getMethod(closed ? "performQuit" : "cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
                }
                break;
            }
            case "handleAbout": {
                this.osCallback.handleAbout();
                break;
            }
            case "handlePreferences": {
                this.osCallback.handlePreferences();
                break;
            }
            default: {
                Logging.warn("macOS unsupported method: " + method.getName());
            }
        }
        return null;
    }

    @Override
    public void openUrl(String url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", url});
    }

    @Override
    public void initSystemShortcuts() {
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-01", I18n.tr("reserved", new Object[0]), 32, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-02", I18n.tr("reserved", new Object[0]), 32, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-03", I18n.tr("reserved", new Object[0]), 32, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-04", I18n.tr("reserved", new Object[0]), 32, 384));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-05", I18n.tr("reserved", new Object[0]), 9, 64));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-06", I18n.tr("reserved", new Object[0]), 9, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-07", I18n.tr("reserved", new Object[0]), 9, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-08", I18n.tr("reserved", new Object[0]), 9, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-09", I18n.tr("reserved", new Object[0]), 9, 192));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-10", I18n.tr("reserved", new Object[0]), 27, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-11", I18n.tr("reserved", new Object[0]), 27, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-12", I18n.tr("reserved", new Object[0]), 112, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-13", I18n.tr("reserved", new Object[0]), 113, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-14", I18n.tr("reserved", new Object[0]), 114, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-15", I18n.tr("reserved", new Object[0]), 115, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-16", I18n.tr("reserved", new Object[0]), 115, 192));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-17", I18n.tr("reserved", new Object[0]), 116, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-18", I18n.tr("reserved", new Object[0]), 116, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-19", I18n.tr("reserved", new Object[0]), 117, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-20", I18n.tr("reserved", new Object[0]), 117, 192));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-21", I18n.tr("reserved", new Object[0]), 118, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-26", I18n.tr("reserved", new Object[0]), 128, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-27", I18n.tr("reserved", new Object[0]), 128, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-28", I18n.tr("reserved", new Object[0]), 128, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-30", I18n.tr("reserved", new Object[0]), 45, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:preferences", I18n.tr("reserved", new Object[0]), 44, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-31", I18n.tr("reserved", new Object[0]), 44, 832));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-32", I18n.tr("reserved", new Object[0]), 46, 832));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-33", I18n.tr("reserved", new Object[0]), 47, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-34", I18n.tr("reserved", new Object[0]), 61, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-35", I18n.tr("reserved", new Object[0]), 61, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-36", I18n.tr("reserved", new Object[0]), 51, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-37", I18n.tr("reserved", new Object[0]), 51, 448));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-38", I18n.tr("reserved", new Object[0]), 52, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-39", I18n.tr("reserved", new Object[0]), 52, 448));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-40", I18n.tr("reserved", new Object[0]), 56, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-41", I18n.tr("reserved", new Object[0]), 56, 896));
        Shortcut.registerSystemShortcut("system:selectall", I18n.tr("reserved", new Object[0]), 65, 256);
        Shortcut.registerSystemShortcut("system:copy", I18n.tr("reserved", new Object[0]), 67, 256);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-42", I18n.tr("reserved", new Object[0]), 68, 768));
        Shortcut.registerSystemShortcut("system:dictionarylookup", I18n.tr("reserved", new Object[0]), 68, 384);
        Shortcut.registerSystemShortcut("system:find", I18n.tr("reserved", new Object[0]), 70, 256);
        Shortcut.registerSystemShortcut("system:search", I18n.tr("reserved", new Object[0]), 70, 768);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:hide", I18n.tr("reserved", new Object[0]), 72, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:hideothers", I18n.tr("reserved", new Object[0]), 72, 768));
        Shortcut.registerSystemShortcut("system:new", I18n.tr("reserved", new Object[0]), 78, 256);
        Shortcut.registerSystemShortcut("system:open", I18n.tr("reserved", new Object[0]), 79, 256);
        Shortcut.registerSystemShortcut("system:print", I18n.tr("reserved", new Object[0]), 80, 256);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:menuexit", I18n.tr("reserved", new Object[0]), 81, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-43", I18n.tr("reserved", new Object[0]), 81, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-44", I18n.tr("reserved", new Object[0]), 81, 832));
        Shortcut.registerSystemShortcut("system:save", I18n.tr("reserved", new Object[0]), 83, 256);
        Shortcut.registerSystemShortcut("system:saveas", I18n.tr("reserved", new Object[0]), 83, 320);
        Shortcut.registerSystemShortcut("system:toggletoolbar", I18n.tr("reserved", new Object[0]), 84, 768);
        Shortcut.registerSystemShortcut("system:paste", I18n.tr("reserved", new Object[0]), 86, 256);
        Shortcut.registerSystemShortcut("system:closefile", I18n.tr("reserved", new Object[0]), 87, 320);
        Shortcut.registerSystemShortcut("system:closeallwindows", I18n.tr("reserved", new Object[0]), 87, 768);
        Shortcut.registerSystemShortcut("system:cut", I18n.tr("reserved", new Object[0]), 88, 256);
        Shortcut.registerSystemShortcut("system:undo", I18n.tr("reserved", new Object[0]), 90, 256);
        Shortcut.registerSystemShortcut("system:redo", I18n.tr("reserved", new Object[0]), 90, 320);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-45", I18n.tr("reserved", new Object[0]), 39, 256));
        Shortcut.registerSystemShortcut("system:movefocusright", I18n.tr("reserved", new Object[0]), 39, 128);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-49", I18n.tr("reserved", new Object[0]), 37, 256));
        Shortcut.registerSystemShortcut("system:movefocusleft", I18n.tr("reserved", new Object[0]), 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", I18n.tr("reserved", new Object[0]), 38, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", I18n.tr("reserved", new Object[0]), 40, 128);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:about", I18n.tr("reserved", new Object[0]), 0, -1));
        Shortcut.registerSystemShortcut("view:zoomin", I18n.tr("reserved", new Object[0]), 107, 256);
        Shortcut.registerSystemShortcut("view:zoomout", I18n.tr("reserved", new Object[0]), 109, 256);
    }

    private static void auto(Shortcut sc) {
        if (sc != null) {
            sc.setAutomatic();
        }
    }

    @Override
    public String getDefaultStyle() {
        return "com.apple.laf.AquaLookAndFeel";
    }

    @Override
    public boolean canFullscreen() {
        return false;
    }

    @Override
    public String getOSDescription() {
        return Utils.getSystemProperty("os.name") + ' ' + Utils.getSystemProperty("os.version");
    }

    private String buildOSBuildNumber() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.exec("sw_vers", "-productName")).append(' ').append(this.exec("sw_vers", "-productVersion")).append(" (").append(this.exec("sw_vers", "-buildVersion")).append(')');
        }
        catch (IOException e) {
            Logging.error(e);
        }
        return sb.toString();
    }

    @Override
    public String getOSBuildNumber() {
        if (this.oSBuildNumber == null) {
            this.oSBuildNumber = this.buildOSBuildNumber();
        }
        return this.oSBuildNumber;
    }

    @Override
    public File getDefaultCacheDirectory() {
        return new File(Utils.getSystemProperty("user.home") + "/Library/Caches", Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultPrefDirectory() {
        return new File(Utils.getSystemProperty("user.home") + "/Library/Preferences", Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultUserDataDirectory() {
        return new File(Utils.getSystemProperty("user.home") + "/Library", Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public X509Certificate getX509Certificate(CertificateAmendment.NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        for (String macAlias : certAmend.getNativeAliases()) {
            try {
                String pem = Utils.execOutput(Arrays.asList("security", "find-certificate", "-c", macAlias, "-p", "/System/Library/Keychains/SystemRootCertificates.keychain"));
                Logging.debug(pem);
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IllegalArgumentException | InterruptedException | CertificateException | ExecutionException e) {
                Logging.debug(e);
            }
        }
        return null;
    }
}

