/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.ToggleUploadDiscouragedLayerAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxExtensionCollection;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.HighlightUpdateListener;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.data.OsmLayerTransferData;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadLayerTask;
import org.openstreetmap.josm.gui.io.importexport.NoteExporter;
import org.openstreetmap.josm.gui.io.importexport.OsmExporter;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.io.importexport.ValidatorErrorExporter;
import org.openstreetmap.josm.gui.io.importexport.WMSLayerImporter;
import org.openstreetmap.josm.gui.layer.AbstractOsmDataLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.LruCache;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OsmDataLayer
extends AbstractOsmDataLayer
implements DataSetListenerAdapter.Listener,
DataSelectionListener,
HighlightUpdateListener {
    private static final int HATCHED_SIZE = 15;
    private static final String IS_EMPTY_SYMBOL = "\u2205";
    private static final String IS_DIRTY_SYMBOL = "*";
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile;
    private boolean requiresUploadToServer;
    private final AtomicBoolean isUploadInProgress;
    public final List<TestError> validationErrors;
    public static final int DEFAULT_RECENT_RELATIONS_NUMBER = 20;
    public static final IntegerProperty PROPERTY_RECENT_RELATIONS_NUMBER = new IntegerProperty("properties.last-closed-relations-size", 20);
    public static final StringProperty PROPERTY_SAVE_EXTENSION = new StringProperty("save.extension.osm", "osm");
    public static final BooleanProperty PROPERTY_HIDE_LABELS_WHILE_DRAGGING = new BooleanProperty("mappaint.hide.labels.while.dragging", true);
    private static final NamedColorProperty PROPERTY_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("background"), Color.BLACK);
    private static final NamedColorProperty PROPERTY_OUTSIDE_COLOR = new NamedColorProperty(I18n.marktr("outside downloaded area"), Color.YELLOW);
    private final Map<Relation, Void> recentRelations;
    private static final AtomicInteger dataLayerCounter = new AtomicInteger();
    private final CopyOnWriteArrayList<LayerStateChangeListener> layerStateChangeListeners;
    public final DataSet data;
    private final DataSetListenerAdapter dataSetListenerAdapter;
    private static volatile BufferedImage hatched;

    public List<Relation> getRecentRelations() {
        ArrayList<Relation> list = new ArrayList<Relation>(this.recentRelations.keySet());
        Collections.reverse(list);
        return list;
    }

    public void setRecentRelation(Relation relation) {
        this.recentRelations.put(relation, null);
        MapFrame map = MainApplication.getMap();
        if (map != null && map.relationListDialog != null) {
            map.relationListDialog.enableRecentRelations();
        }
    }

    public void removeRecentRelation(Relation relation) {
        this.recentRelations.remove(relation);
        MapFrame map = MainApplication.getMap();
        if (map != null && map.relationListDialog != null) {
            map.relationListDialog.enableRecentRelations();
        }
    }

    protected void setRequiresSaveToFile(boolean newValue) {
        boolean oldValue = this.requiresSaveToFile;
        this.requiresSaveToFile = newValue;
        if (oldValue != newValue) {
            GuiHelper.runInEDT(() -> this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, oldValue, newValue));
        }
    }

    protected void setRequiresUploadToServer(boolean newValue) {
        boolean oldValue = this.requiresUploadToServer;
        this.requiresUploadToServer = newValue;
        if (oldValue != newValue) {
            GuiHelper.runInEDT(() -> this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, oldValue, newValue));
        }
    }

    public static String createNewName() {
        return OsmDataLayer.createLayerName(dataLayerCounter.incrementAndGet());
    }

    static String createLayerName(Object arg) {
        return I18n.tr("Data Layer {0}", arg);
    }

    public void addLayerStateChangeListener(LayerStateChangeListener listener) {
        if (listener != null) {
            this.layerStateChangeListeners.addIfAbsent(listener);
        }
    }

    public void removeLayerStateChangeListener(LayerStateChangeListener listener) {
        this.layerStateChangeListeners.remove(listener);
    }

    public static Color getBackgroundColor() {
        return PROPERTY_BACKGROUND_COLOR.get();
    }

    public static Color getOutsideColor() {
        return PROPERTY_OUTSIDE_COLOR.get();
    }

    public static void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(OsmDataLayer.getBackgroundColor());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(OsmDataLayer.getOutsideColor());
        big.drawLine(-1, 6, 6, -1);
        big.drawLine(4, 16, 16, 4);
        hatched = bi;
    }

    public OsmDataLayer(DataSet data, String name, File associatedFile) {
        block1: {
            int i;
            super(name);
            this.isUploadInProgress = new AtomicBoolean(false);
            this.validationErrors = new ArrayList<TestError>();
            this.recentRelations = new LruCache<Relation, Void>(PROPERTY_RECENT_RELATIONS_NUMBER.get());
            this.layerStateChangeListeners = new CopyOnWriteArrayList();
            CheckParameterUtil.ensureParameterNotNull(data, "data");
            this.data = data;
            this.data.setName(name);
            this.dataSetListenerAdapter = new DataSetListenerAdapter(this);
            this.setAssociatedFile(associatedFile);
            data.addDataSetListener(this.dataSetListenerAdapter);
            data.addDataSetListener(MultipolygonCache.getInstance());
            data.addHighlightUpdateListener(this);
            data.addSelectionListener(this);
            if (name == null || !name.startsWith(OsmDataLayer.createLayerName("")) || !Character.isDigit((name.substring(OsmDataLayer.createLayerName("").length()) + "XX").charAt(1))) break block1;
            while (AlphanumComparator.getInstance().compare(OsmDataLayer.createLayerName(dataLayerCounter), name) < 0 && (i = dataLayerCounter.incrementAndGet()) <= 1000000) {
            }
        }
    }

    public DataSet getDataSet() {
        return this.data;
    }

    protected ImageProvider getBaseIconProvider() {
        return new ImageProvider("layer", "osmdata_small");
    }

    @Override
    public Icon getIcon() {
        ImageProvider base = this.getBaseIconProvider().setMaxSize(ImageProvider.ImageSizes.LAYER);
        if (this.data.getDownloadPolicy() != null && this.data.getDownloadPolicy() != DownloadPolicy.NORMAL) {
            base.addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.0, 1.0, 0.5));
        }
        if (this.data.getUploadPolicy() != null && this.data.getUploadPolicy() != UploadPolicy.NORMAL) {
            base.addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0));
        }
        if (this.isUploadInProgress()) {
            base = new ImageProvider("clock").setMaxSize(ImageProvider.ImageSizes.LAYER);
        } else if (this.isLocked()) {
            base = new ImageProvider("lock").setMaxSize(ImageProvider.ImageSizes.LAYER);
        }
        return base.get();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean virtual;
        boolean active = mv.getLayerManager().getActiveLayer() == this;
        boolean inactive = !active && Config.getPref().getBoolean("draw.data.inactive_color", true);
        boolean bl = virtual = !inactive && mv.isVirtualNodesEnabled();
        if (active && DrawingPreference.SOURCE_BOUNDS_PROP.get().booleanValue() && !this.data.getDataSources().isEmpty()) {
            Rectangle b = mv.getBounds();
            b.grow(100, 100);
            Path2D.Double p = new Path2D.Double();
            for (Bounds bounds : this.data.getDataSourceBounds()) {
                if (bounds.isCollapsed()) continue;
                p.append(mv.getState().getArea(bounds), false);
            }
            Area a = new Area(b);
            a.subtract(new Area(p));
            MapViewState.MapViewPoint anchor = mv.getState().getPointFor(new EastNorth(0.0, 0.0));
            Rectangle2D.Double anchorRect = new Rectangle2D.Double(anchor.getInView().getX() % 15.0, anchor.getInView().getY() % 15.0, 15.0, 15.0);
            if (hatched != null) {
                g.setPaint(new TexturePaint(hatched, anchorRect));
            }
            try {
                g.fill(a);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logging.error(e);
            }
        }
        AbstractMapRenderer painter = MapRendererFactory.getInstance().createActiveRenderer(g, mv, inactive);
        painter.enableSlowOperations(mv.getMapMover() == null || !mv.getMapMover().movementInProgress() || PROPERTY_HIDE_LABELS_WHILE_DRAGGING.get() == false);
        painter.render(this.data, virtual, box);
        MainApplication.getMap().conflictDialog.paintConflicts(g, mv);
    }

    @Override
    public String getToolTipText() {
        DataCountVisitor counter = new DataCountVisitor();
        for (OsmPrimitive osm : this.data.allPrimitives()) {
            osm.accept(counter);
        }
        int nodes = counter.nodes - counter.deletedNodes;
        int ways = counter.ways - counter.deletedWays;
        int rels = counter.relations - counter.deletedRelations;
        StringBuilder tooltip = new StringBuilder("<html>").append(I18n.trn("{0} node", "{0} nodes", nodes, nodes)).append("<br>").append(I18n.trn("{0} way", "{0} ways", ways, ways)).append("<br>").append(I18n.trn("{0} relation", "{0} relations", rels, rels));
        File f = this.getAssociatedFile();
        if (f != null) {
            tooltip.append("<br>").append(f.getPath());
        }
        tooltip.append("</html>");
        return tooltip.toString();
    }

    @Override
    public void mergeFrom(Layer from) {
        PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Merging layers", new Object[0]));
        monitor.setCancelable(false);
        if (from instanceof OsmDataLayer && ((OsmDataLayer)from).isUploadDiscouraged()) {
            this.setUploadDiscouraged(true);
        }
        this.mergeFrom(((OsmDataLayer)from).data, monitor);
        monitor.close();
    }

    public void mergeFrom(DataSet from) {
        this.mergeFrom(from, null);
    }

    public void mergeFrom(DataSet from, ProgressMonitor progressMonitor) {
        DataSetMerger visitor = new DataSetMerger(this.data, from);
        try {
            visitor.merge(progressMonitor);
        }
        catch (DataIntegrityProblemException e) {
            Logging.error(e);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getHtmlMessage() != null ? e.getHtmlMessage() : e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        int numNewConflicts = 0;
        for (Conflict<?> c : visitor.getConflicts()) {
            if (this.data.getConflicts().hasConflict(c)) continue;
            ++numNewConflicts;
            this.data.getConflicts().add(c);
        }
        this.invalidate();
        MapFrame map = MainApplication.getMap();
        if (numNewConflicts > 0 && map != null && map.conflictDialog != null) {
            map.conflictDialog.warnNumNewConflicts(numNewConflicts);
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node n : this.data.getNodes()) {
            if (!n.isUsable()) continue;
            v.visit(n);
        }
    }

    public void cleanupAfterUpload(Collection<? extends IPrimitive> processed) {
        if (processed == null || processed.isEmpty()) {
            return;
        }
        UndoRedoHandler.getInstance().clean(this.data);
        this.data.cleanupDeletedPrimitives();
        this.data.update(() -> {
            for (OsmPrimitive p : this.data.allPrimitives()) {
                if (!processed.contains(p)) continue;
                p.setModified(false);
            }
        });
    }

    private static String counterText(String text, int deleted, int incomplete) {
        StringBuilder sb = new StringBuilder(text);
        if (deleted > 0 || incomplete > 0) {
            sb.append(" (");
            if (deleted > 0) {
                sb.append(I18n.trn("{0} deleted", "{0} deleted", deleted, deleted));
            }
            if (deleted > 0 && incomplete > 0) {
                sb.append(", ");
            }
            if (incomplete > 0) {
                sb.append(I18n.trn("{0} incomplete", "{0} incomplete", incomplete, incomplete));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public Object getInfoComponent() {
        DataCountVisitor counter = new DataCountVisitor();
        for (OsmPrimitive osm : this.data.allPrimitives()) {
            osm.accept(counter);
        }
        JPanel p = new JPanel(new GridBagLayout());
        String nodeText = OsmDataLayer.counterText(I18n.trn("{0} node", "{0} nodes", counter.nodes, counter.nodes), counter.deletedNodes, counter.incompleteNodes);
        String wayText = OsmDataLayer.counterText(I18n.trn("{0} way", "{0} ways", counter.ways, counter.ways), counter.deletedWays, counter.incompleteWays);
        String relationText = OsmDataLayer.counterText(I18n.trn("{0} relation", "{0} relations", counter.relations, counter.relations), counter.deletedRelations, counter.incompleteRelations);
        p.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        p.add((Component)new JLabel(nodeText, ImageProvider.get("data", "node"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(wayText, ImageProvider.get("data", "way"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(relationText, ImageProvider.get("data", "relation"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(I18n.tr("API version: {0}", this.data.getVersion() != null ? this.data.getVersion() : I18n.tr("unset", new Object[0]))), GBC.eop().insets(15, 0, 0, 0));
        OsmDataLayer.addConditionalInformation(p, I18n.tr("Layer is locked", new Object[0]), this.isLocked());
        OsmDataLayer.addConditionalInformation(p, I18n.tr("Download is blocked", new Object[0]), this.data.getDownloadPolicy() == DownloadPolicy.BLOCKED);
        OsmDataLayer.addConditionalInformation(p, I18n.tr("Upload is discouraged", new Object[0]), this.isUploadDiscouraged());
        OsmDataLayer.addConditionalInformation(p, I18n.tr("Upload is blocked", new Object[0]), this.data.getUploadPolicy() == UploadPolicy.BLOCKED);
        OsmDataLayer.addConditionalInformation(p, "\u2205 " + I18n.tr("Empty layer", new Object[0]), this.getDataSet().isEmpty());
        OsmDataLayer.addConditionalInformation(p, "* " + I18n.tr("Unsaved changes", new Object[0]), this.isDirty());
        return p;
    }

    private static void addConditionalInformation(JPanel p, String text, boolean condition) {
        if (condition) {
            p.add((Component)new JLabel(text), GBC.eop().insets(15, 0, 0, 0));
        }
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>(Arrays.asList(LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), MainApplication.getMenu().autoScaleActions.get((Object)AutoScaleAction.AutoScaleMode.LAYER), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), LayerListDialog.getInstance().createDuplicateLayerAction(this), new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this)));
        if (ExpertToggleAction.isExpert()) {
            actions.addAll(Arrays.asList(new Layer.LayerGpxExportAction(this), new ConvertToGpxLayerAction()));
        }
        actions.addAll(Arrays.asList(Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this)));
        if (ExpertToggleAction.isExpert()) {
            actions.add(new ToggleUploadDiscouragedLayerAction(this));
        }
        actions.addAll(Arrays.asList(new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)));
        return actions.toArray(new Action[0]);
    }

    public static GpxData toGpxData(DataSet data, File file) {
        GpxData gpxData = new GpxData();
        if (data.getGPXNamespaces() != null) {
            gpxData.getNamespaces().addAll(data.getGPXNamespaces());
        }
        gpxData.storageFile = file;
        HashSet<Node> doneNodes = new HashSet<Node>();
        OsmDataLayer.waysToGpxData(data.getWays(), gpxData, doneNodes);
        OsmDataLayer.nodesToGpxData(data.getNodes(), gpxData, doneNodes);
        return gpxData;
    }

    private static void waysToGpxData(Collection<Way> ways, GpxData gpxData, Set<Node> doneNodes) {
        ways.stream().sorted(OsmPrimitiveComparator.comparingUniqueId().reversed()).forEachOrdered(w -> {
            if (!w.isUsable()) {
                return;
            }
            ArrayList<IGpxTrackSegment> trk = new ArrayList<IGpxTrackSegment>();
            HashMap<String, Object> trkAttr = new HashMap<String, Object>();
            GpxExtensionCollection trkExts = new GpxExtensionCollection();
            GpxExtensionCollection segExts = new GpxExtensionCollection();
            for (Map.Entry<String, String> e : w.getKeys().entrySet()) {
                String k = e.getKey().startsWith("gpx:") ? ((String)e.getKey()).substring("gpx:".length()) : (String)e.getKey();
                String v = (String)e.getValue();
                if (GpxConstants.RTE_TRK_KEYS.contains(k)) {
                    trkAttr.put(k, v);
                    continue;
                }
                k = GpxConstants.EXTENSION_ABBREVIATIONS.entrySet().stream().filter(s -> ((String)s.getValue()).equals(e.getKey())).map(s -> ((String)s.getKey()).substring("gpx:".length())).findAny().orElse(k);
                if (!k.startsWith("extension")) continue;
                String[] chain = k.split(":", -1);
                if (chain.length >= 3 && "segment".equals(chain[2])) {
                    segExts.addFlat(chain, v);
                    continue;
                }
                trkExts.addFlat(chain, v);
            }
            ArrayList<WayPoint> trkseg = new ArrayList<WayPoint>();
            for (Node n : w.getNodes()) {
                if (!n.isUsable()) {
                    if (trkseg.isEmpty()) continue;
                    trk.add(new GpxTrackSegment(trkseg));
                    trkseg.clear();
                    continue;
                }
                if (!n.isTagged() || OsmDataLayer.containsOnlyGpxTags(n)) {
                    doneNodes.add(n);
                }
                trkseg.add(OsmDataLayer.nodeToWayPoint(n));
            }
            trk.add(new GpxTrackSegment(trkseg));
            trk.forEach(gpxseg -> gpxseg.getExtensions().addAll(segExts));
            GpxTrack gpxtrk = new GpxTrack((List<IGpxTrackSegment>)trk, (Map<String, Object>)trkAttr);
            gpxtrk.getExtensions().addAll(trkExts);
            gpxData.addTrack(gpxtrk);
        });
    }

    private static boolean containsOnlyGpxTags(Tagged t) {
        return t.keys().allMatch(key -> GpxConstants.WPT_KEYS.contains(key) || key.startsWith("gpx:"));
    }

    public static String gpxVal(OsmPrimitive prim, String key) {
        return Optional.ofNullable(prim.get("gpx:" + key)).orElse(prim.get(key));
    }

    public static WayPoint nodeToWayPoint(Node n) {
        return OsmDataLayer.nodeToWayPoint(n, Long.MIN_VALUE);
    }

    public static WayPoint nodeToWayPoint(Node n, long time) {
        WayPoint wpt = new WayPoint(n.getCoor());
        OsmDataLayer.addDoubleIfPresent(wpt, n, "ele", new String[0]);
        try {
            if (time > Long.MIN_VALUE) {
                wpt.setTimeInMillis(time);
            } else {
                String v = OsmDataLayer.gpxVal(n, "time");
                if (v != null) {
                    wpt.setInstant(DateUtils.parseInstant(v));
                } else if (!n.isTimestampEmpty()) {
                    wpt.setInstant(n.getInstant());
                }
            }
        }
        catch (DateTimeException | UncheckedParseException e) {
            Logging.error(e);
        }
        OsmDataLayer.addDoubleIfPresent(wpt, n, "magvar", new String[0]);
        OsmDataLayer.addDoubleIfPresent(wpt, n, "geoidheight", new String[0]);
        OsmDataLayer.addStringIfPresent(wpt, n, "name", new String[0]);
        OsmDataLayer.addStringIfPresent(wpt, n, "desc", "description");
        OsmDataLayer.addStringIfPresent(wpt, n, "cmt", "comment");
        OsmDataLayer.addStringIfPresent(wpt, n, "src", "source", "source:position");
        Collection links = Stream.of("link", "url", "website", "contact:website").map(key -> OsmDataLayer.gpxVal(n, key)).filter(Objects::nonNull).map(GpxLink::new).collect(Collectors.toList());
        wpt.put("meta.links", links);
        OsmDataLayer.addStringIfPresent(wpt, n, "sym", "wpt_symbol");
        OsmDataLayer.addStringIfPresent(wpt, n, "type", new String[0]);
        OsmDataLayer.addStringIfPresent(wpt, n, "fix", "gps:fix");
        OsmDataLayer.addIntegerIfPresent(wpt, n, "sat", "gps:sat");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "hdop", "gps:hdop");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "vdop", "gps:vdop");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "pdop", "gps:pdop");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "ageofdgpsdata", "gps:ageofdgpsdata");
        OsmDataLayer.addIntegerIfPresent(wpt, n, "dgpsid", "gps:dgpsid");
        return wpt;
    }

    private static void nodesToGpxData(Collection<Node> nodes, GpxData gpxData, Set<Node> doneNodes) {
        ArrayList<Node> sortedNodes = new ArrayList<Node>(nodes);
        sortedNodes.removeAll(doneNodes);
        Collections.sort(sortedNodes);
        for (Node n : sortedNodes) {
            if (n.isIncomplete() || n.isDeleted()) continue;
            gpxData.waypoints.add(OsmDataLayer.nodeToWayPoint(n));
        }
    }

    private static void addIntegerIfPresent(WayPoint wpt, OsmPrimitive p, String gpxKey, String ... osmKeys) {
        ArrayList<String> possibleKeys = new ArrayList<String>(Arrays.asList(osmKeys));
        possibleKeys.add(0, gpxKey);
        for (String key : possibleKeys) {
            String value = OsmDataLayer.gpxVal(p, key);
            if (value == null) continue;
            try {
                int i = Integer.parseInt(value);
                if ("sat".equals(gpxKey) && i < 0 || "dgpsid".equals(gpxKey) && (0 > i || i > 1023)) continue;
                wpt.put(gpxKey, value);
                break;
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
    }

    private static void addDoubleIfPresent(WayPoint wpt, OsmPrimitive p, String gpxKey, String ... osmKeys) {
        ArrayList<String> possibleKeys = new ArrayList<String>(Arrays.asList(osmKeys));
        possibleKeys.add(0, gpxKey);
        for (String key : possibleKeys) {
            String value = OsmDataLayer.gpxVal(p, key);
            if (value == null) continue;
            try {
                double d = Double.parseDouble(value);
                if ("magvar".equals(gpxKey) && (!(0.0 <= d) || !(d < 360.0))) continue;
                wpt.put(gpxKey, value);
                break;
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
    }

    private static void addStringIfPresent(WayPoint wpt, OsmPrimitive p, String gpxKey, String ... osmKeys) {
        Stream.concat(Stream.of(gpxKey), Arrays.stream(osmKeys)).map(key -> OsmDataLayer.gpxVal(p, key)).filter(value -> value != null && (!"fix".equals(gpxKey) || GpxConstants.FIX_VALUES.contains(value))).findFirst().ifPresent(value -> wpt.put(gpxKey, value));
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon coor) {
        if (this.data.getDataSources().isEmpty()) {
            return true;
        }
        return this.data.getDataSources().stream().anyMatch(src -> src.bounds.contains(coor));
    }

    public ConflictCollection getConflicts() {
        return this.data.getConflicts();
    }

    @Override
    public boolean isDownloadable() {
        return this.data.getDownloadPolicy() != DownloadPolicy.BLOCKED && !this.isLocked();
    }

    @Override
    public boolean isUploadable() {
        return this.data.getUploadPolicy() != UploadPolicy.BLOCKED && !this.isLocked();
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.isUploadable() && this.requiresUploadToServer;
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    public boolean isDirty() {
        return this.requiresSaveToFile() || this.requiresUploadToServer() && !this.isUploadDiscouraged();
    }

    @Override
    public String getLabel() {
        String label = super.getLabel();
        if (this.isDirty()) {
            label = label + " *";
        }
        if (this.getDataSet().isEmpty()) {
            label = label + " \u2205";
        }
        return label;
    }

    @Override
    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.isModified());
        this.invalidate();
    }

    public void onPostDownloadFromServer() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(this.isModified());
        this.invalidate();
    }

    @Override
    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.data.removeSelectionListener(this);
        this.data.removeHighlightUpdateListener(this);
        this.data.removeDataSetListener(this.dataSetListenerAdapter);
        this.data.removeDataSetListener(MultipolygonCache.getInstance());
        this.data.clearSelection();
        this.validationErrors.clear();
        OsmDataLayer.removeClipboardDataFor(this);
        this.recentRelations.clear();
    }

    protected static void removeClipboardDataFor(OsmDataLayer osm) {
        Transferable clipboardContents = ClipboardUtils.getClipboardContent();
        if (clipboardContents != null && clipboardContents.isDataFlavorSupported(OsmLayerTransferData.OSM_FLAVOR)) {
            try {
                Object o = clipboardContents.getTransferData(OsmLayerTransferData.OSM_FLAVOR);
                if (o instanceof OsmLayerTransferData && osm.equals(((OsmLayerTransferData)o).getLayer())) {
                    ClipboardUtils.clear();
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                Logging.error(e);
            }
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.invalidate();
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(event.getDataset().requiresUploadToServer());
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.invalidate();
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
    }

    @Override
    public final boolean isUploadDiscouraged() {
        return this.data.getUploadPolicy() == UploadPolicy.DISCOURAGED;
    }

    public final void setUploadDiscouraged(boolean uploadDiscouraged) {
        if (this.data.getUploadPolicy() != UploadPolicy.BLOCKED && uploadDiscouraged ^ this.isUploadDiscouraged()) {
            this.data.setUploadPolicy(uploadDiscouraged ? UploadPolicy.DISCOURAGED : UploadPolicy.NORMAL);
            for (LayerStateChangeListener l : this.layerStateChangeListeners) {
                l.uploadDiscouragedChanged(this, uploadDiscouraged);
            }
        }
    }

    @Override
    public final boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        if (this.isDataSetEmpty() && 1 != GuiHelper.runInEDTAndWaitAndReturn(() -> new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Empty layer", new Object[0]), I18n.tr("Save anyway", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(I18n.tr("The layer contains no data.", new Object[0])).setButtonIcons("save", "cancel").showDialog().getValue())) {
            return false;
        }
        ConflictCollection conflictsCol = this.getConflicts();
        return conflictsCol == null || conflictsCol.isEmpty() || 1 == GuiHelper.runInEDTAndWaitAndReturn(() -> new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Conflicts", new Object[0]), I18n.tr("Reject Conflicts and Save", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?", new Object[0])).setButtonIcons("save", "cancel").showDialog().getValue());
    }

    private boolean isDataSetEmpty() {
        return this.data == null || this.data.allNonDeletedPrimitives().stream().allMatch(osm -> osm.isDeleted() && osm.isNewOrUndeleted());
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        String extension = PROPERTY_SAVE_EXTENSION.get();
        File file = this.getAssociatedFile();
        if (file == null && this.isRenamed()) {
            StringBuilder filename = new StringBuilder(Config.getPref().get("lastDirectory")).append('/').append(this.getName());
            if (!OsmImporter.FILE_FILTER.acceptName(filename.toString())) {
                filename.append('.').append(extension);
            }
            file = new File(filename.toString());
        }
        return new FileChooserManager().title(I18n.tr("Save OSM file", new Object[0])).extension(extension).file(file).additionalTypes(t -> t != WMSLayerImporter.FILE_FILTER && t != NoteExporter.FILE_FILTER && t != ValidatorErrorExporter.FILE_FILTER).getFileForSave();
    }

    @Override
    public AbstractIOTask createUploadTask(ProgressMonitor monitor) {
        UploadDialog dialog = UploadDialog.getUploadDialog();
        return new UploadLayerTask(dialog.getUploadStrategySpecification(), this, monitor, dialog.getChangeset());
    }

    @Override
    public AbstractUploadDialog getUploadDialog() {
        UploadDialog dialog = UploadDialog.getUploadDialog();
        dialog.setUploadedPrimitives(new APIDataSet(this.data));
        return dialog;
    }

    @Override
    public ProjectionBounds getViewProjectionBounds() {
        BoundingXYVisitor v = new BoundingXYVisitor();
        v.visit(this.data.getDataSourceBoundingBox());
        if (!v.hasExtend()) {
            v.computeBoundingBox(this.data.getNodes());
        }
        return v.getBounds();
    }

    @Override
    public void highlightUpdated(HighlightUpdateListener.HighlightUpdateEvent e) {
        this.invalidate();
    }

    @Override
    public void setName(String name) {
        if (this.data != null) {
            this.data.setName(name);
        }
        super.setName(name);
    }

    public void setUploadInProgress() {
        if (!this.isUploadInProgress.compareAndSet(false, true)) {
            Logging.warn("Trying to set uploadInProgress flag on layer already being uploaded ", this.getName());
        }
    }

    public void unsetUploadInProgress() {
        if (!this.isUploadInProgress.compareAndSet(true, false)) {
            Logging.warn("Trying to unset uploadInProgress flag on layer not being uploaded ", this.getName());
        }
    }

    @Override
    public boolean isUploadInProgress() {
        return this.isUploadInProgress.get();
    }

    @Override
    public Data getData() {
        return this.getDataSet();
    }

    @Override
    public boolean autosave(File file) throws IOException {
        new OsmExporter().exportData(file, this, true);
        return true;
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    public static final class DataCountVisitor
    implements OsmPrimitiveVisitor {
        public int nodes;
        public int ways;
        public int relations;
        public int deletedNodes;
        public int deletedWays;
        public int deletedRelations;
        public int incompleteNodes;
        public int incompleteWays;
        public int incompleteRelations;

        @Override
        public void visit(Node n) {
            ++this.nodes;
            if (n.isDeleted()) {
                ++this.deletedNodes;
            }
            if (n.isIncomplete()) {
                ++this.incompleteNodes;
            }
        }

        @Override
        public void visit(Way w) {
            ++this.ways;
            if (w.isDeleted()) {
                ++this.deletedWays;
            }
            if (w.isIncomplete()) {
                ++this.incompleteWays;
            }
        }

        @Override
        public void visit(Relation r) {
            ++this.relations;
            if (r.isDeleted()) {
                ++this.deletedRelations;
            }
            if (r.isIncomplete()) {
                ++this.incompleteRelations;
            }
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer", new Object[0]));
            new ImageProvider("converttogpx").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Action/ConvertToGpxLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GpxData gpxData = OsmDataLayer.this.toGpxData();
            GpxLayer gpxLayer = new GpxLayer(gpxData, I18n.tr("Converted from: {0}", OsmDataLayer.this.getName()));
            if (OsmDataLayer.this.getAssociatedFile() != null) {
                String filename = OsmDataLayer.this.getAssociatedFile().getName().replaceAll(Pattern.quote(".gpx.osm") + '$', "") + ".gpx";
                gpxLayer.setAssociatedFile(new File(OsmDataLayer.this.getAssociatedFile().getParentFile(), filename));
            }
            MainApplication.getLayerManager().addLayer(gpxLayer, false);
            if (Config.getPref().getBoolean("marker.makeautomarkers", true) && !gpxData.waypoints.isEmpty()) {
                MainApplication.getLayerManager().addLayer(new MarkerLayer(gpxData, I18n.tr("Converted from: {0}", OsmDataLayer.this.getName()), null, gpxLayer), false);
            }
            MainApplication.getLayerManager().removeLayer(OsmDataLayer.this);
        }
    }

    private class ConsistencyTestAction
    extends AbstractAction {
        ConsistencyTestAction() {
            super(I18n.tr("Dataset consistency test", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String result = DatasetConsistencyTest.runTests(OsmDataLayer.this.data);
            if (result.isEmpty()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("No problems found", new Object[0]));
            } else {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr("Following problems found:", new Object[0])), GBC.eol());
                JosmTextArea info = new JosmTextArea(result, 20, 60);
                info.setCaretPosition(0);
                info.setEditable(false);
                p.add((Component)new JScrollPane(info), GBC.eop());
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), p, I18n.tr("Warning", new Object[0]), 2);
            }
        }
    }

    @FunctionalInterface
    public static interface LayerStateChangeListener {
        public void uploadDiscouragedChanged(OsmDataLayer var1, boolean var2);
    }
}

