/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GeoJSONReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GeoJSONServerReader
extends OsmServerLocationReader {
    public GeoJSONServerReader(String url) {
        super(url);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.parseOsm(progressMonitor, Compression.NONE);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor, Compression compression) throws OsmTransferException {
        return this.doParse(new GeoJsonParser(progressMonitor, compression), progressMonitor);
    }

    protected class GeoJsonParser
    extends OsmServerLocationReader.Parser<DataSet> {
        protected GeoJsonParser(ProgressMonitor progressMonitor, Compression compression) {
            super(progressMonitor, compression);
        }

        @Override
        public DataSet parse() throws OsmTransferException, IllegalDataException, IOException, SAXException {
            this.in = GeoJSONServerReader.this.getInputStreamRaw(GeoJSONServerReader.this.url, this.progressMonitor.createSubTaskMonitor(9, false));
            if (this.in == null) {
                return null;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            InputStream uncompressedInputStream = this.compression.getUncompressedInputStream(this.in);
            ProgressMonitor subTaskMonitor = this.progressMonitor.createSubTaskMonitor(1, false);
            return GeoJSONReader.parseDataSet(uncompressedInputStream, subTaskMonitor);
        }
    }
}

