/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;

public interface CompilerOptionsQueryImplementation {
    @CheckForNull
    public Result getOptions(@NonNull FileObject var1);

    public static abstract class Result {
        @NonNull
        public abstract List<? extends String> getArguments();

        public abstract void addChangeListener(@NonNull ChangeListener var1);

        public abstract void removeChangeListener(@NonNull ChangeListener var1);

        protected final List<String> parseLine(@NonNull String commandLine) {
            ArrayList<String> result = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            boolean escape = false;
            boolean doubleQuote = false;
            boolean quote = false;
            block6: for (int i = 0; i < commandLine.length(); ++i) {
                char c = commandLine.charAt(i);
                switch (c) {
                    case '\\': {
                        if (quote) continue block6;
                        escape = !escape;
                        continue block6;
                    }
                    case '\'': {
                        if (!escape && !doubleQuote) {
                            quote = !quote;
                        }
                        escape = false;
                        continue block6;
                    }
                    case '\"': {
                        if (!escape && !quote) {
                            doubleQuote = !doubleQuote;
                        }
                        escape = false;
                        continue block6;
                    }
                    case '\t': 
                    case ' ': {
                        if (!(escape || quote || doubleQuote)) {
                            if (current.length() > 0) {
                                result.add(current.toString());
                                current = new StringBuilder();
                            }
                        } else {
                            current.append(c);
                        }
                        escape = false;
                        continue block6;
                    }
                    default: {
                        current.append(c);
                        escape = false;
                    }
                }
            }
            if (current.length() > 0) {
                result.add(current.toString());
            }
            return Collections.unmodifiableList(result);
        }
    }
}

