/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.netbeans.nbbuild.JarWithModuleAttributes;

public class MakeMasterJNLP
extends Task {
    private ResourceCollection files;
    private File target;
    private String masterPrefix = "";

    public FileSet createModules() throws BuildException {
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        this.addConfigured((ResourceCollection)fs);
        return fs;
    }

    public void addConfigured(ResourceCollection rc) throws BuildException {
        if (this.files != null) {
            throw new BuildException("modules can be specified just once");
        }
        this.files = rc;
    }

    public void setDir(File t) {
        this.target = t;
    }

    public void setCodeBase(String p) {
        this.masterPrefix = p;
    }

    public void execute() throws BuildException {
        if (this.target == null) {
            throw new BuildException("Output dir must be provided");
        }
        if (this.files == null) {
            throw new BuildException("modules must be provided");
        }
        try {
            this.generateFiles();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateFiles() throws IOException, BuildException {
        for (FileResource fr : this.files) {
            File jar = fr.getFile();
            if (!jar.canRead()) {
                throw new BuildException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            Throwable throwable = null;
            try {
                String codenamebase = JarWithModuleAttributes.extractCodeName(theJar.getManifest().getMainAttributes());
                if (codenamebase == null) {
                    throw new BuildException("Not a NetBeans Module: " + jar);
                }
                if (codenamebase.equals("org.objectweb.asm.all") && jar.getParentFile().getName().equals("core") && jar.getParentFile().getParentFile().getName().startsWith("platform")) continue;
                int slash = codenamebase.indexOf(47);
                if (slash >= 0) {
                    codenamebase = codenamebase.substring(0, slash);
                }
                String dashcnb = codenamebase.replace('.', '-');
                File n = new File(this.target, dashcnb + ".ref");
                FileWriter w = new FileWriter(n);
                Throwable throwable2 = null;
                try {
                    w.write("    <extension name='" + codenamebase + "' href='" + this.masterPrefix + dashcnb + ".jnlp' />\n");
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (w == null) continue;
                    if (throwable2 != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    w.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (theJar == null) continue;
                if (throwable != null) {
                    try {
                        theJar.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                theJar.close();
            }
        }
    }
}

