/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class SetUpstreamBranchCommand
extends GitCommand {
    private final String localBranchName;
    private final String trackedBranchName;
    private GitBranch branch;
    private final ProgressMonitor monitor;

    public SetUpstreamBranchCommand(Repository repository, GitClassFactory gitFactory, String localBranchName, String trackedBranch, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.localBranchName = localBranchName;
        this.trackedBranchName = trackedBranch;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            Ref ref = repository.getRef(this.trackedBranchName);
            if (ref == null) {
                throw new GitException(MessageFormat.format(Utils.getBundle(SetUpstreamBranchCommand.class).getString("MSG_Error_UpdateTracking_InvalidReference"), this.trackedBranchName));
            }
            String remote = null;
            String branchName = ref.getName();
            StoredConfig config = repository.getConfig();
            if (branchName.startsWith("refs/remotes/")) {
                String[] elements = branchName.split("/", 4);
                remote = elements[2];
                if (config.getSubsections("remote").contains(remote)) {
                    branchName = "refs/heads/" + elements[3];
                    this.setupRebaseFlag(repository);
                } else {
                    remote = null;
                }
            }
            if (remote == null) {
                remote = ".";
            }
            config.setString("branch", this.localBranchName, "remote", remote);
            config.setString("branch", this.localBranchName, "merge", branchName);
            config.save();
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        ListBranchCommand branchCmd = new ListBranchCommand(repository, this.getClassFactory(), false, new DelegatingGitProgressMonitor(this.monitor));
        branchCmd.run();
        Map<String, GitBranch> branches = branchCmd.getBranches();
        this.branch = branches.get(this.localBranchName);
    }

    private void setupRebaseFlag(Repository repository) throws IOException {
        boolean rebase;
        StoredConfig config = repository.getConfig();
        String autosetupRebase = config.getString("branch", null, "autosetuprebase");
        boolean bl = rebase = "always".equals(autosetupRebase) || "remote".equals(autosetupRebase);
        if (rebase) {
            config.setBoolean("branch", this.localBranchName, "rebase", rebase);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git branch --set-upstream-to " + this.trackedBranchName + ' ' + this.localBranchName;
    }

    public GitBranch getTrackingBranch() {
        return this.branch;
    }
}

