/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.document;

import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.editor.lib2.document.ComplexPos;
import org.openide.util.Parameters;

public final class ComplexPositions {
    private ComplexPositions() {
    }

    public static Position create(@NonNull Position pos, int splitOffset) {
        Parameters.notNull((CharSequence)"pos", (Object)pos);
        if (splitOffset > 0) {
            if (pos.getClass() == ComplexPos.class) {
                return new ComplexPos((ComplexPos)pos, splitOffset);
            }
            return new ComplexPos(pos, splitOffset);
        }
        if (splitOffset == 0) {
            return pos;
        }
        throw new IllegalArgumentException("splitOffset=" + splitOffset + " < 0");
    }

    public static int getSplitOffset(@NonNull Position pos) {
        return ComplexPositions.getSplitOffsetImpl(pos);
    }

    public static int compare(@NonNull Position pos1, @NonNull Position pos2) {
        if (pos1 == pos2) {
            return 0;
        }
        int offsetDiff = pos1.getOffset() - pos2.getOffset();
        return offsetDiff != 0 ? offsetDiff : ComplexPositions.getSplitOffsetImpl(pos1) - ComplexPositions.getSplitOffsetImpl(pos2);
    }

    public static int compare(int offset1, int splitOffset1, int offset2, int splitOffset2) {
        int offsetDiff = offset1 - offset2;
        return offsetDiff != 0 ? offsetDiff : splitOffset1 - splitOffset2;
    }

    private static int getSplitOffsetImpl(Position pos) {
        return pos.getClass() == ComplexPos.class ? ((ComplexPos)pos).getSplitOffset() : 0;
    }
}

