/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class BrokenProjectNotifier {
    private static final BrokenProjectNotifier instance = new BrokenProjectNotifier();
    private static final RequestProcessor NOTIFIER = new RequestProcessor(BrokenProjectNotifier.class.getName(), 1, false, false);
    private static final Logger LOG = Logger.getLogger(BrokenProjectNotifier.class.getName());
    private final AtomicBoolean started = new AtomicBoolean();
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            if ("openProjects".equals(evt.getPropertyName())) {
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                if (oldValue instanceof Project[] && newValue instanceof Project[]) {
                    BrokenProjectNotifier.this.checkBrokenProjects((Project[])oldValue, (Project[])newValue);
                }
            }
        }
    };

    private BrokenProjectNotifier() {
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Already started.");
        }
        OpenProjects.getDefault().addPropertyChangeListener(this.listener);
        LOG.fine("Started");
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            throw new IllegalStateException("Not started.");
        }
        OpenProjects.getDefault().removePropertyChangeListener(this.listener);
        LOG.fine("Stopped");
    }

    private void checkBrokenProjects(@NonNull Project[] oldOpened, @NonNull Project[] newOpened) {
        final HashSet<Project> justAdded = new HashSet<Project>(Arrays.asList(newOpened));
        justAdded.removeAll(Arrays.asList(oldOpened));
        if (!justAdded.isEmpty()) {
            LOG.log(Level.FINE, "New projects to check: {0}", justAdded);
            NOTIFIER.execute(new Runnable(){

                @Override
                public void run() {
                    ArrayDeque<Project> toCheck = new ArrayDeque<Project>();
                    block0: for (Project project : justAdded) {
                        ProjectProblemsProvider ppp = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class);
                        if (ppp == null) continue;
                        for (ProjectProblemsProvider.ProjectProblem problem : ppp.getProblems()) {
                            if (problem.getSeverity() != ProjectProblemsProvider.Severity.ERROR) continue;
                            toCheck.offer(project);
                            continue block0;
                        }
                    }
                    if (!toCheck.isEmpty()) {
                        BrokenProjectNotifier.this.scheduleAlert(toCheck);
                    }
                }
            });
        }
    }

    private void scheduleAlert(@NonNull Collection<? extends Project> prjs) {
        Future projects = OpenProjects.getDefault().openProjects();
        try {
            projects.get();
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ie) {
            Exceptions.printStackTrace((Throwable)ie);
        }
        for (Project project : prjs) {
            LOG.log(Level.FINE, "Showing alert for project: {0}", prjs);
            ProjectProblems.showAlert((Project)project);
        }
    }

    public static BrokenProjectNotifier getInstnace() {
        return instance;
    }
}

