/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.knockout.api.KODataBindTokenId;
import org.netbeans.modules.html.ojet.OJETContext;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class OJETUtils {
    public static final String OJ_COMPONENT = "ojComponent";
    public static final String OJ_MODULE = "ojModule";
    public static final String OJET_ICON_PATH = "org/netbeans/modules/html/ojet/ui/resources/ojet-icon.png";
    public static final ImageIcon OJET_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/html/ojet/ui/resources/ojet-icon.png", (boolean)false);
    private static final AtomicBoolean isLogged = new AtomicBoolean(false);
    public static final String USG_LOGGER_NAME = "org.netbeans.ui";
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui");
    private static final String USG_MESSAGE = "GENERIC_OJET_CC";

    public static void logUsage(List<? extends Object> params) {
        if (!isLogged.get()) {
            LogRecord logRecord = new LogRecord(Level.WARNING, USG_MESSAGE);
            logRecord.setLoggerName(USG_LOGGER.getName());
            logRecord.setResourceBundle(NbBundle.getBundle(OJETUtils.class));
            logRecord.setResourceBundleName(OJETUtils.class.getPackage().getName() + ".Bundle");
            if (params != null) {
                logRecord.setParameters(params.toArray(new Object[params.size()]));
            }
            USG_LOGGER.log(logRecord);
            isLogged.set(true);
        }
    }

    public static String getPrefix(OJETContext ojContext, Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        String empty = "";
        switch (ojContext) {
            case DATA_BINDING: {
                Token etoken;
                int diff;
                TokenSequence ts = LexerUtils.getTokenSequence((TokenHierarchy)th, (int)offset, (Language)KODataBindTokenId.language(), (boolean)false);
                if (ts == null || ((diff = ts.move(offset)) != 0 || !ts.movePrevious()) && !ts.moveNext() || (etoken = ts.token()).id() != KODataBindTokenId.KEY) break;
                CharSequence prefix = diff == 0 ? etoken.text() : etoken.text().subSequence(0, diff);
                return prefix.toString();
            }
        }
        return empty;
    }

    public static int getPrefixOffset(OJETContext ojContext, Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        int result = offset;
        switch (ojContext) {
            case DATA_BINDING: {
                Token etoken;
                int diff;
                TokenSequence ts = LexerUtils.getTokenSequence((TokenHierarchy)th, (int)offset, (Language)KODataBindTokenId.language(), (boolean)false);
                if (ts == null || ((diff = ts.move(offset)) != 0 || !ts.movePrevious()) && !ts.moveNext() || (etoken = ts.token()).id() != KODataBindTokenId.KEY) break;
                return ts.offset();
            }
        }
        return result;
    }
}

