/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.gradle.api.GradleProjects;
import org.netbeans.modules.gradle.classpath.AbstractGradleScriptClassPath;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ScriptClassPathProvider
implements ClassPathProvider {
    private static final String GRADLE_EXT = "gradle";
    final ClassPath BOOT_CP;
    final ClassPath GRADLE_CP;
    final ClassPath SOURCE_CP;
    HashMap<FileObject, ClassPath> cache = new HashMap();

    public ScriptClassPathProvider() {
        this.GRADLE_CP = this.BOOT_CP = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries(), ClassPathFactory.createClassPath((ClassPathImplementation)new GradleScriptClassPath())});
        this.SOURCE_CP = ClassPathFactory.createClassPath((ClassPathImplementation)new GradleScriptSourcePath());
    }

    public ClassPath findClassPath(FileObject fo, String type) {
        if ("classpath/html5".equals(type)) {
            return null;
        }
        boolean isGradle = GRADLE_EXT.equals(fo.getExt());
        if (fo.isFolder() && FileUtil.toFile((FileObject)fo) != null) {
            isGradle = GradleProjects.testForProject(FileUtil.toFile((FileObject)fo));
        }
        if (isGradle) {
            switch (type) {
                case "classpath/boot": {
                    return this.BOOT_CP;
                }
                case "classpath/source": {
                    return this.SOURCE_CP;
                }
                case "classpath/compile": {
                    return this.GRADLE_CP;
                }
                case "classpath/execute": {
                    return this.GRADLE_CP;
                }
            }
        }
        return null;
    }

    public static final class GradleScriptClassPath
    extends AbstractGradleScriptClassPath {
        @Override
        protected List<FileObject> createPath() {
            ArrayList<FileObject> ret = new ArrayList<FileObject>();
            if (this.distDir != null) {
                this.addJars(ret, FileUtil.toFileObject((File)new File(this.distDir, "lib")));
                this.addJars(ret, FileUtil.toFileObject((File)new File(this.distDir, "lib/plugins")));
            }
            return ret;
        }

        private void addJars(List<FileObject> ret, FileObject dir) {
            if (dir != null && dir.isFolder()) {
                for (FileObject child : dir.getChildren()) {
                    if (!FileUtil.isArchiveFile((FileObject)child)) continue;
                    ret.add(FileUtil.getArchiveRoot((FileObject)child));
                }
            }
        }
    }

    public static class GradleScriptSourcePath
    extends AbstractGradleScriptClassPath {
        @Override
        protected List<FileObject> createPath() {
            FileObject srcDir;
            ArrayList<FileObject> ret = new ArrayList<FileObject>();
            if (this.distDir != null && (srcDir = FileUtil.toFileObject((File)new File(this.distDir, "src"))) != null && srcDir.isFolder()) {
                Enumeration folders = srcDir.getFolders(false);
                while (folders.hasMoreElements()) {
                    ret.add((FileObject)folders.nextElement());
                }
            }
            return ret;
        }
    }
}

