/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.handlers;

import com.sun.enterprise.web.connector.grizzly.FileCache;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.algorithms.ContentLengthAlgorithm;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.apache.coyote.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentLengthHandler
implements Handler<Request> {
    private SocketChannel socketChannel;
    protected FileCache fileCache;
    private ContentLengthAlgorithm algorithm;

    public ContentLengthHandler(ContentLengthAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void attachChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (this.fileCache == null && socketChannel != null) {
            this.fileCache = FileCacheFactory.getFactory(socketChannel.socket().getLocalPort()).getFileCache();
        }
    }

    @Override
    public int handle(Request request, int handlerCode) throws IOException {
        if (this.socketChannel == null || !FileCacheFactory.isEnabled()) {
            return 0;
        }
        if (this.fileCache == null && handlerCode != 1) {
            return 0;
        }
        if (handlerCode != 1 && handlerCode == 2 && this.algorithm.startReq != -1 && this.fileCache.sendCache(this.algorithm.ascbuf, this.algorithm.startReq, this.algorithm.lengthReq, this.socketChannel, true)) {
            return 1;
        }
        return 0;
    }
}

