/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.context.PortletContextResource;
import org.springframework.web.portlet.context.PortletContextResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContextResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    public PortletContextResourcePatternResolver(PortletContext portletContext) {
        super((ResourceLoader)new PortletContextResourceLoader(portletContext));
    }

    public PortletContextResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        if (rootDirResource instanceof PortletContextResource) {
            PortletContextResource pcResource = (PortletContextResource)rootDirResource;
            PortletContext pc = pcResource.getPortletContext();
            String fullPattern = pcResource.getPath() + subPattern;
            HashSet<Resource> result = new HashSet<Resource>();
            this.doRetrieveMatchingPortletContextResources(pc, fullPattern, pcResource.getPath(), result);
            return result;
        }
        return super.doFindPathMatchingFileResources(rootDirResource, subPattern);
    }

    protected void doRetrieveMatchingPortletContextResources(PortletContext portletContext, String fullPattern, String dir, Set<Resource> result) throws IOException {
        Set candidates = portletContext.getResourcePaths(dir);
        if (candidates != null) {
            boolean dirDepthNotFixed = fullPattern.contains("**");
            for (String currPath : candidates) {
                if (currPath.endsWith("/") && (dirDepthNotFixed || StringUtils.countOccurrencesOf((String)currPath, (String)"/") <= StringUtils.countOccurrencesOf((String)fullPattern, (String)"/"))) {
                    this.doRetrieveMatchingPortletContextResources(portletContext, fullPattern, currPath, result);
                }
                if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
                result.add((Resource)new PortletContextResource(portletContext, currPath));
            }
        }
    }
}

