/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.properties;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.css.lib.api.properties.FixedTextGrammarElement;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.TokenAcceptor;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.web.common.api.LexerUtils;

public class GrammarParser {
    private String propertyName;
    private String expression;

    public static GroupGrammarElement parse(String expresssion) {
        return GrammarParser.parse(expresssion, null);
    }

    public static GroupGrammarElement parse(String expression, String propertyName) {
        return new GrammarParser(expression, propertyName).parse();
    }

    public GrammarParser(String expression, String propertyName) {
        this.expression = expression;
        this.propertyName = propertyName;
    }

    private GroupGrammarElement parse() {
        AtomicInteger group_index = new AtomicInteger(0);
        int openedParenthesis = 0;
        GroupGrammarElement root = new GroupGrammarElement(null, group_index.getAndIncrement(), this.propertyName);
        ParserInput input = new ParserInput(this.expression);
        this.parseElements(input, root, false, group_index, openedParenthesis);
        if (openedParenthesis != 0) {
            throw new IllegalStateException(String.format("Property '%s' parsing error - bracket pairs doesn't match: ", this.propertyName, openedParenthesis));
        }
        return root;
    }

    private void parseElements(ParserInput input, GroupGrammarElement parent, boolean ignoreInherits, AtomicInteger group_index, int openedParenthesis) {
        GrammarElement last = null;
        char c;
        block14: while ((c = input.read()) != '\uffff') {
            StringBuilder buf;
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block14;
                }
                case '&': {
                    char next = input.read();
                    if (next == '&') {
                        parent.setType(GroupGrammarElement.Type.ALL);
                        continue block14;
                    }
                    input.backup(1);
                    continue block14;
                }
                case '[': {
                    last = new GroupGrammarElement(parent, group_index.getAndIncrement());
                    this.parseElements(input, (GroupGrammarElement)last, false, group_index, ++openedParenthesis);
                    parent.addElement(last);
                    continue block14;
                }
                case '|': {
                    char next = input.read();
                    if (next == '|') {
                        parent.setType(GroupGrammarElement.Type.COLLECTION);
                        continue block14;
                    }
                    input.backup(1);
                    parent.setType(GroupGrammarElement.Type.SET);
                    continue block14;
                }
                case ']': {
                    --openedParenthesis;
                    return;
                }
                case '<': {
                    buf = new StringBuilder();
                    while ((c = input.read()) != '>') {
                        buf.append(c);
                    }
                    String referredElementName = buf.toString();
                    PropertyDefinition property = Properties.getPropertyDefinition(referredElementName, true);
                    if (property == null) {
                        throw new IllegalStateException(String.format("Property '%s' parsing error: No referred element '%s' found. Read input: %s", this.propertyName, referredElementName, input.readText()));
                    }
                    ParserInput pinput = new ParserInput(property.getGrammar());
                    String propName = property.getName();
                    last = new GroupGrammarElement(parent, group_index.getAndIncrement(), propName);
                    this.parseElements(pinput, (GroupGrammarElement)last, true, group_index, openedParenthesis);
                    parent.addElement(last);
                    continue block14;
                }
                case '!': {
                    String unitName;
                    TokenAcceptor acceptor;
                    buf = new StringBuilder();
                    while ((c = input.read()) != '\uffff') {
                        if (GrammarParser.isEndOfValue(input)) {
                            input.backup(1);
                            break;
                        }
                        buf.append(c);
                    }
                    if ((acceptor = TokenAcceptor.getAcceptor(unitName = buf.toString())) == null) {
                        throw new IllegalStateException(String.format("Property '%s' parsing error - No unit property value acceptor for '%s'. Read input: '%s'", this.propertyName, unitName, input.readText()));
                    }
                    last = new UnitGrammarElement(parent, acceptor, null);
                    parent.addElement(last);
                    continue block14;
                }
                case '{': {
                    StringBuilder text = new StringBuilder();
                    while ((c = input.read()) != '}') {
                        text.append(c);
                    }
                    StringTokenizer st = new StringTokenizer(text.toString(), ",");
                    int min = Integer.parseInt(st.nextToken());
                    int max = Integer.parseInt(st.nextToken());
                    last.setMinimumOccurances(min);
                    last.setMaximumOccurances(max);
                    continue block14;
                }
                case '+': {
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block14;
                }
                case '*': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block14;
                }
                case '?': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(1);
                    continue block14;
                }
                case '(': {
                    char ch = input.read();
                    if (ch == '$') {
                        buf = new StringBuilder();
                        while ((ch = input.read()) != ')') {
                            buf.append(ch);
                        }
                        last.setName(buf.toString());
                        continue block14;
                    }
                    input.backup(1);
                }
            }
            buf = new StringBuilder();
            boolean quotes = GrammarParser.isQuoteChar(c);
            if (quotes) {
                c = input.read();
            }
            while (c != '\uffff') {
                if (quotes) {
                    if (GrammarParser.isQuoteChar(c)) {
                        break;
                    }
                } else if (GrammarParser.isEndOfValue(input)) {
                    input.backup(1);
                    break;
                }
                buf.append(c);
                c = input.read();
            }
            if (ignoreInherits && LexerUtils.equals((CharSequence)"inherit", (CharSequence)buf, (boolean)true, (boolean)true)) continue;
            last = new FixedTextGrammarElement(parent, buf, null);
            parent.addElement(last);
        }
        return;
    }

    private static boolean isEndOfValue(ParserInput input) {
        char c = input.LA(0);
        switch (c) {
            case ' ': 
            case '&': 
            case '*': 
            case '+': 
            case '?': 
            case '[': 
            case ']': 
            case '{': 
            case '|': {
                return true;
            }
            case '(': {
                return input.LA(1) == '$';
            }
        }
        return false;
    }

    private static boolean isQuoteChar(char c) {
        return c == '\'' || c == '\"';
    }

    private static class ParserInput {
        CharSequence text;
        private int pos = 0;

        private ParserInput(CharSequence text) {
            this.text = text;
        }

        public char read() {
            if (this.pos == this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(this.pos++);
        }

        public char LA(int lookahead) {
            int dec = this.pos == 0 ? 0 : 1;
            int la_pos = this.pos - dec + lookahead;
            if (la_pos >= this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(la_pos);
        }

        public void backup(int chars) {
            this.pos -= chars;
        }

        public CharSequence readText() {
            return this.text.subSequence(0, this.pos);
        }
    }
}

