/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.openide.util.Exceptions;

public final class ParameterElementImpl
implements ParameterElement {
    private final String name;
    private final String defaultValue;
    private final Set<TypeResolver> types;
    private final int offset;
    private final boolean isRawType;
    private final boolean isMandatory;
    private final boolean isReference;
    private final boolean isVariadic;

    public ParameterElementImpl(String name, String defaultValue, int offset, Set<TypeResolver> types, boolean isMandatory, boolean isRawType, boolean isReference, boolean isVariadic) {
        this.name = name;
        this.isMandatory = isMandatory;
        this.defaultValue = !isMandatory && defaultValue != null ? ParameterElementImpl.decode(defaultValue) : "";
        this.offset = offset;
        this.types = types;
        this.isRawType = isRawType;
        this.isReference = isReference;
        this.isVariadic = isVariadic;
    }

    static List<ParameterElement> parseParameters(String signature) {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        if (signature != null && signature.length() > 0) {
            String regexp = String.format("\\%s", PhpElementImpl.Separator.COMMA.toString());
            for (String sign : signature.split(regexp)) {
                try {
                    ParameterElement param = ParameterElementImpl.parseOneParameter(sign);
                    if (param == null) continue;
                    retval.add(param);
                }
                catch (NumberFormatException originalException) {
                    String message = String.format("%s [for signature: %s]", originalException.getMessage(), signature);
                    NumberFormatException formatException = new NumberFormatException(message);
                    formatException.initCause(originalException);
                    throw formatException;
                }
            }
        }
        return retval;
    }

    private static ParameterElement parseOneParameter(String sig) {
        ParameterElementImpl retval = null;
        String regexp = String.format("\\%s", PhpElementImpl.Separator.COLON.toString());
        String[] parts = sig.split(regexp);
        if (parts.length > 0) {
            String paramName = parts[0];
            Set<TypeResolver> types = TypeResolverImpl.parseTypes(parts[1]);
            boolean isRawType = Integer.parseInt(parts[2]) > 0;
            boolean isMandatory = Integer.parseInt(parts[4]) > 0;
            boolean isReference = Integer.parseInt(parts[5]) > 0;
            boolean isVariadic = Integer.parseInt(parts[6]) > 0;
            String defValue = parts.length > 3 ? parts[3] : null;
            retval = new ParameterElementImpl(paramName, defValue, -1, types, isMandatory, isRawType, isReference, isVariadic);
        }
        return retval;
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        String parameterName = this.getName().trim();
        assert (parameterName.equals(ParameterElementImpl.encode(parameterName))) : parameterName;
        sb.append(parameterName).append((Object)PhpElementImpl.Separator.COLON);
        StringBuilder typeBuilder = new StringBuilder();
        for (TypeResolver typeResolver : this.getTypes()) {
            TypeResolverImpl resolverImpl = (TypeResolverImpl)typeResolver;
            if (typeBuilder.length() > 0) {
                typeBuilder.append((Object)PhpElementImpl.Separator.PIPE);
            }
            typeBuilder.append(resolverImpl.getSignature());
        }
        String typeSignatures = typeBuilder.toString().trim();
        sb.append(typeSignatures);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isRawType ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        if (!this.isMandatory()) {
            String defVal = this.getDefaultValue();
            assert (defVal != null);
            sb.append(ParameterElementImpl.encode(defVal));
        }
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isMandatory ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isReference ? 1 : 0);
        sb.append((Object)PhpElementImpl.Separator.COLON);
        sb.append(this.isVariadic ? 1 : 0);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<TypeResolver> getTypes() {
        return new HashSet<TypeResolver>(this.types);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean hasDeclaredType() {
        return this.isRawType;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    static String encode(String inStr) {
        return ParameterElementImpl.encode(inStr, PhpElementImpl.Separator.toEnumSet());
    }

    static String encode(String inStr, EnumSet<PhpElementImpl.Separator> separators) {
        StringBuilder outStr = new StringBuilder(6 * inStr.length());
        for (int i = 0; i < inStr.length(); ++i) {
            char charAt = inStr.charAt(i);
            boolean encode = ParameterElementImpl.isEncodedChar(i, inStr);
            if (!encode) {
                for (PhpElementImpl.Separator separator : separators) {
                    char separatorChar = separator.toString().charAt(0);
                    if (charAt != separatorChar) continue;
                    encode = true;
                    break;
                }
            }
            if (encode) {
                outStr.append(ParameterElementImpl.encodeChar(inStr.charAt(i)));
                continue;
            }
            outStr.append(inStr.charAt(i));
        }
        return outStr.toString();
    }

    private static String encodeChar(char ch) {
        String encChar = Integer.toString(ch, 16);
        return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
    }

    private static String decode(String inStr) {
        StringBuilder outStr = new StringBuilder(inStr.length());
        try {
            for (int i = 0; i < inStr.length(); ++i) {
                if (ParameterElementImpl.isEncodedChar(i, inStr)) {
                    String decChar = inStr.substring(i + 2, i + 6);
                    outStr.append((char)Integer.parseInt(decChar, 16));
                    i += 5;
                    continue;
                }
                outStr.append(inStr.charAt(i));
            }
        }
        catch (NumberFormatException e) {
            Exceptions.printStackTrace((Throwable)e);
            return inStr;
        }
        return outStr.toString();
    }

    private static boolean isEncodedChar(int currentPosition, String inStr) {
        boolean isEncodedChar;
        boolean bl = isEncodedChar = currentPosition + 5 < inStr.length();
        if (isEncodedChar) {
            char c;
            isEncodedChar &= inStr.charAt(currentPosition) == '\\' && inStr.charAt(currentPosition + 1) == 'u';
            for (int i = currentPosition + 2; isEncodedChar && i < currentPosition + 6; isEncodedChar &= Character.digit(c = inStr.charAt(i), 16) != -1, ++i) {
            }
        }
        return isEncodedChar;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String signature = sb.toString();
            try {
                ParameterElement parsedParameter = ParameterElementImpl.parseOneParameter(signature);
                assert (this.getName().equals(parsedParameter.getName())) : signature;
                assert (this.hasDeclaredType() == parsedParameter.hasDeclaredType()) : signature;
                String defValue = this.getDefaultValue();
                if (defValue != null) {
                    String paramDefaultValue = parsedParameter.getDefaultValue();
                    assert (paramDefaultValue != null && defValue.equals(paramDefaultValue)) : signature;
                }
                assert (this.isMandatory() == parsedParameter.isMandatory()) : signature;
                assert (this.isReference() == parsedParameter.isReference()) : signature;
                assert (this.isVariadic() == parsedParameter.isVariadic()) : signature;
            }
            catch (NumberFormatException originalException) {
                String message = String.format("%s [for signature: %s]", originalException.getMessage(), signature);
                NumberFormatException formatException = new NumberFormatException(message);
                formatException.initCause(originalException);
                throw formatException;
            }
        }
    }

    @Override
    public OffsetRange getOffsetRange() {
        int endOffset = this.getOffset() + this.getName().length();
        return new OffsetRange(this.offset, endOffset);
    }

    @Override
    public String asString(ParameterElement.OutputType outputType) {
        return this.asString(outputType, TypeNameResolverImpl.forNull());
    }

    @Override
    public String asString(ParameterElement.OutputType outputType, TypeNameResolver typeNameResolver) {
        boolean forDeclaration;
        StringBuilder sb = new StringBuilder();
        Set<TypeResolver> typesResolvers = this.getTypes();
        boolean bl = forDeclaration = outputType.equals((Object)ParameterElement.OutputType.SHORTEN_DECLARATION) || outputType.equals((Object)ParameterElement.OutputType.COMPLETE_DECLARATION);
        if (forDeclaration && this.hasDeclaredType()) {
            if (typesResolvers.size() > 1) {
                sb.append("mixed").append(' ');
            } else {
                for (TypeResolver typeResolver : typesResolvers) {
                    if (!typeResolver.isResolved()) continue;
                    if (typeResolver.isNullableType()) {
                        sb.append("?");
                    }
                    sb.append(typeNameResolver.resolve(typeResolver.getTypeName(false))).append(' ');
                    break;
                }
            }
        }
        if (forDeclaration) {
            if (this.isReference()) {
                sb.append("&");
            }
            if (this.isVariadic()) {
                sb.append("...");
            }
        }
        sb.append(this.getName());
        if (forDeclaration) {
            String defVal = this.getDefaultValue();
            if (!this.isMandatory() && StringUtils.hasText((String)defVal)) {
                sb.append(" = ");
                if (outputType.equals((Object)ParameterElement.OutputType.COMPLETE_DECLARATION)) {
                    sb.append(defVal);
                } else {
                    sb.append(defVal.length() > 20 ? "..." : defVal);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public boolean isVariadic() {
        return this.isVariadic;
    }
}

