/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class XMLCompletionProvider
implements CompletionProvider {
    private static final boolean ENABLED = true;
    public static final int COMPLETION_POPUP = 0;
    public static final int COMPLETION_CANCEL = 1;
    public static final int COMPLETION_REFRESH = 2;
    public static final int COMPLETION_POST_REFRESH = 3;
    public static final int COMPLETION_HIDE = 4;

    public XMLCompletionProvider() {
        System.err.println("");
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        XMLSyntaxSupport support = XMLSyntaxSupport.getSyntaxSupport(component.getDocument());
        if (support == null || !(support instanceof XMLSyntaxSupport)) {
            return 0;
        }
        int type = this.checkCompletion(support, component, typedText, false);
        if (type == 0) {
            return 1;
        }
        return 0;
    }

    private int checkCompletion(XMLSyntaxSupport support, JTextComponent target, String typedText, boolean visible) {
        if (!visible) {
            int retVal = 1;
            switch (typedText.charAt(typedText.length() - 1)) {
                case '/': {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    try {
                        String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                        if (!txtBeforeSpace.equals("</")) break;
                        retVal = 0;
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                    break;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    retVal = 0;
                    break;
                }
                case '>': {
                    int dotPos = target.getCaret().getDot();
                    try {
                        SyntaxElement sel = support.getElementChain(dotPos);
                        if (!support.isStartTag(sel)) break;
                        retVal = 0;
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (this.noCompletion(support, target)) {
                return 4;
            }
            return retVal;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }

    boolean noCompletion(XMLSyntaxSupport support, JTextComponent target) {
        if (target == null || target.getCaret() == null) {
            return false;
        }
        int offset = target.getCaret().getDot();
        if (offset < 0) {
            return false;
        }
        try {
            return support.runWithSequence(offset, ts -> {
                Token token = ts.token();
                if (token == null) {
                    if (!ts.moveNext()) {
                        return false;
                    }
                    token = ts.token();
                    if (token == null) {
                        return false;
                    }
                }
                if (token.id() == XMLTokenId.CDATA_SECTION || token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.PI_START || token.id() == XMLTokenId.PI_END || token.id() == XMLTokenId.PI_CONTENT || token.id() == XMLTokenId.PI_TARGET) {
                    return true;
                }
                return false;
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1 || queryType == 9) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    private static void checkHideCompletion(BaseDocument doc, int caretOffset) {
        XMLSyntaxSupport sup = XMLSyntaxSupport.getSyntaxSupport((Document)doc);
        try {
            Token<XMLTokenId> ti = sup.getNextToken(caretOffset <= 0 ? 1 : caretOffset - 1);
            if (ti != null && ti.id() == XMLTokenId.TEXT && !ti.text().toString().startsWith("<") && !ti.text().toString().startsWith("&")) {
                XMLCompletionProvider.hideCompletion();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
    }

    static class Query
    extends AsyncCompletionQuery {
        private static final XMLCompletionQuery QUERY = new XMLCompletionQuery();
        private JTextComponent component;

        Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            XMLSyntaxSupport support = XMLSyntaxSupport.getSyntaxSupport(doc);
            if (support == null) {
                resultSet.finish();
                return;
            }
            resultSet.setWaitText(NbBundle.getMessage(XMLCompletionProvider.class, (String)"MSG_loading_dtd"));
            List<CompletionItem> items = QUERY.query(this.component, caretOffset, XMLSyntaxSupport.getSyntaxSupport((Document)((BaseDocument)doc)));
            if (items != null) {
                resultSet.addAllItems(items);
            }
            resultSet.finish();
        }
    }
}

