/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.utilities.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.utilities.ui.SelectHandlerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WSHandlerDialog {
    private Dialog dialog;
    private SelectHandlerPanel sPanel;
    private AddMessageHandlerDialogDesc dlgDesc;
    private boolean isJaxWS;
    private Map<String, Integer> handlerMap;
    public static final int JAXWS_LOGICAL_HANDLER = 1;
    public static final int JAXWS_MESSAGE_HANDLER = 2;
    public static final int JAXRPC_MESSAGE_HANDLER = 3;
    public static final int INVALID_HANDLER = -1;

    public WSHandlerDialog(Project project, boolean isJaxWS) {
        this.isJaxWS = isJaxWS;
        this.sPanel = new SelectHandlerPanel(project);
        this.dlgDesc = new AddMessageHandlerDialogDesc(this.sPanel);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.dlgDesc);
        this.dialog.getAccessibleContext().setAccessibleDescription(this.dialog.getTitle());
        this.handlerMap = new TreeMap<String, Integer>();
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public boolean okButtonPressed() {
        return this.dlgDesc.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Map<String, Integer> getSelectedClasses() {
        return this.handlerMap;
    }

    private FileObject getFileObjectFromNode(Node n) {
        DataObject dObj = (DataObject)n.getCookie(DataObject.class);
        if (dObj != null) {
            return dObj.getPrimaryFile();
        }
        return null;
    }

    public static void runTask(boolean firstTask, final JavaSource javaSource, final CancellableTask<CompilationController> task) {
        if (firstTask) {
            ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        javaSource.runUserActionTask((Task)task, true);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            }, (String)NbBundle.getMessage(WSHandlerDialog.class, (String)"LBL_SearchHandlers"));
        } else {
            try {
                javaSource.runUserActionTask(task, true);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    public static int getHandlerType(CompilationController cc, boolean isJaxWS) throws IOException {
        TypeElement typeElement = SourceUtils.getPublicTopLevelElement(cc);
        if (typeElement != null) {
            TypeMirror classMirror = typeElement.asType();
            if (isJaxWS) {
                WildcardType wildcardType;
                TypeElement messageContextElement;
                TypeElement handlerElement = cc.getElements().getTypeElement("javax.xml.ws.handler.LogicalHandler");
                DeclaredType handlerType = null;
                if (handlerElement != null) {
                    messageContextElement = cc.getElements().getTypeElement("javax.xml.ws.handler.LogicalMessageContext");
                    wildcardType = cc.getTypes().getWildcardType(messageContextElement.asType(), null);
                    handlerType = cc.getTypes().getDeclaredType(handlerElement, wildcardType);
                }
                if (handlerType != null && cc.getTypes().isAssignable(classMirror, handlerType)) {
                    return 1;
                }
                handlerElement = cc.getElements().getTypeElement("javax.xml.ws.handler.Handler");
                handlerType = null;
                if (handlerElement != null) {
                    messageContextElement = cc.getElements().getTypeElement("javax.xml.ws.handler.MessageContext");
                    wildcardType = cc.getTypes().getWildcardType(messageContextElement.asType(), null);
                    handlerType = cc.getTypes().getDeclaredType(handlerElement, wildcardType);
                }
                if (handlerType != null && cc.getTypes().isAssignable(classMirror, handlerType)) {
                    return 2;
                }
            } else {
                TypeElement handlerElement = cc.getElements().getTypeElement("javax.xml.rpc.handler.Handler");
                if (handlerElement != null && cc.getTypes().isSubtype(classMirror, handlerElement.asType())) {
                    return 3;
                }
            }
        }
        return -1;
    }

    class AddMessageHandlerDialogDesc
    extends DialogDescriptor {
        Project project;
        final SelectHandlerPanel sPanel;
        private Object[] closingOptionsWithoutOK;
        private Object[] closingOptionsWithOK;

        public AddMessageHandlerDialogDesc(SelectHandlerPanel sPanel) {
            super((Object)sPanel, NbBundle.getMessage(WSHandlerDialog.class, (String)"TTL_SelectHandler"));
            this.closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
            this.closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};
            this.sPanel = sPanel;
            this.setButtonListener(new AddMessageActionListener(sPanel));
        }

        class AddMessageActionListener
        implements ActionListener {
            SelectHandlerPanel sPanel;

            public AddMessageActionListener(SelectHandlerPanel sPanel) {
                this.sPanel = sPanel;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean accepted = true;
                    String errMsg = null;
                    Node[] selectedNodes = this.sPanel.getSelectedNodes();
                    for (int i = 0; i < selectedNodes.length; ++i) {
                        Node node = selectedNodes[i];
                        FileObject javaClassFo = WSHandlerDialog.this.getFileObjectFromNode(node);
                        if (javaClassFo == null) {
                            errMsg = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotJavaClass_msg");
                            accepted = false;
                            break;
                        }
                        final int[] handlerType = new int[]{1};
                        JavaSource javaSource = JavaSource.forFileObject((FileObject)javaClassFo);
                        if (javaSource == null) {
                            errMsg = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotJavaClass_msg");
                            accepted = false;
                            break;
                        }
                        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                            public void run(CompilationController controller) throws IOException {
                                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                handlerType[0] = WSHandlerDialog.getHandlerType(controller, WSHandlerDialog.this.isJaxWS);
                            }

                            public void cancel() {
                            }
                        };
                        WSHandlerDialog.runTask(i == 0, javaSource, task);
                        if (handlerType[0] == -1) {
                            errMsg = NbBundle.getMessage(WSHandlerDialog.class, (String)"NotHandlerClass_msg");
                            accepted = false;
                            break;
                        }
                        FileObject fo = WSHandlerDialog.this.getFileObjectFromNode(node);
                        if (fo == null) continue;
                        ClassPath classPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                        String handlerClassName = classPath.getResourceName(fo, '.', false);
                        WSHandlerDialog.this.handlerMap.put(handlerClassName, handlerType[0]);
                    }
                    if (!accepted) {
                        NotifyDescriptor.Message notifyDescr = new NotifyDescriptor.Message(errMsg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescr);
                        AddMessageHandlerDialogDesc.this.setClosingOptions(AddMessageHandlerDialogDesc.this.closingOptionsWithoutOK);
                    } else {
                        AddMessageHandlerDialogDesc.this.setClosingOptions(AddMessageHandlerDialogDesc.this.closingOptionsWithOK);
                    }
                }
            }
        }
    }
}

