/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.sass;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.sass.SassCli;
import org.netbeans.modules.css.prep.util.FileUtils;
import org.netbeans.modules.css.prep.util.VersionOutputProcessorFactory;
import org.netbeans.modules.web.common.api.Version;
import org.openide.modules.Places;
import org.openide.windows.InputOutput;

final class SassExecutable
extends SassCli {
    private static final Logger LOGGER = Logger.getLogger(SassExecutable.class.getName());
    private static final String EXECUTABLE_NAME = "sass";
    private static final String EXECUTABLE_LONG_NAME = "sass" + FileUtils.getScriptExtension(true, false);
    static final String[] EXECUTABLE_NAMES = new String[]{"sass", EXECUTABLE_LONG_NAME};
    private static final String DEBUG_PARAM = "--debug-info";
    private static final String SOURCEMAP_PARAM = "--sourcemap";
    private static final String SOURCEMAP_WITH_VALUE_PARAM = "--sourcemap=%s";
    private static final String VERSION_PARAM = "--version";
    private static final String CACHE_LOCATION_PARAM = "--cache-location";
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Version MINIMAL_VERSION_WITH_SOURCEMAP = Version.fromDottedNotationWithFallback((String)"3.3.0");
    private static final Version VERSION_WITH_DEFAULT_SOURCEMAP = Version.fromDottedNotationWithFallback((String)"3.4.0");
    static final String VERSION_PATTERN = "Sass\\s+(\\d+(\\.\\d+)*)";

    SassExecutable(String sassPath) {
        super(sassPath);
    }

    @CheckForNull
    private Version getVersion() {
        assert (!EventQueue.isDispatchThread());
        if (version != null) {
            return version;
        }
        VersionOutputProcessorFactory versionOutputProcessorFactory = new VersionOutputProcessorFactory(VERSION_PATTERN);
        try {
            this.getExecutable("Sass version", TMP_DIR).additionalParameters(Collections.singletonList(VERSION_PARAM)).runAndWait(SassExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)versionOutputProcessorFactory, "Detecting Sass version...");
            String detectedVersion = versionOutputProcessorFactory.getVersion();
            if (detectedVersion != null) {
                version = Version.fromDottedNotationWithFallback((String)detectedVersion);
                return version;
            }
        }
        catch (CancellationException ex) {
            assert (false);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return null;
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false);
    }

    @Override
    protected List<String> getParameters(File inputFile, File outputFile, List<String> compilerOptions) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(CACHE_LOCATION_PARAM);
        params.add(Places.getCacheSubdirectory((String)"sass-compiler").getAbsolutePath());
        boolean debug = CssPrepOptions.getInstance().getSassDebug();
        Version installedVersion = this.getVersion();
        if (debug) {
            if (installedVersion != null) {
                if (!installedVersion.isAboveOrEqual(VERSION_WITH_DEFAULT_SOURCEMAP)) {
                    if (installedVersion.isAboveOrEqual(MINIMAL_VERSION_WITH_SOURCEMAP)) {
                        params.add(SOURCEMAP_PARAM);
                    } else {
                        params.add(DEBUG_PARAM);
                    }
                }
            } else {
                params.add(DEBUG_PARAM);
            }
        } else if (installedVersion != null && installedVersion.isAboveOrEqual(VERSION_WITH_DEFAULT_SOURCEMAP)) {
            params.add(String.format(SOURCEMAP_WITH_VALUE_PARAM, "none"));
        }
        params.addAll(compilerOptions);
        params.add(inputFile.getAbsolutePath());
        params.add(outputFile.getAbsolutePath());
        return params;
    }
}

