/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javawebstart.CustomizerRunComponent;
import org.netbeans.modules.javawebstart.ui.customizer.AppletParametersPanel;
import org.netbeans.modules.javawebstart.ui.customizer.ExtensionResourcesPanel;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.modules.javawebstart.ui.customizer.ResourcesCustomizer;
import org.netbeans.modules.javawebstart.ui.customizer.SigningPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JWSCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private JWSProjectProperties jwsProps;
    private File lastImageFolder = null;
    private static String[] extResColumnNames;
    private static String[] appletParamsColumnNames;
    public static CustomizerRunComponent runComponent;
    private JComboBox appletClassComboBox;
    private JLabel appletClassLabel;
    private JRadioButton appletDescRadioButton;
    private JButton appletParamsButton;
    private JRadioButton applicationDescRadioButton;
    private JButton browseButton;
    private JComboBox codebaseComboBox;
    private JLabel codebaseLabel;
    private JTextField codebaseTextField;
    private JLabel codebaseValueLabel;
    private JRadioButton compDescRadioButton;
    private ButtonGroup descButtonGroup;
    private JCheckBox enableCheckBox;
    private JButton extResButton;
    private Box.Filler filler3;
    private JLabel iconLabel;
    private JTextField iconTextField;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JCheckBox offlineCheckBox;
    private JLabel panelDescLabel;
    private JButton signingCustomizeButton;
    private JLabel signingInfolabel;
    private JLabel signingWarning;

    public JWSCustomizerPanel(JWSProjectProperties props) {
        this.jwsProps = props;
        this.initComponents();
        this.enableCheckBox.setModel(this.jwsProps.enabledModel);
        this.enableCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.enableCheckBox.mnemonic").toCharArray()[0]);
        this.offlineCheckBox.setModel(this.jwsProps.allowOfflineModel);
        this.offlineCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.offlineCheckBox.mnemonic").toCharArray()[0]);
        this.refreshSigningLabel();
        this.iconTextField.setDocument(this.jwsProps.iconDocument);
        this.codebaseComboBox.setModel(this.jwsProps.codebaseModel);
        this.codebaseTextField.setDocument(this.jwsProps.codebaseURLDocument);
        this.appletClassComboBox.setModel(this.jwsProps.appletClassModel);
        this.applicationDescRadioButton.setModel(this.jwsProps.applicationDescButtonModel);
        this.applicationDescRadioButton.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.applicationDescRadioButton.mnemonic").toCharArray()[0]);
        this.appletDescRadioButton.setModel(this.jwsProps.appletDescButtonModel);
        this.appletDescRadioButton.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletDescRadioButton.mnemonic").toCharArray()[0]);
        this.compDescRadioButton.setModel(this.jwsProps.compDescButtonModel);
        this.compDescRadioButton.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.compDescRadioButton.mnemonic").toCharArray()[0]);
        this.setCodebaseComponents();
        boolean enableSelected = this.enableCheckBox.getModel().isSelected();
        this.setEnabledAllComponents(enableSelected);
        JWSCustomizerPanel.setEnabledRunComponent(enableSelected);
        this.setEnabledAppletControls(this.appletDescRadioButton.isSelected());
        extResColumnNames = new String[]{NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResources.href"), NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResources.name"), NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResources.version")};
        appletParamsColumnNames = new String[]{NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParams.name"), NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParams.value")};
    }

    private void refreshSigningLabel() {
        if ("generated".equals(this.jwsProps.signing)) {
            this.signingInfolabel.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.Signing.Generated"));
            this.signingWarning.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"SigningPanel.WarnDeprecated"));
            this.signingWarning.setVisible(true);
        } else if ("key".equals(this.jwsProps.signing)) {
            this.signingInfolabel.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.Signing.Key", (Object)this.jwsProps.signingKeyAlias));
            this.signingWarning.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"SigningPanel.InfoDeprecated"));
            this.signingWarning.setVisible(true);
        } else {
            this.signingInfolabel.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.Signing.Unsigned"));
            this.signingWarning.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"SigningPanel.WarnDeprecated"));
            this.signingWarning.setVisible(true);
        }
    }

    private static void setEnabledRunComponent(boolean enable) {
        runComponent.setCheckboxEnabled(enable);
        runComponent.setHintVisible(!enable);
    }

    private void initComponents() {
        this.descButtonGroup = new ButtonGroup();
        this.enableCheckBox = new JCheckBox();
        this.iconLabel = new JLabel();
        this.codebaseLabel = new JLabel();
        this.iconTextField = new JTextField();
        this.browseButton = new JButton();
        this.codebaseComboBox = new JComboBox();
        this.codebaseValueLabel = new JLabel();
        this.codebaseTextField = new JTextField();
        this.offlineCheckBox = new JCheckBox();
        this.panelDescLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.signingInfolabel = new JLabel();
        this.signingCustomizeButton = new JButton();
        this.signingWarning = new JLabel();
        this.jPanel1 = new JPanel();
        this.applicationDescRadioButton = new JRadioButton();
        this.appletClassLabel = new JLabel();
        this.compDescRadioButton = new JRadioButton();
        this.appletDescRadioButton = new JRadioButton();
        this.appletClassComboBox = new JComboBox();
        this.appletParamsButton = new JButton();
        this.jPanel2 = new JPanel();
        this.extResButton = new JButton();
        this.filler3 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.jButton1 = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.enableCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.enableCheckBox.text"));
        this.enableCheckBox.setMargin(new Insets(0, 0, 0, 2));
        this.enableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.enableCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.enableCheckBox, gridBagConstraints);
        this.enableCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_EnableWebStart_CheckBox"));
        this.enableCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_EnableWebStart_Label"));
        this.iconLabel.setLabelFor(this.iconTextField);
        Mnemonics.setLocalizedText((JLabel)this.iconLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.iconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.iconLabel, gridBagConstraints);
        this.iconLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Icon_Label"));
        this.iconLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Icon_Label"));
        this.codebaseLabel.setLabelFor(this.codebaseComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codebaseLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.codebaseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.codebaseLabel, gridBagConstraints);
        this.codebaseLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Label"));
        this.codebaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.iconTextField, gridBagConstraints);
        this.iconTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Icon_TextField"));
        this.iconTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Icon_TextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Browse_Button"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Browse_Button"));
        this.codebaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.codebaseComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.codebaseComboBox, gridBagConstraints);
        this.codebaseComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Combobox"));
        this.codebaseComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Combobox"));
        this.codebaseValueLabel.setLabelFor(this.codebaseTextField);
        Mnemonics.setLocalizedText((JLabel)this.codebaseValueLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.codebaseValueLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.codebaseValueLabel, gridBagConstraints);
        this.codebaseValueLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Result_Label"));
        this.codebaseValueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Result_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.codebaseTextField, gridBagConstraints);
        this.codebaseTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_TextField"));
        this.codebaseTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_TextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.offlineCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.offlineCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.add((Component)this.offlineCheckBox, gridBagConstraints);
        this.offlineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_AllowOffline_Checkbox"));
        this.offlineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_AllowOffline_Checkbox"));
        Mnemonics.setLocalizedText((JLabel)this.panelDescLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.panelDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.panelDescLabel, gridBagConstraints);
        this.panelDescLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_WebStartTitle_Label"));
        this.panelDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_WebStartTitle_Label"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.signingInfolabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.signingCustomizeButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.signingCustomizeButton.text"));
        this.signingCustomizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.signingCustomizeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.signingCustomizeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.signingWarning, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.signingWarning.text"));
        this.signingWarning.setVerticalAlignment(1);
        this.signingWarning.setPreferredSize(new Dimension(400, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.signingWarning, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.descButtonGroup.add(this.applicationDescRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.applicationDescRadioButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.applicationDescRadioButton.text"));
        this.applicationDescRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.applicationDescRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.applicationDescRadioButton, gridBagConstraints);
        this.applicationDescRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.applicationDescRadioButton.AccessibleContext.accessibleDescription"));
        this.appletClassLabel.setLabelFor(this.appletClassComboBox);
        Mnemonics.setLocalizedText((JLabel)this.appletClassLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 40, 0, 5);
        this.jPanel1.add((Component)this.appletClassLabel, gridBagConstraints);
        this.appletClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassLabel.AccessibleContext.accessibleDescription"));
        this.descButtonGroup.add(this.compDescRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.compDescRadioButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.compDescRadioButton.text"));
        this.compDescRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.compDescRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.compDescRadioButton, gridBagConstraints);
        this.compDescRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.compDescRadioButton.AccessibleContext.accessibleDescription"));
        this.descButtonGroup.add(this.appletDescRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.appletDescRadioButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletDescRadioButton.text"));
        this.appletDescRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.appletDescRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.appletDescRadioButton, gridBagConstraints);
        this.appletDescRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletDescRadioButton.AccessibleContext.accessibleDescription"));
        this.appletClassComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"org.testapplication.TestApplet", "Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.appletClassComboBox, gridBagConstraints);
        this.appletClassComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassComboBox.AccessibleContext.accessibleName"));
        this.appletClassComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.appletParamsButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParamsButton.text"));
        this.appletParamsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.appletParamsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.appletParamsButton, gridBagConstraints);
        this.appletParamsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParamsButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.extResButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResButton.text"));
        this.extResButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.extResButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.extResButton);
        this.extResButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResButton.AccessibleContext.accessibleDescription"));
        this.jPanel2.add(this.filler3);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TXT_ResourcesButton"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JWSCustomizerPanel.this.manageResources(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jSeparator3, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.AccessibleContext.accessibleDescription"));
    }

    private void codebaseComboBoxActionPerformed(ActionEvent evt) {
        this.setCodebaseComponents();
    }

    private void enableCheckBoxActionPerformed(ActionEvent evt) {
        boolean isSelected = this.enableCheckBox.getModel().isSelected();
        this.setEnabledAllComponents(isSelected);
        JWSCustomizerPanel.setEnabledRunComponent(isSelected);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new IconFileFilter());
        if (this.lastImageFolder != null) {
            chooser.setSelectedFile(this.lastImageFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"LBL_Select_Icon_Image"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.iconTextField.setText(file.getAbsolutePath());
            this.lastImageFolder = file.getParentFile();
        }
    }

    private void applicationDescRadioButtonActionPerformed(ActionEvent evt) {
        this.setEnabledAppletControls(false);
        this.jwsProps.updateDescType();
    }

    private void extResButtonActionPerformed(ActionEvent evt) {
        List<Map<String, String>> origProps = this.jwsProps.getExtResProperties();
        List<Map<String, String>> props = this.copyList(origProps);
        ExtensionResourcesPanel panel = new ExtensionResourcesPanel(new JWSProjectProperties.PropertiesTableModel(props, JWSProjectProperties.extResSuffixes, extResColumnNames));
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TITLE_ExtensionResources"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            this.jwsProps.setExtResProperties(props);
        }
        dialog.dispose();
    }

    private void appletDescRadioButtonActionPerformed(ActionEvent evt) {
        this.setEnabledAppletControls(true);
        this.jwsProps.updateDescType();
    }

    private void compDescRadioButtonActionPerformed(ActionEvent evt) {
        this.setEnabledAppletControls(false);
        this.jwsProps.updateDescType();
    }

    private void appletParamsButtonActionPerformed(ActionEvent evt) {
        List<Map<String, String>> origProps = this.jwsProps.getAppletParamsProperties();
        List<Map<String, String>> props = this.copyList(origProps);
        JWSProjectProperties.PropertiesTableModel appletParamsTableModel = new JWSProjectProperties.PropertiesTableModel(props, JWSProjectProperties.appletParamsSuffixes, appletParamsColumnNames);
        AppletParametersPanel panel = new AppletParametersPanel(appletParamsTableModel, this.jwsProps.appletWidthDocument, this.jwsProps.appletHeightDocument);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TITLE_AppletParameters"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            this.jwsProps.setAppletParamsProperties(props);
        }
        dialog.dispose();
    }

    private void signingCustomizeButtonActionPerformed(ActionEvent evt) {
        SigningPanel panel = new SigningPanel(this.jwsProps);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(SigningPanel.class, (String)"TITLE_SigningPanel"), true, null);
        panel.registerListeners();
        panel.setDialogDescriptor(dialogDesc);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
        if (dialogDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.store();
            this.refreshSigningLabel();
        }
        panel.unregisterListeners();
        dialog.dispose();
    }

    private void manageResources(ActionEvent evt) {
        ResourcesCustomizer rc = new ResourcesCustomizer(this.jwsProps.runtimeCP, this.jwsProps.lazyJars);
        DialogDescriptor dd = new DialogDescriptor((Object)rc, NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TXT_ManageResources"), true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            this.jwsProps.lazyJars = rc.getResources();
            this.jwsProps.lazyJarsChanged = true;
        }
    }

    private void setEnabledAppletControls(boolean b) {
        this.appletClassLabel.setEnabled(b);
        this.appletClassComboBox.setEnabled(b);
        this.appletParamsButton.setEnabled(b);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JWSCustomizerPanel.class);
    }

    private JWSProjectProperties.CodebaseComboBoxModel getCBModel() {
        return (JWSProjectProperties.CodebaseComboBoxModel)this.codebaseComboBox.getModel();
    }

    private void setCodebaseComponents() {
        String value = this.getCBModel().getSelectedCodebaseItem();
        if ("local".equals(value)) {
            this.codebaseTextField.setText(this.jwsProps.getProjectDistDir());
            this.codebaseTextField.setEditable(false);
        } else if ("web".equals(value)) {
            this.codebaseTextField.setText("$$codebase");
            this.codebaseTextField.setEditable(false);
        } else if ("user".equals(value)) {
            this.codebaseTextField.setText(this.jwsProps.getCodebaseLocation());
            this.codebaseTextField.setEditable(true);
        } else if ("no.codebase".equals(value)) {
            this.codebaseTextField.setText("");
            this.codebaseTextField.setEditable(false);
        }
    }

    private void setEnabledAllComponents(boolean b) {
        this.iconLabel.setEnabled(b);
        this.iconTextField.setEnabled(b);
        this.browseButton.setEnabled(b);
        this.codebaseLabel.setEnabled(b);
        this.codebaseComboBox.setEnabled(b);
        this.codebaseValueLabel.setEnabled(b);
        this.codebaseTextField.setEnabled(b);
        this.offlineCheckBox.setEnabled(b);
        this.jLabel1.setEnabled(b);
        this.signingInfolabel.setEnabled(b);
        this.signingCustomizeButton.setEnabled(b);
        this.signingWarning.setEnabled(b);
        this.extResButton.setEnabled(b);
        this.applicationDescRadioButton.setEnabled(b);
        this.appletDescRadioButton.setEnabled(b);
        this.jButton1.setEnabled(b);
        this.compDescRadioButton.setEnabled(b);
        if (!b || b && this.appletDescRadioButton.isSelected()) {
            this.setEnabledAppletControls(b);
        }
    }

    private List<Map<String, String>> copyList(List<Map<String, String>> list2Copy) {
        ArrayList<Map<String, String>> list2Return = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : list2Copy) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (String key : map.keySet()) {
                String value = map.get(key);
                newMap.put(key, value);
            }
            list2Return.add(newMap);
        }
        return list2Return;
    }

    static {
        runComponent = new CustomizerRunComponent();
    }

    private static class IconFileFilter
    extends FileFilter {
        private IconFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String ext;
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            return index > 0 && index < name.length() - 1 && ("gif".equals(ext = name.substring(index + 1).toLowerCase()) || "png".equals(ext) || "jpg".equals(ext));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(JWSCustomizerPanel.class, (String)"MSG_IconFileFilter_Description");
        }
    }
}

