/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.lsp4j.generator.TypeAdapterImpl;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TypeAdapterImplProcessor
extends AbstractClassProcessor {
    public void doRegisterGlobals(ClassDeclaration annotatedClass, @Extension RegisterGlobalsContext context) {
        String _qualifiedName = annotatedClass.getQualifiedName();
        String _plus = _qualifiedName + ".Factory";
        context.registerClass(_plus);
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        AnnotationReference typeAdapterImplAnnotation = annotatedClass.findAnnotation(context.findTypeGlobally(TypeAdapterImpl.class));
        TypeReference targetType = typeAdapterImplAnnotation.getClassValue("value");
        this.generateImpl(annotatedClass, targetType, context);
        String _qualifiedName = annotatedClass.getQualifiedName();
        String _plus = _qualifiedName + ".Factory";
        this.generateFactory(context.findClass(_plus), annotatedClass, targetType, context);
    }

    protected MutableClassDeclaration generateImpl(MutableClassDeclaration impl, final TypeReference targetType, final @Extension TransformationContext context) {
        final ArrayList<FieldDeclaration> targetFields = this.getTargetFields(targetType, context);
        Functions.Function1 _function = it -> !it.getType().isPrimitive() && !it.getType().getActualTypeArguments().isEmpty();
        Iterable _filter = IterableExtensions.filter(targetFields, (Functions.Function1)_function);
        for (final FieldDeclaration field : _filter) {
            String _upperCase = field.getSimpleName().toUpperCase();
            String _plus = _upperCase + "_TYPE_TOKEN";
            Procedures.Procedure1 _function_1 = it -> {
                it.setFinal(true);
                it.setStatic(true);
                it.setType(context.newTypeReference("com.google.gson.reflect.TypeToken", new TypeReference[]{field.getType()}));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"new TypeToken<");
                        TypeReference _type = field.getType();
                        _builder.append((Object)_type);
                        _builder.append((Object)">() {}");
                    }
                };
                it.setInitializer(_client);
            };
            impl.addField(_plus, _function_1);
        }
        impl.setExtendedClass(context.newTypeReference("com.google.gson.TypeAdapter", new TypeReference[]{targetType}));
        Procedures.Procedure1 _function_2 = it -> {
            it.setType(context.newTypeReference("com.google.gson.Gson", new TypeReference[0]));
            it.setFinal(true);
        };
        impl.addField("gson", _function_2);
        Procedures.Procedure1 _function_3 = it -> {
            it.addParameter("gson", context.newTypeReference("com.google.gson.Gson", new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"this.gson = gson;");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        impl.addConstructor(_function_3);
        Procedures.Procedure1 _function_4 = method -> {
            method.addParameter("in", context.newTypeReference("com.google.gson.stream.JsonReader", new TypeReference[0]));
            method.setExceptions(new TypeReference[]{context.newTypeReference(IOException.class, new TypeReference[0])});
            method.setReturnType(targetType);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    TypeReference _newTypeReference = context.newTypeReference("com.google.gson.stream.JsonToken", new TypeReference[0]);
                    _builder.append((Object)_newTypeReference);
                    _builder.append((Object)" nextToken = in.peek();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (nextToken == JsonToken.NULL) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return null;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)targetType);
                    _builder.append((Object)" result = new ");
                    _builder.append((Object)targetType);
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"in.beginObject();");
                    _builder.newLine();
                    _builder.append((Object)"while (in.hasNext()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"String name = in.nextName();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"switch (name) {");
                    _builder.newLine();
                    for (FieldDeclaration field : targetFields) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"case \"");
                        String _simpleName = field.getSimpleName();
                        _builder.append((Object)_simpleName, "\t");
                        _builder.append((Object)"\":");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"result.set");
                        String _firstUpper = StringExtensions.toFirstUpper((String)field.getSimpleName());
                        _builder.append((Object)_firstUpper, "\t\t");
                        _builder.append((Object)"(read");
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)field.getSimpleName());
                        _builder.append((Object)_firstUpper_1, "\t\t");
                        _builder.append((Object)"(in));");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"break;");
                        _builder.newLine();
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"default:");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"in.skipValue();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"in.endObject();");
                    _builder.newLine();
                    _builder.append((Object)"return result;");
                    _builder.newLine();
                }
            };
            method.setBody(_client);
        };
        impl.addMethod("read", _function_4);
        for (final FieldDeclaration field_1 : targetFields) {
            String _firstUpper = StringExtensions.toFirstUpper((String)field_1.getSimpleName());
            String _plus_1 = "read" + _firstUpper;
            MutableMethodDeclaration existingMethod = impl.findDeclaredMethod(_plus_1, new TypeReference[]{context.newTypeReference("com.google.gson.stream.JsonReader", new TypeReference[0])});
            if (existingMethod != null) continue;
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)field_1.getSimpleName());
            String _plus_2 = "read" + _firstUpper_1;
            Procedures.Procedure1 _function_5 = it -> {
                it.setVisibility(Visibility.PROTECTED);
                it.addParameter("in", context.newTypeReference("com.google.gson.stream.JsonReader", new TypeReference[0]));
                it.setExceptions(new TypeReference[]{context.newTypeReference(IOException.class, new TypeReference[0])});
                it.setReturnType(field_1.getType());
                boolean _isPrimitive = field_1.getType().isPrimitive();
                if (_isPrimitive) {
                    String _simpleName = field_1.getType().getSimpleName();
                    if (_simpleName != null) {
                        switch (_simpleName) {
                            case "boolean": {
                                StringConcatenationClient _client = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"return in.nextBoolean();");
                                    }
                                };
                                it.setBody(_client);
                                break;
                            }
                            case "double": {
                                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"return in.nextDouble();");
                                    }
                                };
                                it.setBody(_client_1);
                                break;
                            }
                            case "float": {
                                StringConcatenationClient _client_2 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"return (float) in.nextDouble();");
                                    }
                                };
                                it.setBody(_client_2);
                                break;
                            }
                            case "long": {
                                StringConcatenationClient _client_3 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"return in.nextLong();");
                                    }
                                };
                                it.setBody(_client_3);
                                break;
                            }
                            case "int": {
                                StringConcatenationClient _client_4 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"return in.nextInt();");
                                    }
                                };
                                it.setBody(_client_4);
                                break;
                            }
                            case "short": 
                            case "byte": 
                            case "char": {
                                StringConcatenationClient _client_5 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"return (");
                                        TypeReference _type = field_1.getType();
                                        _builder.append((Object)_type);
                                        _builder.append((Object)") in.nextInt();");
                                    }
                                };
                                it.setBody(_client_5);
                            }
                        }
                    }
                } else {
                    boolean _not;
                    boolean _isEmpty = field_1.getType().getActualTypeArguments().isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        StringConcatenationClient _client_6 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"return gson.fromJson(in, ");
                                String _upperCase = field_1.getSimpleName().toUpperCase();
                                _builder.append((Object)_upperCase);
                                _builder.append((Object)"_TYPE_TOKEN.getType());");
                            }
                        };
                        it.setBody(_client_6);
                    } else {
                        StringConcatenationClient _client_7 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"return gson.fromJson(in, ");
                                TypeReference _type = field_1.getType();
                                _builder.append((Object)_type);
                                _builder.append((Object)".class);");
                            }
                        };
                        it.setBody(_client_7);
                    }
                }
            };
            impl.addMethod(_plus_2, _function_5);
        }
        Procedures.Procedure1 _function_5 = method -> {
            method.addParameter("out", context.newTypeReference("com.google.gson.stream.JsonWriter", new TypeReference[0]));
            method.addParameter("value", targetType);
            method.setExceptions(new TypeReference[]{context.newTypeReference(IOException.class, new TypeReference[0])});
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (value == null) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"out.nullValue();");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"out.beginObject();");
                    _builder.newLine();
                    for (FieldDeclaration field : targetFields) {
                        _builder.append((Object)"out.name(\"");
                        String _simpleName = field.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"write");
                        String _firstUpper = StringExtensions.toFirstUpper((String)field.getSimpleName());
                        _builder.append((Object)_firstUpper);
                        _builder.append((Object)"(out, value.get");
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)field.getSimpleName());
                        _builder.append((Object)_firstUpper_1);
                        _builder.append((Object)"());");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"out.endObject();");
                    _builder.newLine();
                }
            };
            method.setBody(_client);
        };
        impl.addMethod("write", _function_5);
        for (final FieldDeclaration field_2 : targetFields) {
            String _firstUpper = StringExtensions.toFirstUpper((String)field_2.getSimpleName());
            String _plus_1 = "write" + _firstUpper;
            MutableMethodDeclaration existingMethod = impl.findDeclaredMethod(_plus_1, new TypeReference[]{context.newTypeReference("com.google.gson.stream.JsonWriter", new TypeReference[0]), field_2.getType()});
            if (existingMethod != null) continue;
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)field_2.getSimpleName());
            String _plus_2 = "write" + _firstUpper_1;
            Procedures.Procedure1 _function_6 = it -> {
                it.setVisibility(Visibility.PROTECTED);
                it.addParameter("out", context.newTypeReference("com.google.gson.stream.JsonWriter", new TypeReference[0]));
                it.addParameter("value", field_2.getType());
                it.setExceptions(new TypeReference[]{context.newTypeReference(IOException.class, new TypeReference[0])});
                boolean _isPrimitive = field_2.getType().isPrimitive();
                if (_isPrimitive) {
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"out.value(value);");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                } else {
                    boolean _not;
                    boolean _isEmpty = field_2.getType().getActualTypeArguments().isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        StringConcatenationClient _client_1 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"gson.toJson(value, ");
                                String _upperCase = field_2.getSimpleName().toUpperCase();
                                _builder.append((Object)_upperCase);
                                _builder.append((Object)"_TYPE_TOKEN.getType(), out);");
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        it.setBody(_client_1);
                    } else {
                        TypeReference _newTypeReference;
                        TypeReference _type = field_2.getType();
                        boolean _equals = Objects.equal((Object)_type, (Object)(_newTypeReference = context.newTypeReference(Object.class, new TypeReference[0])));
                        if (_equals) {
                            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"if (value == null)");
                                    _builder.newLine();
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"out.nullValue();");
                                    _builder.newLine();
                                    _builder.append((Object)"else");
                                    _builder.newLine();
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"gson.toJson(value, value.getClass(), out);");
                                    _builder.newLine();
                                }
                            };
                            it.setBody(_client_2);
                        } else {
                            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"gson.toJson(value, ");
                                    TypeReference _type = field_2.getType();
                                    _builder.append((Object)_type);
                                    _builder.append((Object)".class, out);");
                                    _builder.newLineIfNotEmpty();
                                }
                            };
                            it.setBody(_client_3);
                        }
                    }
                }
            };
            impl.addMethod(_plus_2, _function_6);
        }
        return impl;
    }

    protected MutableMethodDeclaration generateFactory(MutableClassDeclaration factory, final MutableClassDeclaration impl, final TypeReference targetType, @Extension TransformationContext context) {
        MutableMethodDeclaration _xblockexpression = null;
        TypeReference _newTypeReference = context.newTypeReference("com.google.gson.TypeAdapterFactory", new TypeReference[0]);
        factory.setImplementedInterfaces(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
        Procedures.Procedure1 _function = it -> {
            MutableTypeParameterDeclaration t = it.addTypeParameter("T", new TypeReference[0]);
            it.addParameter("gson", context.newTypeReference("com.google.gson.Gson", new TypeReference[0]));
            it.addParameter("typeToken", context.newTypeReference("com.google.gson.reflect.TypeToken", new TypeReference[]{context.newTypeReference((Type)t, new TypeReference[0])}));
            it.setReturnType(context.newTypeReference("com.google.gson.TypeAdapter", new TypeReference[]{context.newTypeReference((Type)t, new TypeReference[0])}));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (!");
                    _builder.append((Object)targetType);
                    _builder.append((Object)".class.isAssignableFrom(typeToken.getRawType())) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return null;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return (TypeAdapter<T>) new ");
                    _builder.append((Object)impl);
                    _builder.append((Object)"(gson);");
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
        };
        _xblockexpression = factory.addMethod("create", _function);
        return _xblockexpression;
    }

    private ArrayList<FieldDeclaration> getTargetFields(TypeReference targetType, @Extension TransformationContext context) {
        Type objectType = context.newTypeReference(Object.class, new TypeReference[0]).getType();
        ArrayList targetFields = CollectionLiterals.newArrayList();
        TypeReference typeRef = targetType;
        while (!Objects.equal((Object)typeRef.getType(), (Object)objectType)) {
            Type _type = typeRef.getType();
            ClassDeclaration clazz = (ClassDeclaration)_type;
            Functions.Function1 _function = it -> {
                boolean _isStatic = it.isStatic();
                return !_isStatic;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)clazz.getDeclaredFields(), (Functions.Function1)_function);
            Iterables.addAll((Collection)targetFields, (Iterable)_filter);
            typeRef = clazz.getExtendedClass();
        }
        return targetFields;
    }
}

