/**
 * The Rect interface is used to represent any rect value. This interface reflects the values in the underlying style property. Hence, modifications made to the CSSPrimitiveValue objects modify the style property.
 */
var Rect = {
}
/**
 * This attribute is used for the bottom of the rect.
 * @syntax rect.bottom
 * @returns {CSSPrimitiveValue} 
 */
Rect.prototype.bottom = new CSSPrimitiveValue();

/**
 * This attribute is used for the left of the rect.
 * @syntax rect.left
 * @returns {CSSPrimitiveValue} 
 */
Rect.prototype.left = new CSSPrimitiveValue();

/**
 * This attribute is used for the right of the rect.
 * @syntax rect.right
 * @returns {CSSPrimitiveValue} 
 */
Rect.prototype.right = new CSSPrimitiveValue();

/**
 * This attribute is used for the top of the rect.
 * @syntax rect.top
 * @returns {CSSPrimitiveValue} 
 */
Rect.prototype.top = new CSSPrimitiveValue();

/**
 * Represents the Rect prototype object.
 * @syntax Rect.prototype
 * @static
 */
Rect.prototype;

