/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Util.getViewHandler(context).initView(context);
        super.doPhase(context, lifecycle, listeners);
    }

    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        boolean isPostBack;
        Object request;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a pre created view in FacesContext");
            }
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
            if (!this.isPostback(facesContext)) {
                facesContext.responseComplete();
            }
            return;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = facesContext.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null && (request = facesContext.getExternalContext().getRequest()) instanceof HttpServletRequest) {
            viewId = ((HttpServletRequest)request).getServletPath();
        }
        if (viewId == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("viewId is null");
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
        }
        boolean bl = isPostBack = this.isPostback(facesContext) && !RestoreViewPhase.isErrorPage(facesContext);
        if (isPostBack) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            viewRoot = viewHandler.restoreView(facesContext, viewId);
            if (viewRoot == null) {
                if (this.is11CompatEnabled(facesContext)) {
                    viewRoot = viewHandler.createView(facesContext, viewId);
                    facesContext.renderResponse();
                } else {
                    Object[] params = new Object[]{viewId};
                    throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", params), viewId);
                }
            }
            facesContext.setViewRoot(viewRoot);
            this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Postback: Restored view for " + viewId);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("New request: creating a view for " + viewId);
            }
            viewRoot = Util.getViewHandler(facesContext).createView(facesContext, viewId);
            facesContext.setViewRoot(viewRoot);
            facesContext.renderResponse();
        }
        assert (null != viewRoot);
        if (isPostBack && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "+=+=+=+=+=+= Restored View Printout for " + viewId);
            DebugUtil.printTree((UIComponent)viewRoot, LOGGER, Level.FINEST);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RestoreViewPhase");
        }
    }

    protected void doPerComponentActions(FacesContext context, UIComponent uic) {
        ValueExpression valueExpression = uic.getValueExpression("binding");
        if (null != valueExpression) {
            valueExpression.setValue(context.getELContext(), (Object)uic);
        }
        Iterator kids = uic.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.doPerComponentActions(context, (UIComponent)kids.next());
        }
    }

    private boolean isPostback(FacesContext context) {
        String renderkitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderkitId);
        return rsm.isPostback(context);
    }

    private static boolean isErrorPage(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext context) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(context.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext context) {
        return this.getWebConfig(context).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

