/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.clock;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.clock.Clock;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ClockRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Clock clock = (Clock)component;
        if (clock.isSyncRequest()) {
            RequestContext.getCurrentInstance().addCallbackParam("datetime", System.currentTimeMillis());
            context.renderResponse();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Clock clock = (Clock)component;
        this.encodeMarkup(context, clock);
        this.encodeScript(context, clock);
    }

    protected void encodeMarkup(FacesContext context, Clock clock) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)clock);
        writer.writeAttribute("id", (Object)clock.getClientId(), null);
        writer.writeAttribute("class", (Object)"ui-clock ui-widget ui-widget-header ui-corner-all", null);
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, Clock clock) throws IOException {
        String clientId = clock.getClientId(context);
        String mode = clock.getMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Clock", clock.resolveWidgetVar(), clientId);
        wb.attr("mode", mode).attr("pattern", clock.getPattern(), null).attr("locale", context.getViewRoot().getLocale().toString());
        if (mode.equals("server")) {
            wb.attr("value", System.currentTimeMillis());
            if (clock.isAutoSync()) {
                wb.attr("autoSync", true).attr("syncInterval", clock.getSyncInterval());
            }
        }
        wb.finish();
    }
}

