/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import com.oracle.truffle.regex.tregex.buffer.ByteArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.CharRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.matchers.AnyMatcher;
import com.oracle.truffle.regex.tregex.matchers.BitSetMatcher;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.matchers.EmptyMatcher;
import com.oracle.truffle.regex.tregex.matchers.HybridBitSetMatcher;
import com.oracle.truffle.regex.tregex.matchers.MultiBitSetMatcher;
import com.oracle.truffle.regex.tregex.matchers.ProfilingCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeListMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeTreeMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.SingleRangeMatcher;
import com.oracle.truffle.regex.tregex.matchers.TwoCharMatcher;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Arrays;

public final class CharSet
implements ImmutableSortedListOfRanges,
Comparable<CharSet>,
JsonConvertible {
    private static final CharSet BYTE_RANGE;
    private static final CharSet CONSTANT_EMPTY;
    private static final CharSet CONSTANT_FULL;
    private static final CharSet[] CONSTANT_ASCII;
    private static final CharSet[] CONSTANT_INVERSE_ASCII;
    private static final CharSet[] CONSTANT_CASE_FOLD_ASCII;
    private static final CharSet[] CONSTANT_CODE_POINT_SETS_MB;
    private static final CharSet CONSTANT_TRAIL_SURROGATE_RANGE;
    private final char[] ranges;

    private CharSet(char[] ranges, boolean staticInit) {
        this.ranges = ranges;
        assert ((ranges.length & 1) == 0) : "ranges array must have an even length!";
        assert (this.rangesAreSortedAndDisjoint()) : CharSet.rangesToString(ranges, true);
        assert (staticInit || ranges.length != 0);
        assert (staticInit || ranges.length != 2 || ranges[0] != '\u0000' || ranges[1] != '\uffff');
    }

    private CharSet(char[] ranges) {
        this(ranges, false);
    }

    public char[] getRanges() {
        return this.ranges;
    }

    public static CharSet getEmpty() {
        return CONSTANT_EMPTY;
    }

    public static CharSet getFull() {
        return CONSTANT_FULL;
    }

    public static CharSet getTrailSurrogateRange() {
        return CONSTANT_TRAIL_SURROGATE_RANGE;
    }

    public static CharSet create(char ... ranges) {
        CharSet constant = CharSet.checkConstants(ranges, ranges.length);
        if (constant == null) {
            return new CharSet(ranges);
        }
        return constant;
    }

    public static CharSet create(CharRangesBuffer buf) {
        CharSet constant = CharSet.checkConstants(buf.getBuffer(), buf.length());
        if (constant == null) {
            return new CharSet(buf.toArray());
        }
        return constant;
    }

    public static CharSet fromSortedRanges(SortedListOfRanges codePointSet) {
        if (codePointSet.matchesNothing()) {
            return CONSTANT_EMPTY;
        }
        if (codePointSet.getHi(codePointSet.size() - 1) <= 65535) {
            CharSet ret;
            if (codePointSet.equalsListOfRanges(CONSTANT_FULL)) {
                return CONSTANT_FULL;
            }
            if (codePointSet.matchesSingleAscii()) {
                return CONSTANT_ASCII[codePointSet.getLo(0)];
            }
            if (codePointSet.size() == 2 && (ret = CharSet.checkInverseAndCaseFoldAscii(codePointSet.getLo(0), codePointSet.getHi(0), codePointSet.getLo(1), codePointSet.getHi(1))) != null) {
                return ret;
            }
            for (int i = 0; i < Constants.CONSTANT_CODE_POINT_SETS.length; ++i) {
                if (!codePointSet.equals(Constants.CONSTANT_CODE_POINT_SETS[i])) continue;
                return CONSTANT_CODE_POINT_SETS_MB[i];
            }
        }
        return CharSet.createTrimCodePointSet(codePointSet, true);
    }

    private static CharSet checkConstants(char[] ranges, int length) {
        CharSet ret;
        if (length == 0) {
            return CONSTANT_EMPTY;
        }
        if (length == 1) {
            if (ranges[0] < '\u0080') {
                return CONSTANT_ASCII[ranges[0]];
            }
            return new CharSet(new char[]{ranges[0], ranges[0]});
        }
        if (length == 2) {
            if (ranges[0] == ranges[1] && ranges[0] < '\u0080') {
                return CONSTANT_ASCII[ranges[0]];
            }
            if (ranges[0] == '\u0000' && ranges[1] == '\uffff') {
                return CONSTANT_FULL;
            }
        }
        if (length == 4 && (ret = CharSet.checkInverseAndCaseFoldAscii(ranges[0], ranges[1], ranges[2], ranges[3])) != null) {
            return ret;
        }
        for (CharSet predefCC : CONSTANT_CODE_POINT_SETS_MB) {
            if (predefCC.ranges.length != length || !CharSet.rangesEqual(predefCC.ranges, ranges, length)) continue;
            return predefCC;
        }
        return null;
    }

    private static boolean rangesEqual(char[] a, char[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static CharSet checkInverseAndCaseFoldAscii(int lo0, int hi0, int lo1, int hi1) {
        if (lo0 == 0 && hi1 == 65535 && lo1 <= 128 && hi0 + 2 == lo1) {
            return CONSTANT_INVERSE_ASCII[hi0 + 1];
        }
        if (lo0 == hi0 && lo0 >= 65 && lo0 <= 90 && lo1 == hi1 && lo1 == Character.toLowerCase(lo0)) {
            return CONSTANT_CASE_FOLD_ASCII[lo0 - 65];
        }
        return null;
    }

    private static CharSet createTrimCodePointSet(SortedListOfRanges codePointSet, boolean dedup) {
        int size = 0;
        for (int i = 0; i < codePointSet.size(); ++i) {
            if (!codePointSet.intersects(i, Constants.BMP_RANGE.getLo(0), Constants.BMP_RANGE.getHi(0))) continue;
            ++size;
        }
        char[] ranges = new char[size * 2];
        for (int i = 0; i < codePointSet.size(); ++i) {
            if (!codePointSet.intersects(i, Constants.BMP_RANGE.getLo(0), Constants.BMP_RANGE.getHi(0))) continue;
            CharSet.setRange(ranges, i, codePointSet.getLo(i), Math.min(codePointSet.getHi(i), Constants.BMP_RANGE.getHi(0)));
        }
        if (dedup) {
            CharSet cs = CharSet.checkConstants(ranges, ranges.length);
            return cs == null ? new CharSet(ranges) : cs;
        }
        return new CharSet(ranges);
    }

    private static void setRange(char[] arr, int i, int lo, int hi) {
        arr[i * 2] = (char)lo;
        arr[i * 2 + 1] = (char)hi;
    }

    @Override
    public boolean matchesNothing() {
        return this == CharSet.getEmpty();
    }

    @Override
    public boolean matchesEverything() {
        assert (this.size() != 1 || this.getLo(0) != this.getMinValue() || this.getHi(0) != this.getMaxValue() || this == CharSet.getFull());
        return this == CharSet.getFull();
    }

    public CharSet createEmpty() {
        return CharSet.getEmpty();
    }

    public CharSet createFull() {
        return CharSet.getFull();
    }

    public CharSet create(RangesBuffer buffer) {
        assert (buffer instanceof CharRangesBuffer);
        return CharSet.create((CharRangesBuffer)buffer);
    }

    @Override
    public int getMinValue() {
        return 0;
    }

    @Override
    public int getMaxValue() {
        return 65535;
    }

    @Override
    public int getLo(int i) {
        return this.ranges[i * 2];
    }

    @Override
    public int getHi(int i) {
        return this.ranges[i * 2 + 1];
    }

    @Override
    public int size() {
        return this.ranges.length / 2;
    }

    @Override
    public CharRangesBuffer getBuffer1(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getCharRangesBuffer1();
    }

    @Override
    public CharRangesBuffer getBuffer2(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getCharRangesBuffer2();
    }

    @Override
    public CharRangesBuffer getBuffer3(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getCharRangesBuffer3();
    }

    @Override
    public CharRangesBuffer createTempBuffer() {
        return new CharRangesBuffer();
    }

    @Override
    public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
        assert (buffer instanceof CharRangesBuffer);
        int bulkLength = (endIndex - startIndex) * 2;
        if (bulkLength == 0) {
            return;
        }
        CharRangesBuffer buf = (CharRangesBuffer)buffer;
        int newSize = buf.length() + bulkLength;
        buf.ensureCapacity(newSize);
        assert (buf.isEmpty() || this.rightOf(startIndex, buf, buf.size() - 1));
        System.arraycopy(this.ranges, startIndex * 2, buf.getBuffer(), buf.length(), bulkLength);
        buf.setLength(newSize);
    }

    @Override
    public boolean equalsBuffer(RangesBuffer buffer) {
        assert (buffer instanceof CharRangesBuffer);
        CharRangesBuffer buf = (CharRangesBuffer)buffer;
        return this.ranges.length == buf.length() && CharSet.rangesEqual(this.ranges, buf.getBuffer(), this.ranges.length);
    }

    public CharSet createInverse() {
        return CharSet.createInverse(this);
    }

    public static CharSet createInverse(SortedListOfRanges src) {
        assert (src.getMinValue() == 0);
        assert (src.getMaxValue() == 65535);
        if (src.matchesNothing()) {
            return CharSet.getFull();
        }
        if (src.matchesSingleAscii()) {
            return CONSTANT_INVERSE_ASCII[src.getLo(0)];
        }
        char[] invRanges = new char[src.sizeOfInverse() * 2];
        int i = 0;
        if (src.getLo(0) > src.getMinValue()) {
            CharSet.setRange(invRanges, i++, src.getMinValue(), src.getLo(0) - 1);
        }
        for (int ia = 1; ia < src.size(); ++ia) {
            CharSet.setRange(invRanges, i++, src.getHi(ia - 1) + 1, src.getLo(ia) - 1);
        }
        if (src.getHi(src.size() - 1) < src.getMaxValue()) {
            CharSet.setRange(invRanges, i++, src.getHi(src.size() - 1) + 1, src.getMaxValue());
        }
        return new CharSet(invRanges);
    }

    private static int highByte(int c) {
        return c >> 8;
    }

    private static int lowByte(int c) {
        return c & 0xFF;
    }

    private boolean allSameHighByte() {
        if (this.matchesNothing()) {
            return true;
        }
        int highByte = CharSet.highByte(this.getLo(0));
        for (int i = 0; i < this.size(); ++i) {
            if (CharSet.highByte(this.getLo(i)) == highByte && CharSet.highByte(this.getHi(i)) == highByte) continue;
            return false;
        }
        return true;
    }

    public CharMatcher createMatcher(CompilationBuffer compilationBuffer) {
        if (this.sizeOfInverse() < this.size() || this.size() > 1 && !this.allSameHighByte() && CharSet.highByte(this.getHi(0) + 1) == CharSet.highByte(this.getLo(this.size() - 1) - 1)) {
            return this.createInverse().createMatcher(compilationBuffer, true, true);
        }
        return this.createMatcher(compilationBuffer, false, true);
    }

    private CharMatcher createMatcher(CompilationBuffer compilationBuffer, boolean inverse, boolean tryHybrid) {
        CharMatcher charMatcher;
        if (this.matchesNothing()) {
            return EmptyMatcher.create(inverse);
        }
        if (this.matchesEverything()) {
            return AnyMatcher.create(inverse);
        }
        if (this.size() == 1) {
            if (this.isSingle(0)) {
                return SingleCharMatcher.create(inverse, (char)this.getLo(0));
            }
            if (this.size(0) == 1) {
                return TwoCharMatcher.create(inverse, (char)this.getLo(0), (char)this.getHi(0));
            }
            return SingleRangeMatcher.create(inverse, (char)this.getLo(0), (char)this.getHi(0));
        }
        if (this.size() == 2 && this.isSingle(0) && this.isSingle(1)) {
            return TwoCharMatcher.create(inverse, (char)this.getLo(0), (char)this.getLo(1));
        }
        if (this.preferRangeListMatcherOverBitSetMatcher()) {
            return RangeListMatcher.create(inverse, this.ranges);
        }
        if (this.allSameHighByte()) {
            CompilationFinalBitSet bs = this.convertToBitSet(0, this.size());
            int highByte = CharSet.highByte(this.getLo(0));
            return BitSetMatcher.create(inverse, highByte, bs);
        }
        if (this.size() > 100) {
            charMatcher = MultiBitSetMatcher.fromRanges(inverse, this.ranges);
        } else if (tryHybrid) {
            charMatcher = this.createHybridMatcher(compilationBuffer, inverse);
        } else if (this.size() <= 10) {
            charMatcher = RangeListMatcher.create(inverse, this.ranges);
        } else {
            assert (this.size() <= 100);
            charMatcher = RangeTreeMatcher.fromRanges(inverse, this.ranges);
        }
        return ProfilingCharMatcher.create(this.createIntersection(BYTE_RANGE, compilationBuffer).createMatcher(compilationBuffer, inverse, false), charMatcher);
    }

    private boolean preferRangeListMatcherOverBitSetMatcher() {
        return this.size() <= 2 || this.valueCount() <= 4;
    }

    private CompilationFinalBitSet convertToBitSet(int iMinArg, int iMaxArg) {
        CompilationFinalBitSet bs;
        assert (iMaxArg - iMinArg > 1);
        int highByte = CharSet.highByte(this.getLo(iMaxArg - 1));
        int iMax = iMaxArg;
        if (this.rangeCrossesPlanes(iMaxArg - 1)) {
            bs = new CompilationFinalBitSet(256);
            --iMax;
            bs.setRange(CharSet.lowByte(this.getLo(iMaxArg - 1)), 255);
        } else {
            bs = new CompilationFinalBitSet(Integer.highestOneBit(CharSet.lowByte(this.getHi(iMaxArg - 1))) << 1);
        }
        int iMin = iMinArg;
        if (this.rangeCrossesPlanes(iMinArg)) {
            assert (CharSet.highByte(this.getHi(iMinArg)) == highByte);
            ++iMin;
            bs.setRange(0, CharSet.lowByte(this.getHi(iMinArg)));
        }
        for (int i = iMin; i < iMax; ++i) {
            assert (CharSet.highByte(this.getLo(i)) == highByte && CharSet.highByte(this.getHi(i)) == highByte);
            bs.setRange(CharSet.lowByte(this.getLo(i)), CharSet.lowByte(this.getHi(i)));
        }
        return bs;
    }

    private CharMatcher createHybridMatcher(CompilationBuffer compilationBuffer, boolean inverse) {
        assert (this.size() > 1);
        CharRangesBuffer rest = compilationBuffer.getCharRangesBuffer1();
        ByteArrayBuffer highBytes = compilationBuffer.getByteArrayBuffer();
        ObjectArrayBuffer bitSets = compilationBuffer.getObjectBuffer1();
        int lowestRangeOnCurPlane = 0;
        boolean lowestRangeCanBeDeleted = !this.rangeCrossesPlanes(0);
        int curPlane = CharSet.highByte(this.getHi(0));
        for (int i = 1; i < this.size(); ++i) {
            if (CharSet.highByte(this.getLo(i)) != curPlane) {
                if (i - lowestRangeOnCurPlane >= 3) {
                    highBytes.add((byte)curPlane);
                    bitSets.add(this.convertToBitSet(lowestRangeOnCurPlane, i));
                    if (!lowestRangeCanBeDeleted) {
                        this.addRangeTo(rest, lowestRangeOnCurPlane);
                    }
                } else {
                    this.appendRangesTo(rest, lowestRangeOnCurPlane, i);
                }
                curPlane = CharSet.highByte(this.getLo(i));
                lowestRangeOnCurPlane = i;
                boolean bl = lowestRangeCanBeDeleted = !this.rangeCrossesPlanes(i);
            }
            if (CharSet.highByte(this.getHi(i)) == curPlane) continue;
            if (lowestRangeOnCurPlane != i) {
                if (i + 1 - lowestRangeOnCurPlane >= 3) {
                    highBytes.add((byte)curPlane);
                    bitSets.add(this.convertToBitSet(lowestRangeOnCurPlane, i + 1));
                    if (!lowestRangeCanBeDeleted) {
                        this.addRangeTo(rest, lowestRangeOnCurPlane);
                    }
                    lowestRangeCanBeDeleted = CharSet.highByte(this.getHi(i)) - CharSet.highByte(this.getLo(i)) == 1;
                } else {
                    this.appendRangesTo(rest, lowestRangeOnCurPlane, i);
                    lowestRangeCanBeDeleted = !this.rangeCrossesPlanes(i);
                }
            } else {
                lowestRangeCanBeDeleted = !this.rangeCrossesPlanes(i);
            }
            curPlane = CharSet.highByte(this.getHi(i));
            lowestRangeOnCurPlane = i;
        }
        if (this.size() - lowestRangeOnCurPlane >= 3) {
            highBytes.add((byte)curPlane);
            bitSets.add(this.convertToBitSet(lowestRangeOnCurPlane, this.size()));
            if (!lowestRangeCanBeDeleted) {
                this.addRangeTo(rest, lowestRangeOnCurPlane);
            }
        } else {
            this.appendRangesTo(rest, lowestRangeOnCurPlane, this.size());
        }
        if (highBytes.length() == 0) {
            assert (rest.length() == this.ranges.length);
            return this.createMatcher(compilationBuffer, inverse, false);
        }
        CharMatcher restMatcher = CharSet.create(rest).createMatcher(compilationBuffer, false, false);
        return HybridBitSetMatcher.create(inverse, highBytes.toArray(), bitSets.toArray(new CompilationFinalBitSet[bitSets.length()]), restMatcher);
    }

    private boolean rangeCrossesPlanes(int i) {
        return CharSet.highByte(this.getLo(i)) != CharSet.highByte(this.getHi(i));
    }

    public char[] inverseToCharArray() {
        char[] array = new char[this.inverseValueCount()];
        int index = 0;
        int lastHi = -1;
        for (int i = 0; i < this.size(); ++i) {
            for (int j = lastHi + 1; j < this.getLo(i); ++j) {
                array[index++] = (char)j;
            }
            lastHi = this.getHi(i);
        }
        for (int j = lastHi + 1; j <= this.getMaxValue(); ++j) {
            array[index++] = (char)j;
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.defaultToString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String rangesToString(char[] ranges) {
        return CharSet.rangesToString(ranges, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static String rangesToString(char[] ranges, boolean numeric) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; i += 2) {
            if (numeric) {
                sb.append("[").append((int)ranges[i]).append("-").append((int)ranges[i + 1]).append("]");
                continue;
            }
            sb.append(SortedListOfRanges.rangeToString(ranges[i], ranges[i + 1]));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CharSet) {
            return Arrays.equals(this.ranges, ((CharSet)obj).ranges);
        }
        if (obj instanceof SortedListOfRanges) {
            return this.equalsListOfRanges((SortedListOfRanges)obj);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    @Override
    public int compareTo(CharSet o) {
        if (this == o) {
            return 0;
        }
        if (this.matchesEverything()) {
            if (o.matchesEverything()) {
                return 0;
            }
            return 1;
        }
        if (this.matchesNothing()) {
            if (o.matchesNothing()) {
                return 0;
            }
            return -1;
        }
        if (o.matchesEverything()) {
            return -1;
        }
        if (o.matchesNothing()) {
            return 1;
        }
        int cmp = this.size() - o.size();
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.size(); ++i) {
            cmp = this.getLo(i) - o.getLo(i);
            if (cmp == 0) continue;
            return cmp;
        }
        return cmp;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.array(this.ranges);
    }

    static {
        char i;
        BYTE_RANGE = new CharSet(new char[]{'\u0000', '\u00ff'});
        CONSTANT_EMPTY = new CharSet(new char[0], true);
        CONSTANT_FULL = new CharSet(new char[]{'\u0000', '\uffff'}, true);
        CONSTANT_ASCII = new CharSet[128];
        CONSTANT_INVERSE_ASCII = new CharSet[128];
        CONSTANT_CASE_FOLD_ASCII = new CharSet[26];
        CONSTANT_TRAIL_SURROGATE_RANGE = new CharSet(new char[]{(char)Constants.TRAIL_SURROGATE_RANGE.getLo(0), (char)Constants.TRAIL_SURROGATE_RANGE.getHi(0)});
        CharSet.CONSTANT_ASCII[0] = new CharSet(new char[]{'\u0000', '\u0000'});
        CharSet.CONSTANT_INVERSE_ASCII[0] = new CharSet(new char[]{'\u0001', '\uffff'});
        for (i = '\u0001'; i < '\u0080'; i = (char)(i + '\u0001')) {
            CharSet.CONSTANT_ASCII[i] = new CharSet(new char[]{i, i});
            CharSet.CONSTANT_INVERSE_ASCII[i] = new CharSet(new char[]{'\u0000', (char)(i - '\u0001'), (char)(i + '\u0001'), '\uffff'});
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            CharSet.CONSTANT_CASE_FOLD_ASCII[i - 65] = new CharSet(new char[]{i, i, Character.toLowerCase(i), Character.toLowerCase(i)});
        }
        CONSTANT_CODE_POINT_SETS_MB = new CharSet[Constants.CONSTANT_CODE_POINT_SETS.length];
        for (i = '\u0000'; i < Constants.CONSTANT_CODE_POINT_SETS.length; ++i) {
            CharSet.CONSTANT_CODE_POINT_SETS_MB[i] = CharSet.createTrimCodePointSet(Constants.CONSTANT_CODE_POINT_SETS[i], false);
        }
    }
}

