/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.ModuleInfoUtils;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;

public class CompilerPluginVersionError
implements POMErrorFixProvider {
    private final Configuration configuration = new Configuration("CompilerPluginVersionError", Bundle.TIT_WrongCompilerVersion(), Bundle.DESC_ModulesNotSupported(), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        Plugin plg;
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return toRet;
        }
        if (ModuleInfoUtils.checkModuleInfoAndCompilerFit((Project)prj)) {
            return toRet;
        }
        int pos = -1;
        org.netbeans.modules.maven.model.pom.Project p = model.getProject();
        Build bld = p.getBuild();
        if (bld != null && (plg = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin")) != null) {
            pos = plg.findPosition();
        }
        if (pos == -1) {
            pos = p.findPosition();
        }
        if (pos == -1) {
            return toRet;
        }
        Document baseDocument = model.getBaseDocument();
        Line line = NbEditorUtilities.getLine((Document)baseDocument, (int)pos, (boolean)false);
        toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)Bundle.DESC_ModulesNotSupported(), Collections.singletonList(new UpdatePluginVersion(model)), (Document)baseDocument, (int)(line.getLineNumber() + 1)));
        return toRet;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public String getSavedValue(JComponent customCustomizer, String key) {
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private static class UpdatePluginVersion
    implements Fix {
        private final POMModel mdl;

        UpdatePluginVersion(POMModel model) {
            this.mdl = model;
        }

        public String getText() {
            return Bundle.TXT_UpdateCompiler();
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            if (!this.mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            PomModelUtils.implementInTransaction((Model)this.mdl, new Runnable(){

                @Override
                public void run() {
                    org.netbeans.modules.maven.model.pom.Project prj = UpdatePluginVersion.this.mdl.getProject();
                    ModelUtils.updatePluginVersion((String)"org.apache.maven.plugins", (String)"maven-compiler-plugin", (String)"3.6.1", (org.netbeans.modules.maven.model.pom.Project)prj);
                    ModelUtils.openAtPlugin((POMModel)UpdatePluginVersion.this.mdl, (String)"org.apache.maven.plugins", (String)"maven-compiler-plugin");
                }
            });
            return info;
        }
    }
}

