/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.BooleanQuery;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactNodeSelector;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MavenRepoProvider
implements SearchProvider {
    private static final RequestProcessor RP = new RequestProcessor(MavenRepoProvider.class.getName(), 10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        final ArtifactNodeSelector s = (ArtifactNodeSelector)Lookup.getDefault().lookup(ArtifactNodeSelector.class);
        if (s == null) {
            return;
        }
        final String q = request.getText();
        if (q == null || q.trim().isEmpty()) {
            return;
        }
        final List loadedRepos = RepositoryQueries.getLoadedContexts();
        if (loadedRepos.isEmpty()) {
            return;
        }
        ArrayList infos = new ArrayList();
        final ArrayList tempInfos = new ArrayList();
        RequestProcessor.Task searchTask = RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RepositoryQueries.Result result = RepositoryQueries.findResult(MavenRepoProvider.this.getQuery(q), (List)loadedRepos);
                    List list = tempInfos;
                    synchronized (list) {
                        tempInfos.addAll(result.getResults());
                    }
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    List list = tempInfos;
                    synchronized (list) {
                        tempInfos.clear();
                    }
                }
                catch (OutOfMemoryError oome) {
                    List list = tempInfos;
                    synchronized (list) {
                        tempInfos.clear();
                    }
                }
            }
        });
        try {
            searchTask.waitFinished(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList arrayList = tempInfos;
        synchronized (arrayList) {
            infos.addAll(tempInfos);
        }
        searchTask.cancel();
        Collections.sort(infos);
        HashSet<String> artifacts = new HashSet<String>();
        String ql = q.toLowerCase(Locale.ENGLISH);
        for (final NBVersionInfo art : infos) {
            String label = art.getGroupId() + " : " + art.getArtifactId();
            if (!artifacts.add(label)) continue;
            if (!label.toLowerCase(Locale.ENGLISH).contains(ql)) {
                String projectName = art.getProjectName();
                String projectDescription = art.getProjectDescription();
                if (projectName != null && projectName.toLowerCase(Locale.ENGLISH).contains(ql)) {
                    label = label + " (" + projectName + ")";
                } else if (projectDescription != null && projectDescription.toLowerCase(Locale.ENGLISH).contains(ql)) {
                    label = label + " \"" + projectDescription + "\"";
                }
            }
            if (response.addResult(new Runnable(){

                @Override
                public void run() {
                    s.select(art);
                }
            }, label)) continue;
            return;
        }
    }

    List<QueryField> getQuery(String q) {
        ArrayList<QueryField> fq = new ArrayList<QueryField>();
        String[] splits = q.split(" ");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("groupId");
        fields.add("artifactId");
        fields.add("name");
        fields.add("description");
        for (String one : splits) {
            if (one.trim().isEmpty()) continue;
            for (String fld : fields) {
                QueryField f = new QueryField();
                f.setField(fld);
                f.setValue(one);
                fq.add(f);
            }
        }
        return fq;
    }
}

