/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FlatTableHeaderUI
extends BasicTableHeaderUI {
    protected Color separatorColor;
    protected Color bottomSeparatorColor;
    protected int height;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTableHeaderUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.separatorColor = UIManager.getColor("TableHeader.separatorColor");
        this.bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
        this.height = UIManager.getInt("TableHeader.height");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.separatorColor = null;
        this.bottomSeparatorColor = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        TableCellRenderer defaultRenderer = this.header.getDefaultRenderer();
        boolean paintBorders = this.isSystemDefaultRenderer(defaultRenderer);
        if (!paintBorders && this.header.getColumnModel().getColumnCount() > 0) {
            Component rendererComponent = defaultRenderer.getTableCellRendererComponent(this.header.getTable(), "", false, false, -1, 0);
            paintBorders = this.isSystemDefaultRenderer(rendererComponent);
        }
        if (paintBorders) {
            this.paintColumnBorders(g, c);
        }
        super.paint(g, c);
        if (paintBorders) {
            this.paintDraggedColumnBorders(g, c);
        }
    }

    private boolean isSystemDefaultRenderer(Object headerRenderer) {
        String rendererClassName = headerRenderer.getClass().getName();
        return rendererClassName.equals("sun.swing.table.DefaultTableCellHeaderRenderer") || rendererClassName.equals("sun.swing.FilePane$AlignableTableHeaderRenderer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintColumnBorders(Graphics g, JComponent c) {
        float lineWidth;
        int width = c.getWidth();
        int height = c.getHeight();
        float topLineIndent = lineWidth = UIScale.scale(1.0f);
        float bottomLineIndent = lineWidth * 3.0f;
        TableColumnModel columnModel = this.header.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints(g2);
            g2.setColor(this.bottomSeparatorColor);
            g2.fill(new Rectangle2D.Float(0.0f, (float)height - lineWidth, width, lineWidth));
            g2.setColor(this.separatorColor);
            int sepCount = columnCount;
            if (this.header.getTable().getAutoResizeMode() != 0 && !this.isVerticalScrollBarVisible()) {
                --sepCount;
            }
            if (this.header.getComponentOrientation().isLeftToRight()) {
                int x = 0;
                for (int i = 0; i < sepCount; ++i) {
                    g2.fill(new Rectangle2D.Float((float)(x += columnModel.getColumn(i).getWidth()) - lineWidth, topLineIndent, lineWidth, (float)height - bottomLineIndent));
                }
            } else {
                int x = width;
                for (int i = 0; i < sepCount; ++i) {
                    g2.fill(new Rectangle2D.Float((float)(x -= columnModel.getColumn(i).getWidth()) - (i < sepCount - 1 ? lineWidth : 0.0f), topLineIndent, lineWidth, (float)height - bottomLineIndent));
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDraggedColumnBorders(Graphics g, JComponent c) {
        float lineWidth;
        TableColumn draggedColumn = this.header.getDraggedColumn();
        if (draggedColumn == null) {
            return;
        }
        TableColumnModel columnModel = this.header.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        int draggedColumnIndex = -1;
        for (int i = 0; i < columnCount; ++i) {
            if (columnModel.getColumn(i) != draggedColumn) continue;
            draggedColumnIndex = i;
            break;
        }
        if (draggedColumnIndex < 0) {
            return;
        }
        float topLineIndent = lineWidth = UIScale.scale(1.0f);
        float bottomLineIndent = lineWidth * 3.0f;
        Rectangle r = this.header.getHeaderRect(draggedColumnIndex);
        r.x += this.header.getDraggedDistance();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints(g2);
            g2.setColor(this.bottomSeparatorColor);
            g2.fill(new Rectangle2D.Float(r.x, (float)(r.y + r.height) - lineWidth, r.width, lineWidth));
            g2.setColor(this.separatorColor);
            g2.fill(new Rectangle2D.Float(r.x, topLineIndent, lineWidth, (float)r.height - bottomLineIndent));
            g2.fill(new Rectangle2D.Float((float)(r.x + r.width) - lineWidth, (float)r.y + topLineIndent, lineWidth, (float)r.height - bottomLineIndent));
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (size.height > 0) {
            size.height = Math.max(size.height, UIScale.scale(this.height));
        }
        return size;
    }

    private boolean isVerticalScrollBarVisible() {
        JScrollPane scrollPane = this.getScrollPane();
        return scrollPane != null && scrollPane.getVerticalScrollBar() != null ? scrollPane.getVerticalScrollBar().isVisible() : false;
    }

    private JScrollPane getScrollPane() {
        Container parent = this.header.getParent();
        if (parent == null) {
            return null;
        }
        return (parent = parent.getParent()) instanceof JScrollPane ? (JScrollPane)parent : null;
    }
}

