/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class FlatTextFieldUI
extends BasicTextFieldUI {
    protected int focusWidth;
    protected int minimumWidth;
    protected boolean isIntelliJTheme;
    protected Color placeholderForeground;
    private FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTextFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        this.focusWidth = UIManager.getInt("Component.focusWidth");
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.isIntelliJTheme = UIManager.getBoolean("Component.isIntelliJTheme");
        this.placeholderForeground = UIManager.getColor(prefix + ".placeholderForeground");
        LookAndFeel.installProperty(this.getComponent(), "opaque", this.focusWidth == 0);
        MigLayoutVisualPadding.install((JComponent)this.getComponent(), this.focusWidth);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.placeholderForeground = null;
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent());
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    @Override
    protected Caret createCaret() {
        return new FlatCaret(UIManager.getString("TextComponent.selectAllOnFocusPolicy"));
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("JTextField.placeholderText".equals(e.getPropertyName())) {
            this.getComponent().repaint();
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        FlatTextFieldUI.paintBackground(g, this.getComponent(), this.focusWidth, this.isIntelliJTheme);
        FlatTextFieldUI.paintPlaceholder(g, this.getComponent(), this.placeholderForeground);
        super.paintSafely(g);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintBackground(Graphics g, JTextComponent c, int focusWidth, boolean isIntelliJTheme) {
        if (!c.isOpaque() && !(c.getBorder() instanceof FlatBorder) && FlatUIUtils.hasOpaqueBeenExplicitlySet(c)) {
            return;
        }
        if (c.isOpaque() && focusWidth > 0) {
            FlatUIUtils.paintParentBackground(g, c);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints(g2);
            float fFocusWidth = c.getBorder() instanceof FlatBorder ? UIScale.scale((float)focusWidth) : 0.0f;
            Color background = c.getBackground();
            g2.setColor(!(background instanceof UIResource) ? background : (isIntelliJTheme && (!c.isEnabled() || !c.isEditable()) ? FlatUIUtils.getParentBackground(c) : background));
            FlatUIUtils.paintComponentBackground(g2, 0, 0, c.getWidth(), c.getHeight(), fFocusWidth, 0.0f);
        }
        finally {
            g2.dispose();
        }
    }

    static void paintPlaceholder(Graphics g, JTextComponent c, Color placeholderForeground) {
        if (c.getDocument().getLength() > 0) {
            return;
        }
        Container parent = c.getParent();
        JComponent jc = parent instanceof JComboBox ? (JComboBox)parent : c;
        Object placeholder = jc.getClientProperty("JTextField.placeholderText");
        if (!(placeholder instanceof String)) {
            return;
        }
        Insets insets = c.getInsets();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int x = insets.left;
        int y = insets.top + fm.getAscent() + (c.getHeight() - insets.top - insets.bottom - fm.getHeight()) / 2;
        g.setColor(placeholderForeground);
        FlatUIUtils.drawString(c, g, (String)placeholder, x, y);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.applyMinimumWidth(super.getPreferredSize(c), c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.applyMinimumWidth(super.getMinimumSize(c), c);
    }

    private Dimension applyMinimumWidth(Dimension size, JComponent c) {
        if (c instanceof JTextField && ((JTextField)c).getColumns() > 0) {
            return size;
        }
        Container parent = c.getParent();
        if (parent instanceof JComboBox || parent instanceof JSpinner || parent != null && parent.getParent() instanceof JSpinner) {
            return size;
        }
        int minimumWidth = FlatUIUtils.minimumWidth(this.getComponent(), this.minimumWidth);
        int focusWidth = c.getBorder() instanceof FlatBorder ? this.focusWidth : 0;
        size.width = Math.max(size.width, UIScale.scale(minimumWidth + focusWidth * 2));
        return size;
    }
}

