/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.admin.AdminFactoryHttp;
import org.netbeans.modules.payara.tooling.admin.AdminFactoryRest;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.data.PayaraAdminInterface;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.logging.Logger;

public abstract class AdminFactory {
    private static final Logger LOGGER = new Logger(AdminFactory.class);

    static AdminFactory getInstance(PayaraVersion version) throws CommandException {
        switch (version) {
            case PF_4_1_144: 
            case PF_4_1_151: 
            case PF_4_1_153: 
            case PF_4_1_1_154: 
            case PF_4_1_1_161: 
            case PF_4_1_1_162: 
            case PF_4_1_1_163: 
            case PF_4_1_1_171: 
            case PF_4_1_2_172: 
            case PF_4_1_2_173: 
            case PF_4_1_2_174: 
            case PF_4_1_2_181: 
            case PF_5_181: 
            case PF_5_182: 
            case PF_5_183: 
            case PF_5_184: 
            case PF_5_191: 
            case PF_5_192: 
            case PF_5_193: 
            case PF_5_194: 
            case PF_5_201: {
                return AdminFactoryRest.getInstance();
            }
        }
        throw new CommandException("Unknown Payara version");
    }

    public static AdminFactory getInstance(PayaraAdminInterface adminInterface) throws CommandException {
        switch (adminInterface) {
            case REST: {
                return AdminFactoryRest.getInstance();
            }
            case HTTP: {
                return AdminFactoryHttp.getInstance();
            }
        }
        throw new CommandException("Unknown Payara administration interface type");
    }

    public abstract Runner getRunner(PayaraServer var1, Command var2);

    Runner newRunner(PayaraServer srv, Command cmd, Class runnerClass) throws CommandException {
        String METHOD = "newRunner";
        Constructor con = null;
        Runner runner = null;
        try {
            con = runnerClass.getConstructor(PayaraServer.class, Command.class);
        }
        catch (NoSuchMethodException | SecurityException nsme) {
            throw new CommandException("Cannot initialize Runner class", nsme);
        }
        if (con == null) {
            return runner;
        }
        try {
            runner = (Runner)con.newInstance(srv, cmd);
        }
        catch (IllegalAccessException | InstantiationException ie) {
            throw new CommandException("Cannot initialize Runner class", ie);
        }
        catch (InvocationTargetException ite) {
            LOGGER.log(Level.WARNING, "exceptionMsg", ite.getMessage());
            Throwable t = ite.getCause();
            if (t != null) {
                LOGGER.log(Level.WARNING, "cause", t.getMessage());
            }
            throw new CommandException("Cannot initialize Runner class", ite);
        }
        return runner;
    }
}

