/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.output;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.terminal.api.IOConnect;
import org.openide.windows.InputOutput;

public class TerminalInputStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.getLogger(TerminalInputStream.class.getName());
    private final InputOutput io;
    private final Closeable[] close;

    public TerminalInputStream(InputOutput io, InputStream in, Closeable ... close) {
        super(in);
        this.io = io;
        this.close = close;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int i = super.read(b, off, len);
            if (i < 0) {
                this.closeTerminal();
            }
            return i;
        }
        catch (IOException ex) {
            this.closeTerminal();
            throw ex;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int i = super.read();
            if (i < 0) {
                this.closeTerminal();
            }
            return i;
        }
        catch (IOException ex) {
            this.closeTerminal();
            throw ex;
        }
    }

    private void closeTerminal() {
        for (Closeable c : this.close) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        if (IOConnect.isSupported((InputOutput)this.io)) {
            IOConnect.disconnectAll((InputOutput)this.io, null);
        }
    }
}

