/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterClassLoader;
import com.oracle.truffle.js.runtime.java.adapter.JavaAdapterServices;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

final class JavaAdapterBytecodeGenerator {
    private static final String INIT = "<init>";
    private static final String CLASS_INIT = "<clinit>";
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final String OBJECT_TYPE_NAME = OBJECT_TYPE.getInternalName();
    private static final Type POLYGLOT_VALUE_TYPE = Type.getType(Value.class);
    private static final String POLYGLOT_VALUE_TYPE_DESCRIPTOR = POLYGLOT_VALUE_TYPE.getDescriptor();
    private static final String LONG_TYPE_DESCRIPTOR = Type.LONG_TYPE.getDescriptor();
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type METHOD_TYPE_TYPE = Type.getType(MethodType.class);
    private static final Type METHOD_HANDLE_TYPE = Type.getType(MethodHandle.class);
    private static final String GET_HANDLE_NAME = "getHandle";
    private static final String GET_HANDLE_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_HANDLE_TYPE, (Type[])new Type[]{METHOD_TYPE_TYPE});
    private static final String GET_CALLEE_NAME = "getFunction";
    private static final String GET_CALLEE_DESCRIPTOR = Type.getMethodDescriptor((Type)POLYGLOT_VALUE_TYPE, (Type[])new Type[]{POLYGLOT_VALUE_TYPE, STRING_TYPE});
    private static final String GET_CLASS_OVERRIDES_METHOD_NAME = "getClassOverrides";
    private static final String GET_CLASS_OVERRIDES_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)POLYGLOT_VALUE_TYPE, (Type[])new Type[0]);
    private static final Type RUNTIME_EXCEPTION_TYPE = Type.getType(RuntimeException.class);
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    private static final Type UNSUPPORTED_OPERATION_TYPE = Type.getType(UnsupportedOperationException.class);
    private static final String UNSUPPORTED_METHOD_NAME = "unsupported";
    private static final String UNSUPPORTED_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)UNSUPPORTED_OPERATION_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String WRAP_THROWABLE_METHOD_NAME = "wrapThrowable";
    private static final String WRAP_THROWABLE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)RUNTIME_EXCEPTION_TYPE, (Type[])new Type[]{THROWABLE_TYPE});
    private static final String SERVICES_CLASS_TYPE_NAME = Type.getInternalName(JavaAdapterServices.class);
    private static final String RUNTIME_EXCEPTION_TYPE_NAME = RUNTIME_EXCEPTION_TYPE.getInternalName();
    private static final String ERROR_TYPE_NAME = Type.getInternalName(Error.class);
    private static final String THROWABLE_TYPE_NAME = THROWABLE_TYPE.getInternalName();
    private static final String METHOD_HANDLE_TYPE_DESCRIPTOR = METHOD_HANDLE_TYPE.getDescriptor();
    private static final String THREAD_CLASS_TYPE_NAME = Type.getInternalName(Thread.class);
    private static final String CURRENT_THREAD_NAME = "currentThread";
    private static final String CURRENT_THREAD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Thread.class), (Type[])new Type[0]);
    private static final String GET_ID_NAME = "getId";
    private static final String GET_ID_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]);
    private static final String ADAPTER_PACKAGE_PREFIX = "com/oracle/truffle/js/javaadapters/";
    private static final String ADAPTER_CLASS_NAME_SUFFIX = "$$JSJavaAdapter";
    private static final String JAVA_PACKAGE_PREFIX = "java/";
    private static final int MAX_GENERATED_TYPE_NAME_LENGTH = 255;
    private static final String OVERRIDES_FIELD_NAME = "overrides";
    private static final String THREAD_FIELD_NAME = "thread";
    static final String SUPER_PREFIX = "super$";
    private static final Collection<MethodInfo> EXCLUDED = JavaAdapterBytecodeGenerator.getExcludedMethods();
    private final Class<?> superClass;
    private final List<Class<?>> interfaces;
    private final ClassLoader commonLoader;
    private final boolean classOverride;
    private final String superClassName;
    private final String generatedClassName;
    private final Set<String> usedFieldNames = new HashSet<String>();
    private final Set<String> abstractMethodNames = new HashSet<String>();
    private final String samName;
    private final Set<MethodInfo> finalMethods = new HashSet<MethodInfo>(EXCLUDED);
    private final Set<MethodInfo> methodInfos = new HashSet<MethodInfo>();
    private final boolean autoConvertibleFromFunction;
    private final ClassWriter cw;
    private final boolean emitSameThreadCheck;
    private static final Class<? extends Annotation> CALLER_SENSITIVE_ANNOTATION_CLASS = JavaAdapterBytecodeGenerator.findCallerSensitiveAnnotationClass();

    JavaAdapterBytecodeGenerator(Class<?> superClass, List<Class<?>> interfaces, ClassLoader commonLoader, boolean classOverride) {
        assert (superClass != null && !superClass.isInterface());
        assert (interfaces != null);
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.classOverride = classOverride;
        this.commonLoader = commonLoader;
        this.cw = new ClassWriter(3){

            protected String getCommonSuperClass(String type1, String type2) {
                return JavaAdapterBytecodeGenerator.this.getCommonSuperClass(type1, type2);
            }
        };
        this.superClassName = Type.getInternalName(superClass);
        this.generatedClassName = JavaAdapterBytecodeGenerator.getGeneratedClassName(superClass, interfaces);
        this.cw.visit(52, 33, this.generatedClassName, null, this.superClassName, JavaAdapterBytecodeGenerator.getInternalTypeNames(interfaces));
        this.generateOverridesField();
        this.gatherMethods(superClass);
        this.gatherMethods(interfaces);
        this.samName = this.abstractMethodNames.size() == 1 ? this.abstractMethodNames.iterator().next() : null;
        this.emitSameThreadCheck = JSTruffleOptions.SingleThreaded;
        if (this.emitSameThreadCheck) {
            this.generateThreadField();
        }
        this.generateHandleFields();
        this.generateClassInit();
        this.autoConvertibleFromFunction = this.generateConstructors();
        this.generateMethods();
        this.generateSuperMethods();
        this.cw.visitEnd();
    }

    private void generateThreadField() {
        this.cw.visitField(26, THREAD_FIELD_NAME, LONG_TYPE_DESCRIPTOR, null, null).visitEnd();
        this.usedFieldNames.add(THREAD_FIELD_NAME);
    }

    private void generateOverridesField() {
        this.cw.visitField(0x12 | (this.classOverride ? 8 : 0), OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR, null, null).visitEnd();
        this.usedFieldNames.add(OVERRIDES_FIELD_NAME);
    }

    void loadOverridesField(InstructionAdapter mv) {
        if (this.classOverride) {
            mv.getstatic(this.generatedClassName, OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
        } else {
            mv.visitVarInsn(25, 0);
            mv.getfield(this.generatedClassName, OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
        }
    }

    JavaAdapterClassLoader createAdapterClassLoader() {
        return new JavaAdapterClassLoader(this.generatedClassName, this.cw.toByteArray());
    }

    boolean isAutoConvertibleFromFunction() {
        return this.autoConvertibleFromFunction;
    }

    private static String getGeneratedClassName(Class<?> superType, List<Class<?>> interfaces) {
        Class<?> namingType = superType == Object.class ? (interfaces.isEmpty() ? Object.class : interfaces.get(0)) : superType;
        Package pkg = namingType.getPackage();
        String namingTypeName = Type.getInternalName(namingType);
        StringBuilder buf = new StringBuilder();
        if (namingTypeName.startsWith(JAVA_PACKAGE_PREFIX) || pkg == null || pkg.isSealed()) {
            buf.append(ADAPTER_PACKAGE_PREFIX).append(namingTypeName);
        } else {
            buf.append(namingTypeName).append(ADAPTER_CLASS_NAME_SUFFIX);
        }
        Iterator<Class<?>> it = interfaces.iterator();
        if (superType == Object.class && it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            buf.append("$$").append(it.next().getSimpleName());
        }
        return buf.toString().substring(0, Math.min(255, buf.length()));
    }

    private static String[] getInternalTypeNames(List<Class<?>> classes) {
        int interfaceCount = classes.size();
        String[] interfaceNames = new String[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            interfaceNames[i] = Type.getInternalName(classes.get(i));
        }
        return interfaceNames;
    }

    private void generateHandleFields() {
        for (MethodInfo mi : this.methodInfos) {
            this.cw.visitField(26, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR, null, null).visitEnd();
            this.cw.visitField(0x12 | (this.classOverride ? 8 : 0), mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR, null, null).visitEnd();
        }
    }

    private void generateClassInit() {
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(8, CLASS_INIT, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null));
        if (this.classOverride) {
            Label initGlobal;
            mv.invokestatic(SERVICES_CLASS_TYPE_NAME, GET_CLASS_OVERRIDES_METHOD_NAME, GET_CLASS_OVERRIDES_METHOD_DESCRIPTOR, false);
            if (this.samName != null) {
                Label notAFunction = new Label();
                mv.dup();
                JavaAdapterBytecodeGenerator.emitIsFunction(mv);
                mv.ifeq(notAFunction);
                JavaAdapterBytecodeGenerator.castFunction(mv);
                for (MethodInfo mi : this.methodInfos) {
                    if (mi.getName().equals(this.samName)) {
                        mv.dup();
                    } else {
                        mv.visitInsn(1);
                    }
                    mv.putstatic(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
                }
                JavaAdapterBytecodeGenerator.loadUndefined(mv);
                mv.putstatic(this.generatedClassName, OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
                initGlobal = new Label();
                mv.goTo(initGlobal);
                mv.visitLabel(notAFunction);
            } else {
                initGlobal = null;
            }
            mv.dup();
            mv.putstatic(this.generatedClassName, OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
            for (MethodInfo mi : this.methodInfos) {
                mv.dup();
                mv.aconst((Object)mi.getName());
                mv.invokestatic(SERVICES_CLASS_TYPE_NAME, GET_CALLEE_NAME, GET_CALLEE_DESCRIPTOR, false);
                mv.putstatic(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
            }
            if (initGlobal != null) {
                mv.visitLabel(initGlobal);
            }
        }
        for (MethodInfo mi : this.methodInfos) {
            mv.aconst((Object)Type.getMethodType((String)mi.type.toMethodDescriptorString()));
            mv.invokestatic(SERVICES_CLASS_TYPE_NAME, GET_HANDLE_NAME, GET_HANDLE_DESCRIPTOR, false);
            mv.putstatic(this.generatedClassName, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR);
        }
        if (this.emitSameThreadCheck) {
            mv.invokestatic(THREAD_CLASS_TYPE_NAME, CURRENT_THREAD_NAME, CURRENT_THREAD_DESCRIPTOR, false);
            mv.invokevirtual(THREAD_CLASS_TYPE_NAME, GET_ID_NAME, GET_ID_DESCRIPTOR, false);
            mv.putstatic(this.generatedClassName, THREAD_FIELD_NAME, LONG_TYPE_DESCRIPTOR);
        }
        JavaAdapterBytecodeGenerator.endInitMethod(mv);
    }

    private static void loadUndefined(InstructionAdapter mv) {
        mv.visitInsn(1);
    }

    private static void emitIsFunction(InstructionAdapter mv) {
        mv.invokestatic(SERVICES_CLASS_TYPE_NAME, "isFunction", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{OBJECT_TYPE}), false);
    }

    private static void castFunction(InstructionAdapter mv) {
        mv.checkcast(POLYGLOT_VALUE_TYPE);
    }

    private boolean generateConstructors() {
        boolean gotCtor = false;
        boolean canBeAutoConverted = false;
        for (Constructor<?> ctor : this.superClass.getDeclaredConstructors()) {
            int modifier = ctor.getModifiers();
            if ((modifier & 5) == 0 || JavaAdapterBytecodeGenerator.isCallerSensitive(ctor)) continue;
            canBeAutoConverted |= this.generateConstructors(ctor);
            gotCtor = true;
        }
        if (!gotCtor) {
            this.throwNoAccessibleConstructorError();
        }
        return canBeAutoConverted;
    }

    @CompilerDirectives.TruffleBoundary
    private void throwNoAccessibleConstructorError() {
        throw new RuntimeException("No accessible constructor: " + this.superClass.getCanonicalName());
    }

    private boolean generateConstructors(Constructor<?> ctor) {
        if (this.classOverride) {
            this.generateDelegatingConstructor(ctor);
            return false;
        }
        boolean fromFunction = this.samName != null;
        this.generateOverridingConstructor(ctor, fromFunction);
        if (!fromFunction) {
            return false;
        }
        return ctor.getParameterCount() == 0;
    }

    private void generateDelegatingConstructor(Constructor<?> ctor) {
        Type originalCtorType = Type.getType(ctor);
        Type[] argTypes = originalCtorType.getArgumentTypes();
        String methodDescriptor = Type.getMethodDescriptor((Type)originalCtorType.getReturnType(), (Type[])argTypes);
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(1 | (ctor.isVarArgs() ? 128 : 0), INIT, methodDescriptor, null, null));
        mv.visitCode();
        this.emitSuperConstructorCall(mv, originalCtorType.getDescriptor());
        JavaAdapterBytecodeGenerator.endInitMethod(mv);
    }

    private void generateOverridingConstructor(Constructor<?> ctor, boolean fromFunction) {
        Type extraArgumentType;
        assert (!this.classOverride);
        Type originalCtorType = Type.getType(ctor);
        Type[] originalArgTypes = originalCtorType.getArgumentTypes();
        int argLen = originalArgTypes.length;
        Type[] newArgTypes = new Type[argLen + 1];
        newArgTypes[argLen] = extraArgumentType = POLYGLOT_VALUE_TYPE;
        System.arraycopy(originalArgTypes, 0, newArgTypes, 0, argLen);
        String signature = Type.getMethodDescriptor((Type)originalCtorType.getReturnType(), (Type[])newArgTypes);
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(1, INIT, signature, null, null));
        mv.visitCode();
        int offset = this.emitSuperConstructorCall(mv, originalCtorType.getDescriptor());
        if (fromFunction) {
            Label notAFunction = new Label();
            Label end = new Label();
            mv.visitVarInsn(25, offset);
            JavaAdapterBytecodeGenerator.emitIsFunction(mv);
            mv.ifeq(notAFunction);
            this.generateOverridingConstructorPart(true, mv, offset);
            mv.goTo(end);
            mv.visitLabel(notAFunction);
            this.generateOverridingConstructorPart(false, mv, offset);
            mv.visitLabel(end);
        } else {
            this.generateOverridingConstructorPart(false, mv, offset);
        }
        JavaAdapterBytecodeGenerator.endInitMethod(mv);
    }

    private void generateOverridingConstructorPart(boolean fromFunction, InstructionAdapter mv, int offset) {
        for (MethodInfo mi : this.methodInfos) {
            mv.visitVarInsn(25, 0);
            if (fromFunction) {
                if (mi.getName().equals(this.samName)) {
                    mv.visitVarInsn(25, offset);
                    mv.putfield(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
                    continue;
                }
                mv.visitInsn(1);
                mv.putfield(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
                continue;
            }
            mv.visitVarInsn(25, offset);
            mv.aconst((Object)mi.getName());
            mv.invokestatic(SERVICES_CLASS_TYPE_NAME, GET_CALLEE_NAME, GET_CALLEE_DESCRIPTOR, false);
            mv.putfield(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
        }
        if (fromFunction) {
            mv.visitVarInsn(25, 0);
            JavaAdapterBytecodeGenerator.loadUndefined(mv);
            mv.putfield(this.generatedClassName, OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, offset);
            mv.putfield(this.generatedClassName, OVERRIDES_FIELD_NAME, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
        }
    }

    private static void endInitMethod(InstructionAdapter mv) {
        mv.visitInsn(177);
        JavaAdapterBytecodeGenerator.endMethod(mv);
    }

    private static void endMethod(InstructionAdapter mv) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateMethods() {
        for (MethodInfo mi : this.methodInfos) {
            this.generateMethod(mi);
        }
    }

    private void generateMethod(MethodInfo mi) {
        Label throwableHandler;
        Method method = mi.method;
        Class<?>[] exceptions = method.getExceptionTypes();
        String[] exceptionNames = JavaAdapterBytecodeGenerator.getExceptionNames(exceptions);
        MethodType type = mi.type;
        String methodDesc = type.toMethodDescriptorString();
        String name = mi.getName();
        Type asmType = Type.getMethodType((String)methodDesc);
        Type[] asmArgTypes = asmType.getArgumentTypes();
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(JavaAdapterBytecodeGenerator.getAccessModifiers(method), name, methodDesc, null, exceptionNames));
        mv.visitCode();
        Label hasFunction = new Label();
        Type asmReturnType = Type.getType((Class)type.returnType());
        mv.getstatic(this.generatedClassName, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR);
        if (this.classOverride) {
            mv.getstatic(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
            JavaAdapterBytecodeGenerator.jumpIfNonNullKeepOperand(mv, hasFunction);
        } else {
            mv.visitVarInsn(25, 0);
            mv.getfield(this.generatedClassName, mi.calleeFieldName, POLYGLOT_VALUE_TYPE_DESCRIPTOR);
            JavaAdapterBytecodeGenerator.jumpIfNonNullKeepOperand(mv, hasFunction);
        }
        mv.pop();
        if (Modifier.isAbstract(method.getModifiers())) {
            mv.visitLdcInsn((Object)name);
            mv.invokestatic(SERVICES_CLASS_TYPE_NAME, UNSUPPORTED_METHOD_NAME, UNSUPPORTED_METHOD_DESCRIPTOR, false);
            mv.athrow();
        } else {
            this.emitSuperCall(mv, method.getDeclaringClass(), name, methodDesc);
            mv.areturn(Type.getMethodType((String)methodDesc).getReturnType());
        }
        mv.visitLabel(hasFunction);
        int varOffset = 1;
        for (Type t : asmArgTypes) {
            mv.load(varOffset, t);
            varOffset += t.getSize();
        }
        Label tryBlockStart = new Label();
        mv.visitLabel(tryBlockStart);
        mv.invokevirtual(METHOD_HANDLE_TYPE.getInternalName(), "invokeExact", type.insertParameterTypes(0, Value.class).toMethodDescriptorString(), false);
        Label tryBlockEnd = new Label();
        mv.visitLabel(tryBlockEnd);
        mv.areturn(asmReturnType);
        Label rethrowHandler = new Label();
        mv.visitLabel(rethrowHandler);
        mv.athrow();
        boolean throwableDeclared = JavaAdapterBytecodeGenerator.isThrowableDeclared(exceptions);
        if (!throwableDeclared) {
            throwableHandler = new Label();
            mv.visitLabel(throwableHandler);
            JavaAdapterBytecodeGenerator.wrapThrowable(mv);
            mv.athrow();
        } else {
            throwableHandler = null;
        }
        if (throwableDeclared) {
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, THROWABLE_TYPE_NAME);
            assert (throwableHandler == null);
        } else {
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, RUNTIME_EXCEPTION_TYPE_NAME);
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, ERROR_TYPE_NAME);
            for (String excName : exceptionNames) {
                mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, excName);
            }
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, throwableHandler, THROWABLE_TYPE_NAME);
        }
        JavaAdapterBytecodeGenerator.endMethod(mv);
    }

    private static void wrapThrowable(InstructionAdapter mv) {
        mv.invokestatic(SERVICES_CLASS_TYPE_NAME, WRAP_THROWABLE_METHOD_NAME, WRAP_THROWABLE_METHOD_DESCRIPTOR, false);
    }

    private static void jumpIfNonNullKeepOperand(InstructionAdapter mv, Label label) {
        mv.visitInsn(89);
        mv.visitJumpInsn(199, label);
        mv.visitInsn(87);
    }

    private static boolean isThrowableDeclared(Class<?>[] exceptions) {
        for (Class<?> exception : exceptions) {
            if (exception != Throwable.class) continue;
            return true;
        }
        return false;
    }

    private void generateSuperMethods() {
        for (MethodInfo mi : this.methodInfos) {
            if (Modifier.isAbstract(mi.method.getModifiers())) continue;
            this.generateSuperMethod(mi);
        }
    }

    private void generateSuperMethod(MethodInfo mi) {
        Method method = mi.method;
        String methodDesc = mi.type.toMethodDescriptorString();
        String name = mi.getName();
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(JavaAdapterBytecodeGenerator.getAccessModifiers(method), SUPER_PREFIX + name, methodDesc, null, JavaAdapterBytecodeGenerator.getExceptionNames(method.getExceptionTypes())));
        mv.visitCode();
        this.emitSuperCall(mv, method.getDeclaringClass(), name, methodDesc);
        mv.areturn(Type.getMethodType((String)methodDesc).getReturnType());
        JavaAdapterBytecodeGenerator.endMethod(mv);
    }

    private Class<?> findInvokespecialOwnerFor(Class<?> owner) {
        assert (Modifier.isInterface(owner.getModifiers())) : owner + " is not an interface";
        if (owner.isAssignableFrom(this.superClass)) {
            return this.superClass;
        }
        for (Class<?> iface : this.interfaces) {
            if (!owner.isAssignableFrom(iface)) continue;
            return iface;
        }
        throw new AssertionError((Object)("Cannot find the class/interface that extends " + owner));
    }

    private int emitSuperConstructorCall(InstructionAdapter mv, String methodDesc) {
        return this.emitSuperCall(mv, null, INIT, methodDesc, true);
    }

    private int emitSuperCall(InstructionAdapter mv, Class<?> owner, String name, String methodDesc) {
        return this.emitSuperCall(mv, owner, name, methodDesc, false);
    }

    private int emitSuperCall(InstructionAdapter mv, Class<?> owner, String name, String methodDesc, boolean constructor) {
        mv.visitVarInsn(25, 0);
        int nextParam = 1;
        Type methodType = Type.getMethodType((String)methodDesc);
        for (Type t : methodType.getArgumentTypes()) {
            mv.load(nextParam, t);
            nextParam += t.getSize();
        }
        if (!constructor && Modifier.isInterface(owner.getModifiers())) {
            Class<?> superType = this.findInvokespecialOwnerFor(owner);
            mv.invokespecial(Type.getInternalName(superType), name, methodDesc, Modifier.isInterface(superType.getModifiers()));
        } else {
            mv.invokespecial(this.superClassName, name, methodDesc, false);
        }
        return nextParam;
    }

    private static String[] getExceptionNames(Class<?>[] exceptions) {
        String[] exceptionNames = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptionNames[i] = Type.getInternalName(exceptions[i]);
        }
        return exceptionNames;
    }

    private static int getAccessModifiers(Method method) {
        return 1 | (method.isVarArgs() ? 128 : 0);
    }

    private void gatherMethods(Class<?> type) {
        if (Modifier.isPublic(type.getModifiers())) {
            Method[] typeMethods = type.isInterface() ? type.getMethods() : type.getDeclaredMethods();
            for (GenericDeclaration genericDeclaration : typeMethods) {
                int m;
                String name = ((Method)genericDeclaration).getName();
                if (name.startsWith(SUPER_PREFIX) || Modifier.isStatic(m = ((Method)genericDeclaration).getModifiers()) || !Modifier.isPublic(m) && !Modifier.isProtected(m)) continue;
                MethodInfo mi = new MethodInfo((Method)genericDeclaration);
                if (Modifier.isFinal(m) || JavaAdapterBytecodeGenerator.isCallerSensitive((Executable)genericDeclaration)) {
                    this.finalMethods.add(mi);
                    continue;
                }
                if (this.finalMethods.contains(mi) || !this.methodInfos.add(mi)) continue;
                if (Modifier.isAbstract(m)) {
                    this.abstractMethodNames.add(mi.getName());
                }
                mi.setIsCanonical(this.usedFieldNames);
            }
        }
        if (!type.isInterface()) {
            Class<?> superType = type.getSuperclass();
            if (superType != null) {
                this.gatherMethods(superType);
            }
            for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                this.gatherMethods((Class<?>)genericDeclaration);
            }
        }
    }

    private void gatherMethods(List<Class<?>> classes) {
        for (Class<?> c : classes) {
            this.gatherMethods(c);
        }
    }

    private static Collection<MethodInfo> getExcludedMethods() {
        try {
            return Arrays.asList(new MethodInfo((Class)Object.class, "finalize", new Class[0]), new MethodInfo((Class)Object.class, "clone", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getCommonSuperClass(String type1, String type2) {
        try {
            Class<?> c1 = Class.forName(type1.replace('/', '.'), false, this.commonLoader);
            Class<?> c2 = Class.forName(type2.replace('/', '.'), false, this.commonLoader);
            if (c1.isAssignableFrom(c2)) {
                return type1;
            }
            if (c2.isAssignableFrom(c1)) {
                return type2;
            }
            if (c1.isInterface() || c2.isInterface()) {
                return OBJECT_TYPE_NAME;
            }
            return JavaAdapterBytecodeGenerator.assignableSuperClass(c1, c2).getName().replace('.', '/');
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> assignableSuperClass(Class<?> c1, Class<?> c2) {
        Class<?> superClass = c1.getSuperclass();
        return superClass.isAssignableFrom(c2) ? superClass : JavaAdapterBytecodeGenerator.assignableSuperClass(superClass, c2);
    }

    private static boolean isCallerSensitive(Executable e) {
        return CALLER_SENSITIVE_ANNOTATION_CLASS != null && e.isAnnotationPresent(CALLER_SENSITIVE_ANNOTATION_CLASS);
    }

    private static Class<? extends Annotation> findCallerSensitiveAnnotationClass() {
        try {
            return Class.forName("sun.reflect.CallerSensitive").asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName("jdk.internal.reflect.CallerSensitive").asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    private static final class MethodInfo {
        private final Method method;
        private final MethodType type;
        private String methodHandleFieldName;
        private String calleeFieldName;

        private MethodInfo(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodException {
            this(clazz.getDeclaredMethod(name, argTypes));
        }

        private MethodInfo(Method method) {
            this.method = method;
            this.type = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        }

        public boolean equals(Object obj) {
            return obj instanceof MethodInfo && this.equals((MethodInfo)obj);
        }

        private boolean equals(MethodInfo other) {
            return this.getName().equals(other.getName()) && this.type.equals((Object)other.type);
        }

        String getName() {
            return this.method.getName();
        }

        public int hashCode() {
            return this.getName().hashCode() ^ this.type.hashCode();
        }

        void setIsCanonical(Set<String> usedFieldNames) {
            this.methodHandleFieldName = this.nextName(usedFieldNames);
            this.calleeFieldName = this.nextName(usedFieldNames);
        }

        String nextName(Set<String> usedFieldNames) {
            String name;
            int i = 0;
            String nextName = name = this.getName();
            while (!usedFieldNames.add(nextName)) {
                String ordinal = String.valueOf(i++);
                int maxNameLen = 255 - ordinal.length();
                nextName = (name.length() <= maxNameLen ? name : name.substring(0, maxNameLen)).concat(ordinal);
            }
            return nextName;
        }
    }
}

