/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.util.DebugCounter;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class JSShapeData {
    private static final Property[] EMPTY_PROPERTY_ARRAY = new Property[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Property[] propertyArray;
    private String[] enumerablePropertyNames;
    private static final DebugCounter enumerablePropertyListAllocCount = DebugCounter.create("Enumerable property lists allocated");
    private static final DebugCounter propertyListAllocCount = DebugCounter.create("Property lists allocated");

    private JSShapeData() {
    }

    private static Property[] createPropertiesArray(Shape shape) {
        CompilerAsserts.neverPartOfCompilation();
        propertyListAllocCount.inc();
        List ownProperties = shape.getPropertyList();
        JSShapeData.sortProperties(ownProperties);
        return ownProperties.toArray(EMPTY_PROPERTY_ARRAY);
    }

    private static String[] createEnumerablePropertyNamesArray(Shape shape) {
        CompilerAsserts.neverPartOfCompilation();
        enumerablePropertyListAllocCount.inc();
        ArrayList ownProperties = new ArrayList();
        shape.getPropertyList().forEach(property -> {
            if (JSProperty.isEnumerable(property) && property.getKey() instanceof String) {
                ownProperties.add((String)property.getKey());
            }
        });
        JSShapeData.sortPropertyKeys(ownProperties);
        return ownProperties.toArray(EMPTY_STRING_ARRAY);
    }

    private static void sortProperties(List<Property> ownProperties) {
        CompilerAsserts.neverPartOfCompilation();
        Collections.sort(ownProperties, (o1, o2) -> JSRuntime.comparePropertyKeys(o1.getKey(), o2.getKey()));
    }

    private static void sortPropertyKeys(List<? extends Object> ownProperties) {
        CompilerAsserts.neverPartOfCompilation();
        Collections.sort(ownProperties, JSRuntime::comparePropertyKeys);
    }

    private static JSShapeData getShapeData(Shape shape) {
        CompilerAsserts.neverPartOfCompilation();
        JSContext context = JSShape.getJSContext(shape);
        Map<Shape, JSShapeData> map = context.getShapeDataMap();
        return map.computeIfAbsent(shape, s -> new JSShapeData());
    }

    @CompilerDirectives.TruffleBoundary
    private static Property[] getPropertiesArray(Shape shape) {
        if (shape.getPropertyCount() == 0) {
            return EMPTY_PROPERTY_ARRAY;
        }
        JSShapeData shapeData = JSShapeData.getShapeData(shape);
        if (shapeData.propertyArray == null) {
            assert (shape.getPropertyCount() != 0);
            shapeData.propertyArray = JSShapeData.createPropertiesArray(shape);
            assert (shapeData.propertyArray.length == shape.getPropertyCount());
        }
        return shapeData.propertyArray;
    }

    static UnmodifiableArrayList<Property> getProperties(Shape shape) {
        return JSShapeData.asUnmodifiableList(JSShapeData.getPropertiesArray(shape));
    }

    @CompilerDirectives.TruffleBoundary
    private static String[] getEnumerablePropertyNamesArray(Shape shape) {
        if (shape.getPropertyCount() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        JSShapeData shapeData = JSShapeData.getShapeData(shape);
        if (shapeData.enumerablePropertyNames == null) {
            assert (shape.getPropertyCount() != 0);
            shapeData.enumerablePropertyNames = JSShapeData.createEnumerablePropertyNamesArray(shape);
        }
        return shapeData.enumerablePropertyNames;
    }

    static UnmodifiableArrayList<String> getEnumerablePropertyNames(Shape shape) {
        return JSShapeData.asUnmodifiableList(JSShapeData.getEnumerablePropertyNamesArray(shape));
    }

    private static <T> UnmodifiableArrayList<T> asUnmodifiableList(T[] array) {
        return new UnmodifiableArrayList<T>(array);
    }
}

