/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.ui.wizard.NewTemplatePanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class BasicInfoWizardPanel
extends NewTemplatePanel
implements WizardDescriptor.ValidatingPanel<WizardDescriptor> {
    private BasicInfoVisualPanel visualPanel;

    public BasicInfoWizardPanel(NewModuleProjectData data) {
        super(data);
    }

    @Override
    public void reloadData() {
        this.getVisualPanel().refreshData();
    }

    @Override
    public void storeData() {
        this.getVisualPanel().storeData();
    }

    private BasicInfoVisualPanel getVisualPanel() {
        return (BasicInfoVisualPanel)((Object)this.getComponent());
    }

    public Component getComponent() {
        if (this.visualPanel == null) {
            this.visualPanel = new BasicInfoVisualPanel(this.getData());
            this.visualPanel.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)((Object)this), (Object)this.visualPanel));
            this.visualPanel.setName(NbBundle.getMessage(BasicInfoWizardPanel.class, (String)"LBL_BasicInfoPanel_Title"));
            this.visualPanel.updateAndCheck();
        }
        return this.visualPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(BasicInfoWizardPanel.class.getName() + "_" + this.getWizardTypeString());
    }

    public void validate() throws WizardValidationException {
        String prjFolder = this.getData().getProjectFolder();
        if (prjFolder != null) {
            String forbiddenChars;
            String pattern;
            File prjFolderF = new File(prjFolder);
            String name = this.getData().getProjectName();
            if (Utilities.isWindows()) {
                pattern = ".*[\\/:*?\"<>|].*";
                forbiddenChars = "\\ / : * ? \" < > |";
            } else {
                pattern = ".*[\\/].*";
                forbiddenChars = "\\ /";
            }
            if (Pattern.matches(pattern, name)) {
                String message = NbBundle.getMessage(BasicInfoWizardPanel.class, (String)"MSG_ProjectFolderInvalidCharacters");
                message = String.format(message, forbiddenChars);
                throw new WizardValidationException((JComponent)this.getVisualPanel().nameValue, message, message);
            }
            if (prjFolderF.mkdir()) {
                prjFolderF.delete();
            } else {
                String message = NbBundle.getMessage(BasicInfoWizardPanel.class, (String)"MSG_UnableToCreateProjectFolder");
                throw new WizardValidationException((JComponent)this.getVisualPanel().nameValue, message, message);
            }
        }
    }
}

