/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.annotations.validators.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.annotation.util.AnnotationUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class ParameterizedAnnotationLineParser
implements AnnotationLineParser {
    private static final Set<String> ANNOTATIONS = new HashSet<String>();

    public AnnotationParsedLine parse(String line) {
        AnnotationParsedLine.ParsedLine result = null;
        String[] tokens = line.split(line.contains("(") ? "\\(" : "[ \t]+");
        for (String annotationName : ANNOTATIONS) {
            if (tokens.length <= 0 || !AnnotationUtils.isTypeAnnotation((String)tokens[0], (String)annotationName)) continue;
            String annotation = tokens[0].trim();
            String description = line.substring(annotation.length()).trim();
            HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
            types.put(new OffsetRange(0, annotation.length()), annotation);
            result = new AnnotationParsedLine.ParsedLine(annotationName, types, description, true);
            break;
        }
        return result;
    }

    static {
        ANNOTATIONS.add("NotBlank");
        ANNOTATIONS.add("Blank");
        ANNOTATIONS.add("NotNull");
        ANNOTATIONS.add("Null");
        ANNOTATIONS.add("True");
        ANNOTATIONS.add("False");
        ANNOTATIONS.add("Email");
        ANNOTATIONS.add("MinLength");
        ANNOTATIONS.add("MaxLength");
        ANNOTATIONS.add("Url");
        ANNOTATIONS.add("Regex");
        ANNOTATIONS.add("Ip");
        ANNOTATIONS.add("Max");
        ANNOTATIONS.add("Min");
        ANNOTATIONS.add("Date");
        ANNOTATIONS.add("DateTime");
        ANNOTATIONS.add("Time");
        ANNOTATIONS.add("Choice");
        ANNOTATIONS.add("UniqueEntity");
        ANNOTATIONS.add("Language");
        ANNOTATIONS.add("Locale");
        ANNOTATIONS.add("Country");
        ANNOTATIONS.add("File");
        ANNOTATIONS.add("Image");
        ANNOTATIONS.add("Callback");
        ANNOTATIONS.add("Valid");
    }
}

