/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class UnitTestsCompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation {
    private static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    private final AtomicReference<ResultImpl> result;
    private final NbMavenProjectImpl proj;

    public UnitTestsCompilerOptionsQueryImpl(NbMavenProjectImpl proj) {
        Parameters.notNull((CharSequence)"proj", (Object)proj);
        this.proj = proj;
        this.result = new AtomicReference();
    }

    @CheckForNull
    public CompilerOptionsQueryImplementation.Result getOptions(@NonNull FileObject file) {
        for (String r : this.proj.getOriginalMavenProject().getTestCompileSourceRoots()) {
            FileObject root = FileUtil.toFileObject((File)new File(r));
            if (root == null || !UnitTestsCompilerOptionsQueryImpl.isArtifact(root, file)) continue;
            ResultImpl res = this.result.get();
            if (res == null) {
                res = new ResultImpl(this.proj);
                if (!this.result.compareAndSet(null, res)) {
                    res = this.result.get();
                }
                assert (res != null);
            }
            return res;
        }
        return null;
    }

    private static boolean isArtifact(@NonNull FileObject root, @NonNull FileObject file) {
        return root.equals(file) || FileUtil.isParentOf((FileObject)root, (FileObject)file);
    }

    private static final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result
    implements ChangeListener,
    PropertyChangeListener,
    FileChangeListener {
        private final ChangeSupport cs;
        private final ThreadLocal<Boolean> reenter;
        private final Collection<File> moduleInfoListeners;
        private List<String> cache;
        private SourceLevelQuery.Result sourceLevel;
        private boolean listensOnRoots;
        private final NbMavenProjectImpl proj;

        ResultImpl(NbMavenProjectImpl proj) {
            this.proj = proj;
            this.cs = new ChangeSupport((Object)this);
            this.reenter = new ThreadLocal();
            this.moduleInfoListeners = new HashSet<File>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends String> getArguments() {
            List<String> args;
            SourceLevelQuery.Result[] slq = new SourceLevelQuery.Result[1];
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                args = this.cache;
                slq[0] = this.sourceLevel;
            }
            if (args == null) {
                if (this.reenter.get() == Boolean.TRUE) {
                    args = Collections.emptyList();
                } else {
                    this.reenter.set(Boolean.TRUE);
                    try {
                        HashSet allRoots = new HashSet();
                        FileObject srcModuleInfo = this.findModuleInfo(this.proj.getOriginalMavenProject().getCompileSourceRoots(), allRoots, null);
                        FileObject testModuleInfo = this.findModuleInfo(this.proj.getOriginalMavenProject().getTestCompileSourceRoots(), allRoots, slq);
                        boolean isLegacy = Optional.ofNullable(slq[0]).map(r -> r.getSourceLevel()).map(sl -> JDK9.compareTo((Object)new SpecificationVersion(sl)) > 0).orElse(Boolean.TRUE);
                        TestMode mode = isLegacy ? TestMode.LEGACY : (srcModuleInfo == null ? TestMode.UNNAMED : (testModuleInfo == null ? TestMode.INLINED : TestMode.MODULE));
                        args = mode.createArguments(this.proj, srcModuleInfo, testModuleInfo);
                        ResultImpl resultImpl2 = this;
                        synchronized (resultImpl2) {
                            if (this.cache == null) {
                                this.cache = args;
                            } else {
                                args = this.cache;
                            }
                            if (this.sourceLevel == null && slq[0] != null) {
                                this.sourceLevel = slq[0];
                                if (this.sourceLevel.supportsChanges()) {
                                    this.sourceLevel.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sourceLevel));
                                }
                            }
                            if (!this.listensOnRoots) {
                                this.listensOnRoots = true;
                                NbMavenProject watcher = (NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class);
                                watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)watcher));
                            }
                            HashSet<File> toRemove = new HashSet<File>(this.moduleInfoListeners);
                            toRemove.removeAll(allRoots);
                            allRoots.removeAll(this.moduleInfoListeners);
                            for (File f : toRemove) {
                                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)new File(f, "module-info.java"));
                                this.moduleInfoListeners.remove(f);
                            }
                            for (File f : allRoots) {
                                FileUtil.addFileChangeListener((FileChangeListener)this, (File)new File(f, "module-info.java"));
                                this.moduleInfoListeners.add(f);
                            }
                        }
                    }
                    finally {
                        this.reenter.remove();
                    }
                }
            }
            return args;
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(@NonNull ChangeEvent e) {
            this.reset();
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.reset();
            }
        }

        public void fileDataCreated(FileEvent fe) {
            this.reset();
        }

        public void fileChanged(FileEvent fe) {
            this.reset();
        }

        public void fileDeleted(FileEvent fe) {
            this.reset();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.reset();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                this.cache = null;
            }
            this.cs.fireChange();
        }

        private FileObject findModuleInfo(List<String> roots, @NonNull Collection<? super File> rootCollector, @NullAllowed SourceLevelQuery.Result[] holder) {
            FileObject result = null;
            for (String rootPath : roots) {
                FileObject moduleInfo;
                File rootFile = new File(rootPath);
                FileObject rootFileObject = FileUtil.toFileObject((File)rootFile);
                if (!rootFile.exists() || rootFileObject == null) continue;
                if (holder != null && holder[0] == null) {
                    holder[0] = SourceLevelQuery.getSourceLevel2((FileObject)rootFileObject);
                }
                rootCollector.add(rootFile);
                if (result != null || (moduleInfo = rootFileObject.getFileObject("module-info.java")) == null) continue;
                result = moduleInfo;
            }
            return result;
        }

        @CheckForNull
        private static String getModuleName(@NonNull FileObject moduleInfo) {
            return SourceUtils.parseModuleName((FileObject)moduleInfo);
        }

        private static enum TestMode {
            LEGACY{

                @Override
                List<String> createArguments(NbMavenProjectImpl project, @NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    return Collections.emptyList();
                }
            }
            ,
            UNNAMED{

                @Override
                List<String> createArguments(NbMavenProjectImpl project, @NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    return Collections.emptyList();
                }
            }
            ,
            INLINED{

                @Override
                List<String> createArguments(NbMavenProjectImpl project, @NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    String moduleName = ResultImpl.getModuleName(srcModuleInfo);
                    if (moduleName == null) {
                        return Collections.emptyList();
                    }
                    List<String> result = Arrays.asList(String.format("-XD-Xmodule:%s", moduleName), "--add-reads", String.format("%s=ALL-UNNAMED", moduleName));
                    return Collections.unmodifiableList(result);
                }
            }
            ,
            MODULE{

                @Override
                List<String> createArguments(NbMavenProjectImpl project, @NullAllowed FileObject srcModuleInfo, @NullAllowed FileObject testModuleInfo) {
                    String testModuleName = ResultImpl.getModuleName(testModuleInfo);
                    if (testModuleName == null) {
                        return Collections.emptyList();
                    }
                    String srcModuleName = ResultImpl.getModuleName(srcModuleInfo);
                    if (srcModuleName == null) {
                        return Collections.emptyList();
                    }
                    if (testModuleName != null && srcModuleName != null && testModuleName.equals(srcModuleName)) {
                        String paths = Stream.concat(Arrays.stream(project.getSourceRoots(false)), Arrays.stream(project.getGeneratedSourceRoots(false))).filter(u -> "file".equals(u.getScheme())).map(u -> u.getPath()).collect(Collectors.joining(System.getProperty("path.separator")));
                        return Collections.unmodifiableList(Arrays.asList("--patch-module", srcModuleName + "=" + paths));
                    }
                    List<String> result = Arrays.asList("--add-reads", String.format("%s=ALL-UNNAMED", testModuleName));
                    return Collections.unmodifiableList(result);
                }
            };


            @NonNull
            abstract List<String> createArguments(NbMavenProjectImpl var1, @NullAllowed FileObject var2, @NullAllowed FileObject var3);
        }
    }
}

