/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBuildPipelineRequest
extends BmcRequest<Void> {
    private String buildPipelineId;
    private String opcRequestId;

    @ConstructorProperties(value={"buildPipelineId", "opcRequestId"})
    GetBuildPipelineRequest(String buildPipelineId, String opcRequestId) {
        this.buildPipelineId = buildPipelineId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().buildPipelineId(this.buildPipelineId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetBuildPipelineRequest(super=" + super.toString() + ", buildPipelineId=" + this.getBuildPipelineId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetBuildPipelineRequest)) {
            return false;
        }
        GetBuildPipelineRequest other = (GetBuildPipelineRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$buildPipelineId = this.getBuildPipelineId();
        String other$buildPipelineId = other.getBuildPipelineId();
        if (this$buildPipelineId == null ? other$buildPipelineId != null : !this$buildPipelineId.equals(other$buildPipelineId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetBuildPipelineRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $buildPipelineId = this.getBuildPipelineId();
        result = result * 59 + ($buildPipelineId == null ? 43 : $buildPipelineId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getBuildPipelineId() {
        return this.buildPipelineId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBuildPipelineRequest, Void> {
        private String buildPipelineId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBuildPipelineRequest o) {
            this.buildPipelineId(o.getBuildPipelineId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBuildPipelineRequest build() {
            GetBuildPipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder buildPipelineId(String buildPipelineId) {
            this.buildPipelineId = buildPipelineId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBuildPipelineRequest buildWithoutInvocationCallback() {
            return new GetBuildPipelineRequest(this.buildPipelineId, this.opcRequestId);
        }

        public String toString() {
            return "GetBuildPipelineRequest.Builder(buildPipelineId=" + this.buildPipelineId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

