/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.nio.ByteBuffer;

public final class ArrayBufferPrototypeBuiltins
extends JSBuiltinsContainer.Lambda {
    public static final JSBuiltinsContainer BUILTINS = new ArrayBufferPrototypeBuiltins();

    protected ArrayBufferPrototypeBuiltins() {
        super("ArrayBuffer.prototype");
        this.defineFunction("slice", 2, (context, builtin) -> ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferSliceNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context)));
    }

    public static abstract class JSArrayBufferSliceNode
    extends JSArrayBufferAbstractSliceNode {
        private final BranchProfile errorBranch = BranchProfile.create();

        public JSArrayBufferSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSHeapArrayBuffer(thisObj)"})
        protected DynamicObject slice(DynamicObject thisObj, int begin, int end) {
            byte[] byteArray = JSArrayBuffer.getByteArray(thisObj);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, byteArray.length);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, byteArray.length);
            int newLen = Math.max(clampedEnd - clampedBegin, 0);
            DynamicObject resObj = this.constructNewArrayBuffer(thisObj, newLen);
            this.checkErrors(resObj, thisObj, newLen, false);
            byte[] newByteArray = JSArrayBuffer.getByteArray(resObj);
            System.arraycopy(byteArray, clampedBegin, newByteArray, 0, newLen);
            return resObj;
        }

        private DynamicObject constructNewArrayBuffer(DynamicObject thisObj, int newLen) {
            DynamicObject defaultConstructor = this.getContext().getRealm().getArrayBufferConstructor();
            DynamicObject constr = this.getArraySpeciesConstructorNode().speciesConstructor(thisObj, defaultConstructor);
            return (DynamicObject)this.getArraySpeciesConstructorNode().construct(constr, newLen);
        }

        private void checkErrors(DynamicObject resObj, DynamicObject thisObj, int newLen, boolean direct) {
            if (direct && !JSArrayBuffer.isJSDirectArrayBuffer(resObj) || !direct && !JSArrayBuffer.isJSHeapArrayBuffer(resObj)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferExpected();
            }
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(resObj)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            if (resObj == thisObj) {
                this.errorBranch.enter();
                throw Errors.createTypeError("SameValue(new, O) is forbidden");
            }
            if (direct && JSArrayBuffer.getDirectByteLength(resObj) < newLen || !direct && JSArrayBuffer.getByteLength(resObj) < newLen) {
                this.errorBranch.enter();
                throw Errors.createTypeError("insufficient length constructed");
            }
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(thisObj)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }

        @Specialization(guards={"isJSHeapArrayBuffer(thisObj)"})
        protected DynamicObject slice(DynamicObject thisObj, Object begin0, Object end0) {
            int len = JSArrayBuffer.getByteArray(thisObj).length;
            int begin = this.getStart(begin0, len);
            int finalEnd = this.getEnd(end0, len);
            return this.slice(thisObj, begin, finalEnd);
        }

        @Specialization(guards={"isJSDirectArrayBuffer(thisObj)"})
        protected DynamicObject sliceDirect(DynamicObject thisObj, int begin, int end) {
            ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(thisObj);
            int byteLength = JSArrayBuffer.getDirectByteLength(thisObj);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, byteLength);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, byteLength);
            int newLen = clampedEnd - clampedBegin;
            DynamicObject resObj = this.constructNewArrayBuffer(thisObj, newLen);
            this.checkErrors(resObj, thisObj, newLen, true);
            ByteBuffer resBuffer = JSArrayBuffer.getDirectByteBuffer(resObj);
            Boundaries.byteBufferPutSlice(resBuffer, 0, byteBuffer, clampedBegin, clampedEnd);
            return resObj;
        }

        @Specialization(guards={"isJSDirectArrayBuffer(thisObj)"})
        protected DynamicObject sliceDirect(DynamicObject thisObj, Object begin0, Object end0) {
            int len = JSArrayBuffer.getDirectByteLength(thisObj);
            int begin = this.getStart(begin0, len);
            int end = this.getEnd(end0, len);
            return this.sliceDirect(thisObj, begin, end);
        }

        @Specialization(guards={"!isJSHeapArrayBuffer(thisObj)", "!isJSDirectArrayBuffer(thisObj)"})
        protected static DynamicObject error(Object thisObj, Object begin0, Object end0) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }
    }

    public static abstract class JSArrayBufferAbstractSliceNode
    extends JSArrayBufferOperation {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public JSArrayBufferAbstractSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected int getStart(Object start, int len) {
            long relativeStart = this.toInteger(start);
            if (relativeStart < 0L) {
                return (int)Math.max((long)len + relativeStart, 0L);
            }
            return (int)Math.min(relativeStart, (long)len);
        }

        protected int getEnd(Object end, int len) {
            long relativeEnd;
            long l = relativeEnd = end == Undefined.instance ? (long)len : this.toInteger(end);
            if (relativeEnd < 0L) {
                return (int)Math.max((long)len + relativeEnd, 0L);
            }
            return (int)Math.min(relativeEnd, (long)len);
        }

        protected static int clampIndex(int index, int lowerBound, int upperBound) {
            return JSArrayBufferAbstractSliceNode.clamp(index >= 0 ? index : index + upperBound, lowerBound, upperBound);
        }

        private static int clamp(int index, int lowerBound, int upperBound) {
            return Math.max(Math.min(index, upperBound), lowerBound);
        }

        public ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = (ArrayPrototypeBuiltins.ArraySpeciesConstructorNode)this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), true));
            }
            return this.arraySpeciesCreateNode;
        }
    }

    public static abstract class JSArrayBufferOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToIntegerAsLongNode toIntegerNode;

        public JSArrayBufferOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected long toInteger(Object thisObject) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = (JSToIntegerAsLongNode)this.insert(JSToIntegerAsLongNode.create());
            }
            return this.toIntegerNode.executeLong(thisObject);
        }
    }
}

