/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import org.netbeans.lib.profiler.global.CommonConstants;

public final class FilterSortSupport
implements CommonConstants {
    public static final String FILTERED_OUT_LBL;

    public static boolean passesFilter(Configuration info, String nodeName) {
        return FilterSortSupport.passesFilter(info.getFilterString(), info.getFilterType(), nodeName);
    }

    public static boolean passesFilter(String filter, int filterType, String nodeName) {
        switch (filterType) {
            case 0: {
                return true;
            }
            case 20: {
                return nodeName.toLowerCase().contains(filter);
            }
            case 25: {
                return !nodeName.toLowerCase().contains(filter);
            }
            case 50: {
                try {
                    return nodeName.matches(filter);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
        }
        return false;
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.Bundle");
        FILTERED_OUT_LBL = messages.getString("FilteringSupport_FilteredOutLbl");
    }

    public static final class Configuration {
        private int sortBy;
        private boolean sortOrder;
        private String filterString = "";
        private int filterType = 20;

        public int getSortBy() {
            return this.sortBy;
        }

        public boolean getSortOrder() {
            return this.sortOrder;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public int getFilterType() {
            return this.filterType;
        }

        public void setSortInfo(int sortBy, boolean sortOrder) {
            this.sortBy = sortBy;
            this.sortOrder = sortOrder;
        }

        public void setFilterInfo(String filterString, int filterType) {
            this.filterString = filterString;
            this.filterType = filterType;
        }
    }
}

