/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.spi.moduleinfo.JPAModuleInfo;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Util {
    private static final String[] JPA_VERSIONS = new String[]{"1.0", "2.0", "2.1"};

    public static void changeLabelInComponent(JComponent component, String oldLabel, String newLabel) {
        JLabel label = Util.findLabel(component, oldLabel);
        if (label != null) {
            label.setText(newLabel);
        }
    }

    public static void hideLabelAndLabelFor(JComponent component, String lab) {
        JLabel label = Util.findLabel(component, lab);
        if (label != null) {
            label.setVisible(false);
            Component c = label.getLabelFor();
            if (c != null) {
                c.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] components, Collection allComponents) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            allComponents.add(components[i]);
            if (((Container)components[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)components[i]).getComponents(), allComponents);
        }
    }

    public static JLabel findLabel(JComponent comp, String labelText) {
        Vector allComponents = new Vector();
        Util.getAllComponents(comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JLabel label;
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(labelText)) continue;
            return label;
        }
        return null;
    }

    public static SourceGroup getClassSourceGroup(Project project, String fqClassName) {
        SourceGroup[] sourceGroups;
        String classFile = fqClassName.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject classFO = sourceGroup.getRootFolder().getFileObject(classFile);
            if (classFO == null) continue;
            return sourceGroup;
        }
        return null;
    }

    public static ClassPath getFullClasspath(FileObject fo) {
        FileObject[] sourceRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").getRoots();
        FileObject[] bootRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot").getRoots();
        FileObject[] compileRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getRoots();
        FileObject[] roots = new FileObject[sourceRoots.length + bootRoots.length + compileRoots.length];
        System.arraycopy(sourceRoots, 0, roots, 0, sourceRoots.length);
        System.arraycopy(bootRoots, 0, roots, sourceRoots.length, bootRoots.length);
        System.arraycopy(compileRoots, 0, roots, sourceRoots.length + bootRoots.length, compileRoots.length);
        return ClassPathSupport.createClassPath((FileObject[])roots);
    }

    public static boolean isSupportedJavaEEVersion(Project project) {
        JPAModuleInfo moduleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (moduleInfo == null) {
            return false;
        }
        if (JPAModuleInfo.ModuleType.EJB == moduleInfo.getType() && Arrays.asList("3.0", "3.1", "3.2", "3.2.6", "4.0").contains(moduleInfo.getVersion())) {
            return true;
        }
        return JPAModuleInfo.ModuleType.WEB == moduleInfo.getType() && Arrays.asList("2.5", "3.1", "3.0", "4.0", "5.0").contains(moduleInfo.getVersion());
    }

    public static boolean isContainerManaged(Project project) {
        PersistenceProviderSupplier providerSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        return Util.isSupportedJavaEEVersion(project) && providerSupplier != null && providerSupplier.supportsDefaultProvider();
    }

    public static Provider getDefaultProvider(Project project) {
        PersistenceProviderSupplier providerSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (providerSupplier != null && providerSupplier.supportsDefaultProvider()) {
            List<Provider> providers = providerSupplier.getSupportedProviders();
            if (providers.size() > 0) {
                return providers.get(0);
            }
            Logger.getLogger(RelatedCMPWizard.class.getName()).log(Level.WARNING, "Default provider support is reported without any supported providers. See: {0}", providerSupplier);
        }
        return null;
    }

    public static ArrayList<Provider> getProviders(Project project) {
        ArrayList<Provider> providers;
        PersistenceProviderSupplier aProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (aProviderSupplier == null) {
            aProviderSupplier = new DefaultPersistenceProviderSupplier();
        }
        if ((providers = new ArrayList<Provider>(aProviderSupplier.getSupportedProviders())).isEmpty() && aProviderSupplier.supportsDefaultProvider()) {
            providers.add(ProviderUtil.DEFAULT_PROVIDER);
        }
        return providers;
    }

    public static Provider getPreferredProvider(Project project) {
        ArrayList<Provider> providers = Util.getProviders(project);
        int defIndex = 0;
        if (providers.size() > 1) {
            boolean specialCase;
            String defProviderVersion = ProviderUtil.getVersion(providers.get(0));
            boolean bl = specialCase = !(!Util.isJPAVersionSupported(project, "2.0") && !Util.isJPAVersionSupported(project, "2.1") || defProviderVersion != null && !defProviderVersion.equals("1.0"));
            if (specialCase) {
                for (int i = 1; i < providers.size(); ++i) {
                    if (!ProviderUtil.ECLIPSELINK_PROVIDER.equals(providers.get(i))) continue;
                    defIndex = i;
                    break;
                }
            }
        }
        if (providers.isEmpty()) {
            Logger.getLogger(RelatedCMPWizard.class.getName()).log(Level.INFO, "Can't find any providers supported by the project: {0}", project);
        }
        return providers.size() > 0 ? providers.get(defIndex) : null;
    }

    public static boolean isDefaultProvider(Project project, Provider provider) {
        return provider != null && provider.equals(Util.getDefaultProvider(project));
    }

    public static boolean isEjbModule(Project project) {
        JPAModuleInfo moduleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (moduleInfo == null) {
            return false;
        }
        return JPAModuleInfo.ModuleType.EJB == moduleInfo.getType();
    }

    public static boolean isEjb21Module(Project project) {
        JPAModuleInfo moduleInfo = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (moduleInfo == null) {
            return false;
        }
        return JPAModuleInfo.ModuleType.EJB == moduleInfo.getType() && "2.1".equals(moduleInfo.getVersion());
    }

    public static boolean isJavaSE(Project project) {
        return project.getLookup().lookup(JPAModuleInfo.class) == null;
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnitUsingWizard(Project project, String preselectedDB, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        String version;
        boolean isContainerManaged = Util.isContainerManaged(project);
        PersistenceUnitWizardPanel panel = isContainerManaged ? new PersistenceUnitWizardPanelDS(project, null, true, tableGeneration) : new PersistenceUnitWizardPanelJdbc(project, null, true, tableGeneration);
        if (preselectedDB != null) {
            panel.setPreselectedDB(preselectedDB);
        }
        final JButton createPUButton = new JButton(NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnitButton"));
        createPUButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Util.class, (String)"ACSD_CreatePersistenceUnitButton"));
        Object[] buttons = new Object[]{createPUButton, DialogDescriptor.CANCEL_OPTION};
        final DialogDescriptor nd = new DialogDescriptor((Object)new WrapperPanel(panel), NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnit").replace("&", ""), true, buttons, DialogDescriptor.OK_OPTION, 0, null, null);
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    nd.setValid(((Boolean)newvalue).booleanValue());
                    createPUButton.setEnabled((Boolean)newvalue);
                }
            }
        });
        if (!panel.isValidPanel()) {
            nd.setValid(false);
            createPUButton.setEnabled(false);
        }
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        Library lib = null;
        boolean libIsAdded = false;
        if (result == createPUButton) {
            if (isContainerManaged) {
                PersistenceUnitWizardPanelDS puDS = (PersistenceUnitWizardPanelDS)panel;
                lib = PersistenceLibrarySupport.getLibrary(puDS.getSelectedProvider());
            } else {
                PersistenceUnitWizardPanelJdbc puJdbc = (PersistenceUnitWizardPanelJdbc)panel;
                lib = PersistenceLibrarySupport.getLibrary(puJdbc.getSelectedProvider());
                if (lib != null) {
                    libIsAdded = true;
                    Util.addLibraryToProject(project, lib);
                }
                JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(puJdbc.getPersistenceConnection().getDriverClass());
                PersistenceLibrarySupport.addDriver(project, driver[0]);
            }
        }
        String string = version = lib != null && libIsAdded ? PersistenceUtils.getJPAVersion(lib) : PersistenceUtils.getJPAVersion(project);
        if (result == createPUButton) {
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = null;
            punit = "2.1".equals(version) ? new PersistenceUnit() : ("2.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit());
            if (isContainerManaged) {
                PersistenceUnitWizardPanelDS puPanel = (PersistenceUnitWizardPanelDS)panel;
                if (puPanel.getDatasource() != null && !"".equals(puPanel.getDatasource().trim())) {
                    if (puPanel.isJTA()) {
                        punit.setJtaDataSource(puPanel.getDatasource());
                    } else {
                        if (puPanel.isNonDefaultProviderEnabled()) {
                            punit.setNonJtaDataSource(puPanel.getDatasource());
                        }
                        punit.setTransactionType("RESOURCE_LOCAL");
                    }
                }
                if (puPanel.isNonDefaultProviderEnabled()) {
                    punit.setProvider(puPanel.getNonDefaultProvider());
                }
            } else {
                PersistenceUnitWizardPanelJdbc puJdbc = (PersistenceUnitWizardPanelJdbc)panel;
                punit = ProviderUtil.buildPersistenceUnit(puJdbc.getPersistenceUnitName(), puJdbc.getSelectedProvider(), puJdbc.getPersistenceConnection(), version);
                punit.setTransactionType("RESOURCE_LOCAL");
                if (!Util.isJavaSE(project)) {
                    punit.setExcludeUnlistedClasses(false);
                }
            }
            punit.setName(panel.getPersistenceUnitName());
            ProviderUtil.setTableGeneration(punit, panel.getTableGeneration(), project);
            return punit;
        }
        return null;
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnitUsingData(Project project, String puName, String preselectedDB, PersistenceUnitWizardPanel.TableGeneration tableGeneration, Provider provider) {
        return Util.buildPersistenceUnitUsingData(project, puName, preselectedDB, tableGeneration, provider, null);
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnitUsingData(Project project, String puName, String preselectedDB, PersistenceUnitWizardPanel.TableGeneration tableGeneration, Provider provider, String puVersion) {
        String provVersion;
        String version;
        boolean isContainerManaged = Util.isContainerManaged(project);
        if (provider == null) {
            provider = Util.getPreferredProvider(project);
        }
        if (provider == null) {
            provider = ProviderUtil.ECLIPSELINK_PROVIDER;
        }
        Library lib = null;
        boolean libIsAdded = false;
        if (isContainerManaged) {
            lib = PersistenceLibrarySupport.getLibrary(provider);
        } else {
            lib = PersistenceLibrarySupport.getLibrary(provider);
            if (lib != null) {
                Util.addLibraryToProject(project, lib);
                libIsAdded = true;
            }
        }
        String string = version = lib != null && libIsAdded ? PersistenceUtils.getJPAVersion(lib) : PersistenceUtils.getJPAVersion(project);
        if (provider != null && version != null && (provVersion = ProviderUtil.getVersion(provider)) != null && Double.parseDouble(version) > Double.parseDouble(provVersion)) {
            version = provVersion;
        }
        if (puVersion != null && Double.parseDouble(version) > Double.parseDouble(puVersion)) {
            version = puVersion;
        }
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = null;
        punit = "2.1".equals(version) ? new PersistenceUnit() : ("2.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit());
        if (isContainerManaged) {
            JPADataSourceProvider dsProvider;
            if ((preselectedDB == null || preselectedDB.trim().equals("")) && (dsProvider = (JPADataSourceProvider)project.getLookup().lookup(JPADataSourceProvider.class)).getDataSources().size() > 0) {
                preselectedDB = dsProvider.getDataSources().get(0).getDisplayName();
            }
            if (preselectedDB != null && !"".equals(preselectedDB.trim())) {
                punit.setJtaDataSource(preselectedDB);
            }
            if (!(provider instanceof DefaultProvider)) {
                punit.setProvider(provider.getProviderClass());
            }
            punit.setExcludeUnlistedClasses(false);
        } else {
            DatabaseConnection connection = null;
            if (preselectedDB != null && !preselectedDB.trim().equals("")) {
                connection = ConnectionManager.getDefault().getConnection(preselectedDB);
            }
            if (connection == null) {
                ConnectionManager cm = ConnectionManager.getDefault();
                DatabaseConnection[] connections = cm.getConnections();
                connection = connections != null && connections.length > 0 ? connections[0] : null;
            }
            punit = ProviderUtil.buildPersistenceUnit("tmp", provider, connection, version);
            punit.setTransactionType("RESOURCE_LOCAL");
            if (!Util.isJavaSE(project)) {
                punit.setExcludeUnlistedClasses(false);
            }
        }
        if (puName == null) {
            puName = Util.getCandidateName(project);
        }
        punit.setName(puName);
        ProviderUtil.setTableGeneration(punit, tableGeneration != null ? tableGeneration.name() : PersistenceUnitWizardPanel.TableGeneration.NONE.name(), project);
        return punit;
    }

    public static boolean isJPAVersionSupported(Project project, String version) {
        JPAModuleInfo info = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        if (info != null) {
            return !Boolean.FALSE.equals(info.isJPAVersionSupported(version));
        }
        return true;
    }

    public static String getJPAVersionSupported(Project project, String top) {
        JPAModuleInfo info = (JPAModuleInfo)project.getLookup().lookup(JPAModuleInfo.class);
        boolean top_found = false;
        if (info != null) {
            for (int i = JPA_VERSIONS.length - 1; i >= 0; --i) {
                if (JPA_VERSIONS[i].equals(top)) {
                    top_found = true;
                }
                if (!top_found || Boolean.FALSE.equals(info.isJPAVersionSupported(JPA_VERSIONS[i]))) continue;
                return JPA_VERSIONS[i];
            }
        }
        return JPA_VERSIONS[0];
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String preselectedDB, PersistenceUnitWizardPanel.TableGeneration tableGeneration) throws InvalidPersistenceXmlException {
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = Util.buildPersistenceUnitUsingWizard(project, preselectedDB, tableGeneration);
        if (punit == null) {
            return false;
        }
        String version = "1.0";
        if (punit instanceof PersistenceUnit) {
            version = "2.1";
        } else if (punit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit) {
            version = "2.0";
        }
        PUDataObject pud = ProviderUtil.getPUDataObject(project, version);
        if (pud == null) {
            return false;
        }
        pud.addPersistenceUnit(punit);
        pud.save();
        return true;
    }

    public static void addPersistenceUnitToProject(Project project, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Util.addPersistenceUnitToProjectRoot(project, null, persistenceUnit);
    }

    public static void addPersistenceUnitToProjectRoot(Project project, FileObject root, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        String providerClass = persistenceUnit.getProvider();
        boolean libAdded = false;
        Library lib = null;
        if (providerClass != null) {
            Provider selectedProvider = ProviderUtil.getProvider(providerClass, project);
            lib = PersistenceLibrarySupport.getLibrary(selectedProvider);
            if (lib != null) {
                if (!Util.isDefaultProvider(project, selectedProvider)) {
                    Util.addLibraryToProject(project, lib);
                    libAdded = true;
                } else if (selectedProvider.getAnnotationProcessor() != null) {
                    Util.addLibraryToProject(project, lib, "classpath/processor");
                    libAdded = true;
                }
            }
            if (!Util.isContainerManaged(project)) {
                DatabaseConnection connection = ProviderUtil.getConnection(persistenceUnit);
                if (connection != null) {
                    JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(connection.getDriverClass());
                    PersistenceLibrarySupport.addDriver(project, driver[0]);
                } else {
                    Logger.getLogger("global").log(Level.INFO, "Can't find connection for persistence unit");
                }
            }
        }
        try {
            ProviderUtil.addPersistenceUnit(persistenceUnit, project, root);
        }
        catch (InvalidPersistenceXmlException ipx) {
            Logger.getLogger(RelatedCMPWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + ipx.getPath(), ipx);
        }
        if (libAdded && lib != null) {
            Library mLib;
            double version;
            String projVersion = PersistenceUtils.getJPAVersion(project);
            if (projVersion == null) {
                projVersion = "1.0";
            }
            if ((version = Math.max(Double.parseDouble(PersistenceUtils.getJPAVersion(lib)), Double.parseDouble(projVersion))) > 1.0 && Util.isJPAVersionSupported(project, Double.toString(version)) && (mLib = LibraryManager.getDefault().getLibrary(lib.getName() + "modelgen")) != null) {
                Util.addLibraryToProject(project, mLib, "classpath/processor");
            }
        }
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String preselectedDB) throws InvalidPersistenceXmlException {
        return Util.createPersistenceUnitUsingWizard(project, preselectedDB, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public static void addLibraryToProject(Project project, Library library) {
        Util.addLibraryToProject(project, library, "classpath/compile");
    }

    public static void addLibraryToProject(Project project, Library library, String classpathType) {
        if (SwingUtilities.isEventDispatchThread()) {
            AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new AddLibrary(project, library, classpathType), (String)NbBundle.getMessage(Util.class, (String)"TTL_ExtendProjectClasspath"), (AtomicBoolean)cancel, (boolean)false);
        } else {
            Util.addLibraryToProject0(project, library, classpathType);
        }
    }

    public static void addPersistenceUnitToProject(Project project) {
        Library lib;
        if (PersistenceUtils.getJPAVersion(project) == null && (lib = Util.isJPAVersionSupported(project, "2.1") || Util.isJPAVersionSupported(project, "2.0") ? LibraryManager.getDefault().getLibrary("jpa20-persistence") : LibraryManager.getDefault().getLibrary("persistence")) != null) {
            Util.addLibraryToProject(project, lib);
        }
    }

    private static void addLibraryToProject0(Project project, Library library, String classpathType) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        SourceGroup firstGroup = groups[0];
        FileObject fo = firstGroup.getRootFolder();
        try {
            ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)fo, (String)classpathType);
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.FINE, "Can't add library to the project", ex);
        }
        catch (UnsupportedOperationException ex) {
            Logger.getLogger("global").log(Level.FINE, "Can't add library to the project", ex);
        }
    }

    public static String getCandidateName(Project project) {
        String candidateNameBase = ProjectUtils.getInformation((Project)project).getName() + "PU";
        try {
            if (!ProviderUtil.persistenceExists(project)) {
                return candidateNameBase;
            }
            PUDataObject pudo = ProviderUtil.getPUDataObject(project);
            Persistence persistence = pudo.getPersistence();
            int suffix = 2;
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] punits = persistence.getPersistenceUnit();
            String candidateName = candidateNameBase;
            while (!Util.isUnique(candidateName, punits)) {
                candidateName = candidateNameBase + suffix++;
            }
            return candidateName;
        }
        catch (InvalidPersistenceXmlException ipex) {
            Logger.getLogger("global").log(Level.FINE, "Invalid persistence.xml found", ipex);
            return candidateNameBase;
        }
    }

    private static boolean isUnique(String candidate, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] punits) {
        for (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit : punits) {
            if (!candidate.equals(punit.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getPersistenceUnitAsString(Project project, String entity) throws IOException {
        Persistence persistence;
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] units;
        FileObject persXml;
        String persistenceUnit = null;
        PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes(project);
        if (persistenceScopes.length > 0 && (persXml = persistenceScopes[0].getPersistenceXml()) != null && (units = (persistence = PersistenceMetadata.getDefault().getRoot(persXml)).getPersistenceUnit()).length > 0) {
            persistenceUnit = units[0].getName();
            if (units.length > 1) {
                String[] classes;
                org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit tmp;
                int i;
                String forAll = null;
                String forOne = null;
                block0: for (i = 0; i < units.length && forOne == null; ++i) {
                    tmp = units[i];
                    if (forAll == null && !tmp.isExcludeUnlistedClasses()) {
                        forAll = tmp.getName();
                    }
                    if (!tmp.isExcludeUnlistedClasses()) continue;
                    for (String clas : classes = tmp.getClass2()) {
                        if (!entity.equals(clas)) continue;
                        forOne = tmp.getName();
                        continue block0;
                    }
                }
                if (forOne == null && forAll != null) {
                    block2: for (i = 0; i < units.length && forOne == null; ++i) {
                        tmp = units[i];
                        if (tmp.isExcludeUnlistedClasses()) continue;
                        for (String clas : classes = tmp.getClass2()) {
                            if (!entity.equals(clas)) continue;
                            forOne = tmp.getName();
                            continue block2;
                        }
                    }
                }
                persistenceUnit = forOne != null ? forOne : (forAll != null ? forAll : persistenceUnit);
            }
        }
        return persistenceUnit;
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] getPersistenceUnits(Project project) throws IOException {
        FileObject persXml;
        PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes(project);
        if (persistenceScopes.length > 0 && (persXml = persistenceScopes[0].getPersistenceXml()) != null) {
            Persistence persistence = PersistenceMetadata.getDefault().getRoot(persXml);
            return persistence.getPersistenceUnit();
        }
        return new org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[0];
    }

    public static Set getSelectedItems(JList list, boolean enabledOnly) {
        HashSet result = new HashSet();
        int[] selected = list.getSelectedIndices();
        for (int i = 0; i < selected.length; ++i) {
            Object item = list.getModel().getElementAt(selected[i]);
            if (enabledOnly && !list.getCellRenderer().getListCellRendererComponent(list, item, selected[i], false, false).isEnabled()) continue;
            result.add(item);
        }
        return result;
    }

    public static Set getEnabledItems(JList list) {
        HashSet result = new HashSet();
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            Object item = list.getModel().getElementAt(i);
            if (!list.getCellRenderer().getListCellRendererComponent(list, item, i, false, false).isEnabled()) continue;
            result.add(item);
        }
        return result;
    }

    private static class DefaultPersistenceProviderSupplier
    implements PersistenceProviderSupplier {
        private DefaultPersistenceProviderSupplier() {
        }

        @Override
        public List<Provider> getSupportedProviders() {
            ArrayList<Provider> model = new ArrayList<Provider>();
            for (Provider each : PersistenceLibrarySupport.getProvidersFromLibraries()) {
                boolean found = false;
                for (int i = 0; i < model.size(); ++i) {
                    Object elem = model.get(i);
                    if (!(elem instanceof Provider) || !each.equals(elem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                model.add(each);
            }
            return model;
        }

        @Override
        public boolean supportsDefaultProvider() {
            return false;
        }
    }

    private static class AddLibrary
    implements Runnable {
        Project project;
        Library library;
        String classpathType;

        public AddLibrary(Project project, Library library, String classpathType) {
            this.project = project;
            this.library = library;
            this.classpathType = classpathType;
        }

        @Override
        public void run() {
            Util.addLibraryToProject0(this.project, this.library, this.classpathType);
        }
    }
}

