/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxXmlSymbols;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;
import org.netbeans.modules.javafx2.editor.parser.processors.ImportProcessor;

public class TypeResolver
extends FxNodeVisitor.ModelTreeTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;
    private ImportProcessor importProcessor;

    public TypeResolver() {
    }

    public TypeResolver(BuildEnvironment env) {
        this.env = env;
    }

    @Override
    public void visitSource(FxModel model) {
        this.importProcessor = new ImportProcessor(this.env.getHierarchy(), this.env, this.env.getTreeUtilities());
        this.importProcessor.load(this.env.getCompilationInfo(), model);
        String controller = model.getController();
        if (controller != null) {
            int[] pos = this.env.getTreeUtilities().findAttributePos(model.getRootComponent(), "http://javafx.com/fxml", "controller", true);
            ElementHandle<TypeElement> handle = this.resolveClassname(controller, model.getRootComponent(), pos[0]);
            this.env.getAccessor().resolve(model, handle, null, null, null);
        }
        super.visitSource(model);
    }

    @Override
    public void visitInstance(FxNewInstance decl) {
        ElementHandle<TypeElement> handle;
        int start;
        String sourceName = decl.getTypeName();
        TypeElement el = this.env.getCompilationInfo().getElements().getTypeElement(sourceName);
        if (el == null) {
            if (decl.isCustomRoot()) {
                int[] pos = this.env.getTreeUtilities().findAttributePos(decl, null, "type", true);
                if (pos == null) {
                    super.visitInstance(decl);
                    return;
                }
                start = pos[0];
            } else {
                start = this.env.getTreeUtilities().positions(decl).getStart() + 1;
            }
            handle = this.resolveClassname(sourceName, decl, start);
            if (handle != null) {
                String fqn = handle.getQualifiedName();
            } else {
                Object var7_4 = null;
            }
        } else {
            handle = ElementHandle.create((Element)el);
        }
        if (handle != null) {
            FxBean bean = this.env.getBeanInfo(handle.getQualifiedName());
            if (bean == null) {
                start = this.env.getTreeUtilities().positions(decl).getStart() + 1;
                this.env.addError(new ErrorMark(start, sourceName.length(), "unable-analyze-class", Bundle.ERR_unableAnalyseClass(handle.getQualifiedName().toString()), handle));
            } else {
                FxBean bean2 = this.checkBeanInstance(decl, bean);
                if (bean2 != null) {
                    handle = bean2.getJavaType();
                    bean = bean2;
                }
            }
            this.env.getAccessor().resolve(decl, handle, null, null, bean);
        }
        super.visitInstance(decl);
    }

    FxBean checkBeanInstance(FxNewInstance decl, FxBean beanInfo) {
        TypeElement productType;
        TypeMirror tm;
        String fM = decl.getFactoryMethod();
        int start = this.env.getTreeUtilities().positions(decl).getStart() + 1;
        if (fM == null) {
            if (beanInfo.isFxInstance() || beanInfo.getBuilder() != null || decl.isCustomRoot()) {
                return beanInfo;
            }
            this.env.addError(new ErrorMark(start, decl.getTypeName().length(), "class-not-fx-instance", Bundle.ERR_notFxInstance(beanInfo.getJavaType().getQualifiedName().toString()), beanInfo.getJavaType()));
            return beanInfo;
        }
        TypeMirrorHandle h = beanInfo.getFactoryType(fM);
        TypeMirror typeMirror = tm = h == null ? null : h.resolve(this.env.getCompilationInfo());
        if (tm == null) {
            this.env.addError(new ErrorMark(start, decl.getTypeName().length(), "returned-factory-type-not-found", Bundle.ERR_factoryTypeNotFound(fM, beanInfo.getJavaType().getQualifiedName().toString()), beanInfo));
            return beanInfo;
        }
        switch (tm.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                productType = this.env.getCompilationInfo().getTypes().boxedClass((PrimitiveType)tm);
                break;
            }
            case DECLARED: {
                productType = (TypeElement)((DeclaredType)this.env.getCompilationInfo().getTypes().erasure((DeclaredType)tm)).asElement();
                break;
            }
            default: {
                return null;
            }
        }
        return this.env.getBeanInfo(productType.getQualifiedName().toString());
    }

    private ElementHandle<TypeElement> resolveClassname(String name, FxNode decl, int start) {
        if (!FxXmlSymbols.isQualifiedIdentifier(name)) {
            this.env.addError(new ErrorMark(start, name.length(), "invalid-java-identifier", Bundle.ERR_invalidJavaIdentifier(name), name));
            return null;
        }
        TypeElement el = this.env.getCompilationInfo().getElements().getTypeElement(name);
        if (el != null) {
            return ElementHandle.create((Element)el);
        }
        Set<String> names = this.importProcessor.resolveName(name);
        if (names != null && names.size() == 1) {
            String fqn = names.iterator().next();
            el = this.env.getCompilationInfo().getElements().getTypeElement(fqn);
            if (el != null) {
                ElementHandle handle = ElementHandle.create((Element)el);
                return handle;
            }
        }
        if (names == null || names.size() == 1) {
            this.env.addError(new ErrorMark(start, name.length(), "class-not-exist", Bundle.ERR_symbolNotExist(name), name));
        } else {
            Iterator<String> it = names.iterator();
            this.env.addError(new ErrorMark(start, name.length(), "class-ambiguous", Bundle.ERR_symbolAmbiguous(name, it.next(), it.next()), name));
        }
        return null;
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new TypeResolver(env);
    }
}

