/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;
import org.springframework.web.util.TagUtils;

public class MessageTag
extends HtmlEscapingAwareTag {
    public static final String DEFAULT_ARGUMENT_SEPARATOR = ",";
    private Object message;
    private String code;
    private Object arguments;
    private String argumentSeparator = ",";
    private String text;
    private String var;
    private String scope = "page";
    private boolean javaScriptEscape = false;

    public void setMessage(Object message) {
        this.message = message;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setArguments(Object arguments) {
        this.arguments = arguments;
    }

    public void setArgumentSeparator(String argumentSeparator) {
        this.argumentSeparator = argumentSeparator;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setJavaScriptEscape(String javaScriptEscape) throws JspException {
        this.javaScriptEscape = ExpressionEvaluationUtils.evaluateBoolean((String)"javaScriptEscape", (String)javaScriptEscape, (PageContext)this.pageContext);
    }

    protected final int doStartTagInternal() throws JspException, IOException {
        try {
            String msg = this.resolveMessage();
            msg = this.isHtmlEscape() ? HtmlUtils.htmlEscape((String)msg) : msg;
            msg = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape((String)msg) : msg;
            String resolvedVar = ExpressionEvaluationUtils.evaluateString((String)"var", (String)this.var, (PageContext)this.pageContext);
            if (resolvedVar != null) {
                String resolvedScope = ExpressionEvaluationUtils.evaluateString((String)"scope", (String)this.scope, (PageContext)this.pageContext);
                this.pageContext.setAttribute(resolvedVar, (Object)msg, TagUtils.getScope((String)resolvedScope));
            } else {
                this.writeMessage(msg);
            }
            return 1;
        }
        catch (NoSuchMessageException ex) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(ex));
        }
    }

    protected String resolveMessage() throws JspException, NoSuchMessageException {
        MessageSource messageSource = this.getMessageSource();
        if (messageSource == null) {
            throw new JspTagException("No corresponding MessageSource found");
        }
        MessageSourceResolvable resolvedMessage = null;
        if (this.message instanceof MessageSourceResolvable) {
            resolvedMessage = (MessageSourceResolvable)this.message;
        } else if (this.message != null) {
            String expr = this.message.toString();
            resolvedMessage = (MessageSourceResolvable)ExpressionEvaluationUtils.evaluate((String)"message", (String)expr, MessageSourceResolvable.class, (PageContext)this.pageContext);
        }
        if (resolvedMessage != null) {
            return messageSource.getMessage(resolvedMessage, this.getRequestContext().getLocale());
        }
        String resolvedCode = ExpressionEvaluationUtils.evaluateString((String)"code", (String)this.code, (PageContext)this.pageContext);
        String resolvedText = ExpressionEvaluationUtils.evaluateString((String)"text", (String)this.text, (PageContext)this.pageContext);
        if (resolvedCode != null || resolvedText != null) {
            Object[] argumentsArray = this.resolveArguments(this.arguments);
            if (resolvedText != null) {
                return messageSource.getMessage(resolvedCode, argumentsArray, resolvedText, this.getRequestContext().getLocale());
            }
            return messageSource.getMessage(resolvedCode, argumentsArray, this.getRequestContext().getLocale());
        }
        return resolvedText;
    }

    protected Object[] resolveArguments(Object arguments) throws JspException {
        if (arguments instanceof String) {
            String[] stringArray = StringUtils.delimitedListToStringArray((String)((String)arguments), (String)this.argumentSeparator);
            if (stringArray.length == 1) {
                Object argument = ExpressionEvaluationUtils.evaluate((String)"argument", (String)stringArray[0], (PageContext)this.pageContext);
                if (argument != null && argument.getClass().isArray()) {
                    return ObjectUtils.toObjectArray((Object)argument);
                }
                return new Object[]{argument};
            }
            Object[] argumentsArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                argumentsArray[i] = ExpressionEvaluationUtils.evaluate((String)("argument[" + i + "]"), (String)stringArray[i], (PageContext)this.pageContext);
            }
            return argumentsArray;
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        if (arguments instanceof Collection) {
            return ((Collection)arguments).toArray();
        }
        if (arguments != null) {
            return new Object[]{arguments};
        }
        return null;
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(String.valueOf(msg));
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getMessageSource();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException ex) {
        return ex.getMessage();
    }
}

