/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import gen.core.filters.Filters;
import gen.core.project.RepositoryDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.omegat.core.Core;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.SRX;
import org.omegat.externalfinder.ExternalFinder;
import org.omegat.externalfinder.gui.ExternalFinderCustomizer;
import org.omegat.externalfinder.item.ExternalFinderConfiguration;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.dialogs.FilenamePatternsEditorController;
import org.omegat.gui.dialogs.RepositoriesMappingController;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.LanguageComboBoxRenderer;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TokenizerComboBoxRenderer;
import org.openide.awt.Mnemonics;

public class ProjectPropertiesDialog
extends JDialog {
    private ProjectProperties projectProperties;
    private Mode dialogType;
    private SRX srx;
    private Filters filters;
    private ExternalFinderConfiguration externalFinderConfig;
    private List<String> srcExcludes = new ArrayList<String>();
    private boolean dialogCancelled;

    public ProjectPropertiesDialog(final Frame parent, final ProjectProperties projectProperties, String projFileName, Mode dialogTypeValue) {
        super(parent, true);
        this.projectProperties = projectProperties;
        this.srx = projectProperties.getProjectSRX();
        this.dialogType = dialogTypeValue;
        this.filters = projectProperties.getProjectFilters();
        this.srcExcludes.addAll(projectProperties.getSourceRootExcludes());
        this.externalFinderConfig = ExternalFinder.getProjectConfig();
        EmptyBorder emptyBorder = new EmptyBorder(2, 0, 2, 0);
        ScrollableBox centerBox = new ScrollableBox(1);
        centerBox.setBackground(this.getBackground());
        centerBox.setOpaque(true);
        centerBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTextArea messageArea = new JTextArea();
        messageArea.setEditable(false);
        messageArea.setOpaque(false);
        messageArea.setFont(new Label().getFont());
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box bMes = Box.createHorizontalBox();
        bMes.setBorder(emptyBorder);
        bMes.add(messageArea);
        bMes.add(Box.createHorizontalGlue());
        centerBox.add(bMes);
        Box localesBox = Box.createHorizontalBox();
        localesBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OStrings.getString("PP_LANGUAGES")));
        Box bL = Box.createVerticalBox();
        localesBox.add(bL);
        JLabel sourceLocaleLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)sourceLocaleLabel, (String)OStrings.getString("PP_SRC_LANG"));
        Box bSL = Box.createHorizontalBox();
        bSL.setBorder(emptyBorder);
        bSL.add(sourceLocaleLabel);
        bSL.add(Box.createHorizontalGlue());
        bL.add(bSL);
        final JComboBox<Language> sourceLocaleField = new JComboBox<Language>(new Vector<Language>(Language.getLanguages()));
        if (sourceLocaleField.getMaximumRowCount() < 20) {
            sourceLocaleField.setMaximumRowCount(20);
        }
        sourceLocaleField.setEditable(true);
        sourceLocaleField.setRenderer(new LanguageComboBoxRenderer());
        sourceLocaleField.setSelectedItem(projectProperties.getSourceLanguage());
        bL.add(sourceLocaleField);
        JLabel targetLocaleLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)targetLocaleLabel, (String)OStrings.getString("PP_LOC_LANG"));
        Box bLL = Box.createHorizontalBox();
        bLL.setBorder(emptyBorder);
        bLL.add(targetLocaleLabel);
        bLL.add(Box.createHorizontalGlue());
        bL.add(bLL);
        final JComboBox<Language> targetLocaleField = new JComboBox<Language>(new Vector<Language>(Language.getLanguages()));
        if (targetLocaleField.getMaximumRowCount() < 20) {
            targetLocaleField.setMaximumRowCount(20);
        }
        targetLocaleField.setEditable(true);
        targetLocaleField.setRenderer(new LanguageComboBoxRenderer());
        targetLocaleField.setSelectedItem(projectProperties.getTargetLanguage());
        bL.add(targetLocaleField);
        Box bT = Box.createVerticalBox();
        localesBox.add(bT);
        Class[] tokenizers = (Class[])PluginUtils.getTokenizerClasses().stream().sorted(Comparator.comparing(Class::getName)).toArray(Class[]::new);
        JLabel sourceTokenizerLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)sourceTokenizerLabel, (String)OStrings.getString("PP_SRC_TOK"));
        Box bST = Box.createHorizontalBox();
        bST.setBorder(emptyBorder);
        bST.add(sourceTokenizerLabel);
        bST.add(Box.createHorizontalGlue());
        bT.add(bST);
        final JComboBox<Class> sourceTokenizerField = new JComboBox<Class>(tokenizers);
        if (sourceTokenizerField.getMaximumRowCount() < 20) {
            sourceTokenizerField.setMaximumRowCount(20);
        }
        sourceTokenizerField.setEditable(false);
        sourceTokenizerField.setRenderer(new TokenizerComboBoxRenderer());
        sourceTokenizerField.setSelectedItem(projectProperties.getSourceTokenizer());
        bT.add(sourceTokenizerField);
        String cliTokSrc = Core.getParams().get("ITokenizer");
        if (cliTokSrc != null) {
            try {
                Class<?> srcTokClass = Class.forName(cliTokSrc);
                sourceTokenizerField.setEnabled(false);
                sourceTokenizerField.addItem(srcTokClass);
                sourceTokenizerField.setSelectedItem(cliTokSrc);
            }
            catch (ClassNotFoundException | LinkageError ex) {
                Log.log(ex);
            }
        }
        ActionListener sourceLocaleListener = e -> {
            if (!sourceLocaleField.isEnabled()) {
                return;
            }
            Object newLang = sourceLocaleField.getSelectedItem();
            if (newLang instanceof String) {
                newLang = new Language((String)newLang);
            }
            Class<?> newTok = PluginUtils.getTokenizerClassForLanguage((Language)newLang);
            sourceTokenizerField.setSelectedItem(newTok);
        };
        sourceLocaleField.addActionListener(sourceLocaleListener);
        JLabel targetTokenizerLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)targetTokenizerLabel, (String)OStrings.getString("PP_LOC_TOK"));
        Box bTT = Box.createHorizontalBox();
        bTT.setBorder(emptyBorder);
        bTT.add(targetTokenizerLabel);
        bTT.add(Box.createHorizontalGlue());
        bT.add(bTT);
        final JComboBox<Class> targetTokenizerField = new JComboBox<Class>(tokenizers);
        if (targetTokenizerField.getMaximumRowCount() < 20) {
            targetTokenizerField.setMaximumRowCount(20);
        }
        targetTokenizerField.setEditable(false);
        targetTokenizerField.setRenderer(new TokenizerComboBoxRenderer());
        targetTokenizerField.setSelectedItem(projectProperties.getTargetTokenizer());
        bT.add(targetTokenizerField);
        String cliTokTrg = Core.getParams().get("ITokenizerTarget");
        if (cliTokTrg != null) {
            try {
                Class<?> trgTokClass = Class.forName(cliTokTrg);
                targetTokenizerField.setEnabled(false);
                targetTokenizerField.addItem(trgTokClass);
                targetTokenizerField.setSelectedItem(cliTokTrg);
            }
            catch (ClassNotFoundException | LinkageError ex) {
                Log.log(ex);
            }
        }
        ActionListener targetLocaleListener = e -> {
            if (!targetLocaleField.isEnabled()) {
                return;
            }
            Object newLang = targetLocaleField.getSelectedItem();
            if (newLang instanceof String) {
                newLang = new Language((String)newLang);
            }
            Class<?> newTok = PluginUtils.getTokenizerClassForLanguage((Language)newLang);
            targetTokenizerField.setSelectedItem(newTok);
        };
        targetLocaleField.addActionListener(targetLocaleListener);
        centerBox.add(localesBox);
        if (dialogTypeValue == Mode.NEW_PROJECT) {
            sourceLocaleListener.actionPerformed(null);
            targetLocaleListener.actionPerformed(null);
        }
        centerBox.add(Box.createVerticalStrut(5));
        JPanel optionsBox = new JPanel(new GridBagLayout());
        optionsBox.setBorder(new EtchedBorder());
        optionsBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OStrings.getString("PP_OPTIONS")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        final JCheckBox sentenceSegmentingCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)sentenceSegmentingCheckBox, (String)OStrings.getString("PP_SENTENCE_SEGMENTING"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        optionsBox.add((Component)sentenceSegmentingCheckBox, gbc);
        JButton sentenceSegmentingButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)sentenceSegmentingButton, (String)OStrings.getString("MW_OPTIONSMENU_SENTSEG"));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        optionsBox.add((Component)sentenceSegmentingButton, gbc);
        JButton fileFiltersButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)fileFiltersButton, (String)OStrings.getString("WM_PROJECTMENU_FILEFILTERS"));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 13;
        optionsBox.add((Component)fileFiltersButton, gbc);
        JButton repositoriesButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)repositoriesButton, (String)OStrings.getString("PP_REPOSITORIES"));
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 13;
        optionsBox.add((Component)repositoriesButton, gbc);
        JButton externalFinderButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)externalFinderButton, (String)OStrings.getString("PP_EXTERNALFINDER"));
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 13;
        optionsBox.add((Component)externalFinderButton, gbc);
        final JCheckBox allowDefaultsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)allowDefaultsCheckBox, (String)OStrings.getString("PP_ALLOW_DEFAULTS"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        optionsBox.add((Component)allowDefaultsCheckBox, gbc);
        final JCheckBox removeTagsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)removeTagsCheckBox, (String)OStrings.getString("PP_REMOVE_TAGS"));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        optionsBox.add((Component)removeTagsCheckBox, gbc);
        JLabel externalCommandLabel = new JLabel();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        optionsBox.add((Component)externalCommandLabel, gbc);
        final JTextArea externalCommandTextArea = new JTextArea();
        externalCommandTextArea.setRows(2);
        externalCommandTextArea.setLineWrap(true);
        externalCommandTextArea.setText(projectProperties.getExternalCommand());
        if (Preferences.isPreference("allow_project_extern_cmd")) {
            Mnemonics.setLocalizedText((JLabel)externalCommandLabel, (String)OStrings.getString("PP_EXTERNAL_COMMAND"));
        } else {
            Mnemonics.setLocalizedText((JLabel)externalCommandLabel, (String)OStrings.getString("PP_EXTERN_CMD_DISABLED"));
            externalCommandTextArea.setEditable(false);
            externalCommandTextArea.setToolTipText(OStrings.getString("PP_EXTERN_CMD_DISABLED_TOOLTIP"));
            externalCommandLabel.setToolTipText(OStrings.getString("PP_EXTERN_CMD_DISABLED_TOOLTIP"));
            externalCommandTextArea.setBackground(this.getBackground());
        }
        JScrollPane externalCommandScrollPane = new JScrollPane();
        externalCommandScrollPane.setViewportView(externalCommandTextArea);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        optionsBox.add((Component)externalCommandScrollPane, gbc);
        JLabel variablesLabel = new JLabel();
        final JComboBox<String> variablesList = new JComboBox<String>(new Vector<String>(CommandVarExpansion.getCommandVariables()));
        JButton insertButton = new JButton();
        if (Preferences.isPreference("allow_project_extern_cmd")) {
            Box bIC = Box.createHorizontalBox();
            bIC.setBorder(emptyBorder);
            Mnemonics.setLocalizedText((JLabel)variablesLabel, (String)OStrings.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
            bIC.add(variablesLabel);
            bIC.add(variablesList);
            Mnemonics.setLocalizedText((AbstractButton)insertButton, (String)OStrings.getString("BUTTON_INSERT"));
            insertButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    externalCommandTextArea.replaceSelection(variablesList.getSelectedItem().toString());
                }
            });
            bIC.add(insertButton);
            bIC.add(Box.createHorizontalGlue());
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            optionsBox.add((Component)bIC, gbc);
        }
        centerBox.add((Component)optionsBox, "West");
        centerBox.add(Box.createVerticalStrut(5));
        Box dirsBox = Box.createVerticalBox();
        dirsBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OStrings.getString("PP_DIRECTORIES")));
        JLabel srcRootLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)srcRootLabel, (String)OStrings.getString("PP_SRC_ROOT"));
        Box bSrc = Box.createHorizontalBox();
        bSrc.setBorder(emptyBorder);
        bSrc.add(srcRootLabel);
        bSrc.add(Box.createHorizontalGlue());
        JButton srcExcludesBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)srcExcludesBtn, (String)OStrings.getString("PP_BUTTON_BROWSE_SRC_EXCLUDES"));
        bSrc.add(srcExcludesBtn);
        JButton srcBrowse = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)srcBrowse, (String)OStrings.getString("PP_BUTTON_BROWSE_SRC"));
        bSrc.add(srcBrowse);
        final JTextField srcRootField = new JTextField();
        dirsBox.add(bSrc);
        dirsBox.add(srcRootField);
        JLabel tmRootLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)tmRootLabel, (String)OStrings.getString("PP_TM_ROOT"));
        Box bTM = Box.createHorizontalBox();
        bTM.setBorder(emptyBorder);
        bTM.add(tmRootLabel);
        bTM.add(Box.createHorizontalGlue());
        JButton tmBrowse = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)tmBrowse, (String)OStrings.getString("PP_BUTTON_BROWSE_TM"));
        bTM.add(tmBrowse);
        final JTextField tmRootField = new JTextField();
        dirsBox.add(bTM);
        dirsBox.add(tmRootField);
        JLabel glosRootLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)glosRootLabel, (String)OStrings.getString("PP_GLOS_ROOT"));
        Box bGlos = Box.createHorizontalBox();
        bGlos.setBorder(emptyBorder);
        bGlos.add(glosRootLabel);
        bGlos.add(Box.createHorizontalGlue());
        JButton glosBrowse = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)glosBrowse, (String)OStrings.getString("PP_BUTTON_BROWSE_GL"));
        bGlos.add(glosBrowse);
        final JTextField glosRootField = new JTextField();
        dirsBox.add(bGlos);
        dirsBox.add(glosRootField);
        JLabel writeableGlosLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)writeableGlosLabel, (String)OStrings.getString("PP_WRITEABLE_GLOS"));
        Box bwGlos = Box.createHorizontalBox();
        bwGlos.setBorder(emptyBorder);
        bwGlos.add(writeableGlosLabel);
        bwGlos.add(Box.createHorizontalGlue());
        JButton wGlosBrowse = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)wGlosBrowse, (String)OStrings.getString("PP_BUTTON_BROWSE_WG"));
        bwGlos.add(wGlosBrowse);
        final JTextField writeableGlosField = new JTextField();
        dirsBox.add(bwGlos);
        dirsBox.add(writeableGlosField);
        JLabel locDictLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)locDictLabel, (String)OStrings.getString("PP_DICT_ROOT"));
        Box bDict = Box.createHorizontalBox();
        bDict.setBorder(emptyBorder);
        bDict.add(locDictLabel);
        bDict.add(Box.createHorizontalGlue());
        JButton dictBrowse = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)dictBrowse, (String)OStrings.getString("PP_BUTTON_BROWSE_DICT"));
        bDict.add(dictBrowse);
        final JTextField dictRootField = new JTextField();
        dirsBox.add(bDict);
        dirsBox.add(dictRootField);
        JLabel locRootLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)locRootLabel, (String)OStrings.getString("PP_LOC_ROOT"));
        Box bLoc = Box.createHorizontalBox();
        bLoc.setBorder(emptyBorder);
        bLoc.add(locRootLabel);
        bLoc.add(Box.createHorizontalGlue());
        JButton locBrowse = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)locBrowse, (String)OStrings.getString("PP_BUTTON_BROWSE_TAR"));
        bLoc.add(locBrowse);
        final JTextField locRootField = new JTextField();
        dirsBox.add(bLoc);
        dirsBox.add(locRootField);
        centerBox.add(dirsBox);
        JScrollPane scrollPane = new JScrollPane(centerBox);
        scrollPane.setBackground(this.getBackground());
        scrollPane.getViewport().setOpaque(false);
        this.getContentPane().add((Component)scrollPane, "Center");
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)OStrings.getString("BUTTON_OK"));
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        Box southBox = Box.createHorizontalBox();
        southBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        southBox.add(Box.createHorizontalGlue());
        southBox.add(okButton);
        southBox.add(Box.createHorizontalStrut(5));
        southBox.add(cancelButton);
        this.getContentPane().add((Component)southBox, "South");
        this.setResizable(false);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doOK(sourceLocaleField, targetLocaleField, sourceTokenizerField, targetTokenizerField, sentenceSegmentingCheckBox, srcRootField, locRootField, glosRootField, writeableGlosField, tmRootField, dictRootField, allowDefaultsCheckBox, removeTagsCheckBox, externalCommandTextArea);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doCancel();
            }
        });
        srcBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(1, srcRootField);
            }
        });
        srcExcludesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> result = FilenamePatternsEditorController.show(ProjectPropertiesDialog.this.srcExcludes);
                if (result != null) {
                    ProjectPropertiesDialog.this.srcExcludes.clear();
                    ProjectPropertiesDialog.this.srcExcludes.addAll(result);
                }
            }
        });
        locBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(2, locRootField);
            }
        });
        glosBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isDefaultGlossaryFile = projectProperties.isDefaultWriteableGlossaryFile();
                ProjectPropertiesDialog.this.doBrowseDirectoy(3, glosRootField);
                if (isDefaultGlossaryFile) {
                    String newDefault = projectProperties.computeDefaultWriteableGlossaryFile();
                    projectProperties.setWriteableGlossary(newDefault);
                    writeableGlosField.setText(newDefault);
                }
            }
        });
        wGlosBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(6, writeableGlosField);
            }
        });
        tmBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(4, tmRootField);
            }
        });
        dictBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(5, dictRootField);
            }
        });
        sentenceSegmentingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentationCustomizer segmentationCustomizer = new SegmentationCustomizer(true, SRX.getDefault(), Preferences.getSRX(), ProjectPropertiesDialog.this.srx);
                if (segmentationCustomizer.show(ProjectPropertiesDialog.this)) {
                    ProjectPropertiesDialog.this.srx = segmentationCustomizer.getResult();
                }
            }
        });
        fileFiltersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiltersCustomizer dlg = new FiltersCustomizer(true, FilterMaster.createDefaultFiltersConfig(), Preferences.getFilters(), ProjectPropertiesDialog.this.filters);
                if (dlg.show(ProjectPropertiesDialog.this)) {
                    ProjectPropertiesDialog.this.filters = dlg.getResult();
                }
            }
        });
        repositoriesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<RepositoryDefinition> r = new RepositoriesMappingController().show(parent, projectProperties.getRepositories());
                if (r != null) {
                    projectProperties.setRepositories(r);
                }
            }
        });
        externalFinderButton.addActionListener(e -> {
            ExternalFinderCustomizer dlg = new ExternalFinderCustomizer(true, this.externalFinderConfig);
            if (dlg.show(this)) {
                this.externalFinderConfig = dlg.getResult();
            }
        });
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doCancel();
            }
        });
        srcRootField.setText(projectProperties.getSourceRoot());
        locRootField.setText(projectProperties.getTargetRoot());
        glosRootField.setText(projectProperties.getGlossaryRoot());
        writeableGlosField.setText(projectProperties.getWriteableGlossary());
        tmRootField.setText(projectProperties.getTMRoot());
        dictRootField.setText(projectProperties.getDictRoot());
        sentenceSegmentingCheckBox.setSelected(projectProperties.isSentenceSegmentingEnabled());
        allowDefaultsCheckBox.setSelected(projectProperties.isSupportDefaultTranslations());
        removeTagsCheckBox.setSelected(projectProperties.isRemoveTags());
        switch (this.dialogType) {
            case RESOLVE_DIRS: {
                File wGlos;
                sourceLocaleField.setEnabled(false);
                targetLocaleField.setEnabled(false);
                sourceTokenizerField.setEnabled(false);
                targetTokenizerField.setEnabled(false);
                sentenceSegmentingCheckBox.setEnabled(false);
                allowDefaultsCheckBox.setEnabled(false);
                removeTagsCheckBox.setEnabled(false);
                externalCommandTextArea.setEnabled(false);
                insertButton.setEnabled(false);
                variablesList.setEnabled(false);
                File f = new File(srcRootField.getText());
                if (!f.isDirectory()) {
                    srcRootField.setForeground(Color.RED);
                }
                if (!(f = new File(locRootField.getText())).isDirectory()) {
                    locRootField.setForeground(Color.RED);
                }
                if (!(f = new File(glosRootField.getText())).isDirectory()) {
                    glosRootField.setForeground(Color.RED);
                }
                if (!(wGlos = (f = new File(writeableGlosField.getText())).getParentFile()).isDirectory() || !wGlos.equals(new File(glosRootField.getText()))) {
                    writeableGlosField.setForeground(Color.RED);
                }
                if (!(f = new File(tmRootField.getText())).isDirectory()) {
                    tmRootField.setForeground(Color.RED);
                }
                if ((f = new File(dictRootField.getText())).isDirectory()) break;
                dictRootField.setForeground(Color.RED);
                break;
            }
        }
        this.pack();
        this.updateUIText(messageArea);
        this.pack();
        this.setSize(9 * this.getWidth() / 8, this.getHeight() + 10);
        this.setResizable(true);
        StaticUIUtils.fitInScreen(this);
        this.setLocationRelativeTo(parent);
    }

    private void doBrowseDirectoy(int browseTarget, JTextField field) {
        int action;
        File dir;
        String title;
        if (field == null) {
            return;
        }
        boolean fileMode = false;
        boolean glossaryFile = false;
        if (browseTarget == 6) {
            fileMode = true;
            glossaryFile = true;
        }
        switch (browseTarget) {
            case 1: {
                title = OStrings.getString("PP_BROWSE_TITLE_SOURCE");
                break;
            }
            case 2: {
                title = OStrings.getString("PP_BROWSE_TITLE_TARGET");
                break;
            }
            case 3: {
                title = OStrings.getString("PP_BROWSE_TITLE_GLOS");
                break;
            }
            case 4: {
                title = OStrings.getString("PP_BROWSE_TITLE_TM");
                break;
            }
            case 5: {
                title = OStrings.getString("PP_BROWSE_TITLE_DICT");
                break;
            }
            case 6: {
                title = OStrings.getString("PP_BROWSE_W_GLOS");
                break;
            }
            default: {
                return;
            }
        }
        OmegaTFileChooser browser = new OmegaTFileChooser();
        browser.setDialogTitle(title);
        if (fileMode) {
            browser.setFileSelectionMode(0);
        } else {
            browser.setFileSelectionMode(1);
        }
        String curDir = field.getText();
        File curDirCheck = new File(curDir);
        if (fileMode && !StringUtil.isEmpty(curDirCheck.getName())) {
            String dirOnly = curDirCheck.getParent();
            dirOnly = dirOnly != null ? dirOnly : "";
            curDirCheck = new File(dirOnly);
        }
        if (!curDirCheck.exists() || !curDirCheck.isDirectory()) {
            curDir = this.projectProperties.getProjectRoot();
            curDirCheck = new File(curDir);
        }
        if (!curDirCheck.exists() || !curDirCheck.isDirectory()) {
            switch (browseTarget) {
                case 1: {
                    curDir = Preferences.getPreference("source_folder");
                    break;
                }
                case 2: {
                    curDir = Preferences.getPreference("target_folder");
                    break;
                }
                case 3: {
                    curDir = Preferences.getPreference("glossary_folder");
                    break;
                }
                case 4: {
                    curDir = Preferences.getPreference("tm_folder");
                    break;
                }
                case 5: {
                    curDir = Preferences.getPreference("dict_folder");
                    break;
                }
                case 6: {
                    curDir = Preferences.getPreference("glossary_file");
                }
            }
        }
        if (fileMode) {
            File dirFile = new File(curDir);
            curDir = dirFile.getParent();
        }
        if (curDir.equals("")) {
            curDir = Preferences.getPreference("current_folder");
        }
        if (!curDir.equals("") && (dir = new File(curDir)).exists() && dir.isDirectory()) {
            browser.setCurrentDirectory(dir);
        }
        if ((action = browser.showOpenDialog(this)) != 0) {
            return;
        }
        File dir2 = browser.getSelectedFile();
        if (dir2 == null) {
            return;
        }
        String str = dir2.getAbsolutePath();
        if (!fileMode) {
            str = str + File.separator;
        }
        if (glossaryFile && !str.endsWith(".txt") && !str.endsWith(".utf8")) {
            str = str + ".txt";
        }
        switch (browseTarget) {
            case 1: {
                Preferences.setPreference("source_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setSourceRoot(str);
                field.setText(this.projectProperties.getSourceRoot());
                if (!new File(this.projectProperties.getSourceRoot()).exists() || !new File(this.projectProperties.getSourceRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 2: {
                Preferences.setPreference("target_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setTargetRoot(str);
                field.setText(this.projectProperties.getTargetRoot());
                if (!new File(this.projectProperties.getTargetRoot()).exists() || !new File(this.projectProperties.getTargetRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 3: {
                Preferences.setPreference("glossary_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setGlossaryRoot(str);
                field.setText(this.projectProperties.getGlossaryRoot());
                if (!new File(this.projectProperties.getGlossaryRoot()).exists() || !new File(this.projectProperties.getGlossaryRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 4: {
                Preferences.setPreference("tm_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setTMRoot(str);
                field.setText(this.projectProperties.getTMRoot());
                if (!new File(this.projectProperties.getTMRoot()).exists() || !new File(this.projectProperties.getTMRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 5: {
                Preferences.setPreference("dict_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setDictRoot(str);
                field.setText(this.projectProperties.getDictRoot());
                if (!new File(this.projectProperties.getDictRoot()).exists() || !new File(this.projectProperties.getDictRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 6: {
                Preferences.setPreference("glossary_file", browser.getSelectedFile().getPath());
                this.projectProperties.setWriteableGlossary(str);
                field.setText(this.projectProperties.getWriteableGlossary());
                if (!new File(this.projectProperties.getWriteableGlossaryDir()).exists() || !new File(this.projectProperties.getWriteableGlossaryDir()).isDirectory() || !this.projectProperties.getWriteableGlossaryDir().contains(this.projectProperties.getGlossaryRoot())) break;
                field.setForeground(SystemColor.textText);
            }
        }
    }

    private void doOK(JComboBox<Language> sourceLocaleField, JComboBox<Language> targetLocaleField, JComboBox<Class<?>> sourceTokenizerField, JComboBox<Class<?>> targetTokenizerField, JCheckBox sentenceSegmentingCheckBox, JTextField srcRootField, JTextField locRootField, JTextField glosRootField, JTextField writeableGlosField, JTextField tmRootField, JTextField dictRootField, JCheckBox allowDefaultsCheckBox, JCheckBox removeTagsCheckBox, JTextArea customCommandTextArea) {
        if (!Language.verifySingleLangCode(sourceLocaleField.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_INVALID_SOURCE_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
            sourceLocaleField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setSourceLanguage(sourceLocaleField.getSelectedItem().toString());
        if (!Language.verifySingleLangCode(targetLocaleField.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_INVALID_TARGET_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
            targetLocaleField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTargetLanguage(targetLocaleField.getSelectedItem().toString());
        if (sourceTokenizerField.isEnabled()) {
            this.projectProperties.setSourceTokenizer((Class)sourceTokenizerField.getSelectedItem());
        }
        if (targetTokenizerField.isEnabled()) {
            this.projectProperties.setTargetTokenizer((Class)targetTokenizerField.getSelectedItem());
        }
        this.projectProperties.setSentenceSegmentingEnabled(sentenceSegmentingCheckBox.isSelected());
        this.projectProperties.setSupportDefaultTranslations(allowDefaultsCheckBox.isSelected());
        this.projectProperties.setRemoveTags(removeTagsCheckBox.isSelected());
        this.projectProperties.setExternalCommand(customCommandTextArea.getText());
        this.projectProperties.setSourceRoot(srcRootField.getText());
        if (!this.projectProperties.getSourceRoot().endsWith(File.separator)) {
            this.projectProperties.setSourceRoot(this.projectProperties.getSourceRoot() + File.separator);
        }
        if (this.dialogType != Mode.NEW_PROJECT && !new File(this.projectProperties.getSourceRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_SOURCEDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            srcRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTargetRoot(locRootField.getText());
        if (!this.projectProperties.getTargetRoot().endsWith(File.separator)) {
            this.projectProperties.setTargetRoot(this.projectProperties.getTargetRoot() + File.separator);
        }
        if (this.dialogType != Mode.NEW_PROJECT && !new File(this.projectProperties.getTargetRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_TRANSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            locRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setGlossaryRoot(glosRootField.getText());
        if (!this.projectProperties.getGlossaryRoot().endsWith(File.separator)) {
            this.projectProperties.setGlossaryRoot(this.projectProperties.getGlossaryRoot() + File.separator);
        }
        if (this.dialogType != Mode.NEW_PROJECT && !new File(this.projectProperties.getGlossaryRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_GLOSSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            glosRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setWriteableGlossary(writeableGlosField.getText());
        if (this.dialogType != Mode.NEW_PROJECT && !new File(this.projectProperties.getWriteableGlossaryDir()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_W_GLOSSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            writeableGlosField.requestFocusInWindow();
            return;
        }
        String glossaryDir = this.projectProperties.getWriteableGlossaryDir();
        if (!glossaryDir.endsWith(File.separator)) {
            glossaryDir = glossaryDir + File.separator;
        }
        if (!glossaryDir.contains(this.projectProperties.getGlossaryRoot())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_W_GLOSDIR_NOT_INSIDE_GLOS"), OStrings.getString("TF_ERROR"), 0);
            writeableGlosField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTMRoot(tmRootField.getText());
        if (!this.projectProperties.getTMRoot().endsWith(File.separator)) {
            this.projectProperties.setTMRoot(this.projectProperties.getTMRoot() + File.separator);
        }
        if (this.dialogType != Mode.NEW_PROJECT && !new File(this.projectProperties.getTMRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_TMDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            tmRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setDictRoot(dictRootField.getText());
        if (!this.projectProperties.getDictRoot().endsWith(File.separator)) {
            this.projectProperties.setDictRoot(this.projectProperties.getDictRoot() + File.separator);
        }
        if (this.dialogType != Mode.NEW_PROJECT && !new File(this.projectProperties.getDictRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_DICTDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            dictRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setProjectSRX(this.srx);
        this.projectProperties.setProjectFilters(this.filters);
        this.projectProperties.getSourceRootExcludes().clear();
        this.projectProperties.getSourceRootExcludes().addAll(this.srcExcludes);
        ExternalFinder.setProjectConfig(this.externalFinderConfig);
        this.dialogCancelled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        if (this.dialogType == Mode.NEW_PROJECT) {
            new File(this.projectProperties.getProjectRoot()).delete();
        }
        this.dialogCancelled = true;
        this.setVisible(false);
    }

    private void updateUIText(JTextArea messageArea) {
        switch (this.dialogType) {
            case NEW_PROJECT: {
                this.setTitle(OStrings.getString("PP_CREATE_PROJ"));
                messageArea.setText(OStrings.getString("PP_MESSAGE_CONFIGPROJ"));
                break;
            }
            case RESOLVE_DIRS: {
                this.setTitle(OStrings.getString("PP_OPEN_PROJ"));
                messageArea.setText(OStrings.getString("PP_MESSAGE_BADPROJ"));
                messageArea.setFont(messageArea.getFont().deriveFont(1));
                break;
            }
            case EDIT_PROJECT: {
                this.setTitle(OStrings.getString("PP_EDIT_PROJECT"));
                messageArea.setText(OStrings.getString("PP_MESSAGE_EDITPROJ"));
            }
        }
    }

    public ProjectProperties getResult() {
        return this.dialogCancelled ? null : this.projectProperties;
    }

    private static class ScrollableBox
    extends Box
    implements Scrollable {
        ScrollableBox(int axis) {
            super(axis);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getFont().getSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getFont().getSize();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    public static enum Mode {
        NEW_PROJECT,
        RESOLVE_DIRS,
        EDIT_PROJECT;

    }
}

