/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dictionaries;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.dictionaries.DictionariesManager;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.dictionaries.DictionaryPopup;
import org.omegat.gui.dictionaries.IDictionaries;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class DictionariesTextArea
extends EntryInfoThreadPane<List<DictionaryEntry>>
implements IDictionaries,
IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_DICTIONARYWINDOW_explanation");
    protected final DictionariesManager manager = new DictionariesManager(this);
    protected final List<String> displayedWords = new ArrayList<String>();
    protected ITokenizer tokenizer;
    private final DockableScrollPane scrollPane;
    protected final transient MouseAdapter mouseCallback = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        private void doPopup(Point p) {
            UIThreadsUtil.mustBeSwingThread();
            JPopupMenu popup = new JPopupMenu();
            int mousepos = DictionariesTextArea.this.viewToModel(p);
            final String word = DictionariesTextArea.this.getWordAtOffset(mousepos);
            if (word != null) {
                JMenuItem item = popup.add(StringUtil.format(OStrings.getString("DICTIONARY_HIDE"), word));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DictionariesTextArea.this.manager.addIgnoreWord(word);
                    }
                });
                popup.show(DictionariesTextArea.this, p.x, p.y);
            }
        }
    };

    public DictionariesTextArea(IMainWindow mw) {
        super(true);
        this.setContentType("text/html");
        ((HTMLDocument)this.getDocument()).setPreservesUnknownTags(false);
        this.setFont(this.getFont());
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Dictionary");
        this.scrollPane = new DockableScrollPane("DICTIONARY", title, this, true);
        mw.addDockable(this.scrollPane);
        this.addMouseListener(this.mouseCallback);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        CoreEvents.registerEditorEventListener(new IEditorEventListener(){

            @Override
            public void onNewWord(String newWord) {
                DictionariesTextArea.this.callDictionary(newWord);
            }
        });
        Core.getEditor().registerPopupMenuConstructors(750, new DictionaryPopup());
        Preferences.addPropertyChangeListener("dictionary_fuzzy_matching", e -> this.refresh());
        Preferences.addPropertyChangeListener("dictionary_auto_search", e -> this.refresh());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Document doc = this.getDocument();
        if (!(doc instanceof HTMLDocument)) {
            return;
        }
        StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
        styleSheet.addRule("body { font-family: " + font.getName() + ";  font-size: " + font.getSize() + ";  font-style: " + (font.getStyle() == 1 ? "bold" : (font.getStyle() == 2 ? "italic" : "normal")) + ";  color: " + Styles.EditorColor.COLOR_FOREGROUND.toHex() + ";  background: " + Styles.EditorColor.COLOR_BACKGROUND.toHex() + ";  }");
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        IProject project = Core.getProject();
        this.tokenizer = project.getSourceTokenizer();
        this.manager.setIndexLanguage(project.getProjectProperties().getSourceLanguage());
        this.manager.setTokenizer(this.tokenizer);
        this.manager.start(new File(project.getProjectProperties().getDictRoot()));
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        this.manager.stop();
        this.tokenizer = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.displayedWords.clear();
    }

    protected void callDictionary(String word) {
        UIThreadsUtil.mustBeSwingThread();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        int i = this.displayedWords.indexOf(word.toLowerCase());
        if (i == -1) {
            return;
        }
        Element el = doc.getElement(Integer.toString(i));
        if (el == null) {
            return;
        }
        try {
            Rectangle rect = this.modelToView(el.getStartOffset());
            if (rect != null) {
                rect.height *= 2;
                this.scrollRectToVisible(rect);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        this.scrollPane.stopNotifying();
        super.onEntryActivated(newEntry);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        if (!Preferences.isPreferenceDefault("dictionary_auto_search", true)) {
            return;
        }
        new DictionaryEntriesSearchThread(newEntry).start();
    }

    @Override
    public void searchText(String text) {
        new DictionaryTextSearchThread(text).start();
    }

    @Override
    public void refresh() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        if (ste != null) {
            this.startSearchThread(ste);
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, List<DictionaryEntry> data) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        if (data == null) {
            return;
        }
        if (!data.isEmpty() && Preferences.isPreference("notify_dictionary_hits")) {
            this.scrollPane.notify(true);
        }
        StringBuilder txt = new StringBuilder();
        boolean wasPrev = false;
        int i = 0;
        for (DictionaryEntry de : data) {
            if (wasPrev) {
                txt.append("<br><hr>");
            } else {
                wasPrev = true;
            }
            txt.append("<b><span id=\"" + i + "\">");
            txt.append(de.getWord());
            txt.append("</span></b>");
            txt.append(" - ").append(de.getArticle());
            this.displayedWords.add(de.getWord().toLowerCase());
            ++i;
        }
        this.setText(txt.toString());
    }

    private String getWordAtOffset(int offset) {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        for (int i = 0; i < this.displayedWords.size(); ++i) {
            Element el = doc.getElement(Integer.toString(i));
            if (el == null || el.getStartOffset() > offset || el.getEndOffset() < offset) continue;
            return this.displayedWords.get(i);
        }
        return null;
    }

    @Override
    public void addDictionaryFactory(IDictionaryFactory factory) {
        this.manager.addDictionaryFactory(factory);
    }

    @Override
    public void removeDictionaryFactory(IDictionaryFactory factory) {
        this.manager.removeDictionaryFactory(factory);
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        final JCheckBoxMenuItem notify = new JCheckBoxMenuItem(OStrings.getString("GUI_DICTIONARYWINDOW_SETTINGS_NOTIFICATIONS"));
        notify.setSelected(Preferences.isPreference("notify_dictionary_hits"));
        notify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.setPreference("notify_dictionary_hits", notify.isSelected());
            }
        });
        menu.add(notify);
    }

    public class DictionaryTextSearchThread
    extends Thread {
        private final String src;
        private final ITokenizer tok;
        private final DictionariesTextArea pane;

        public DictionaryTextSearchThread(String text) {
            this.src = text;
            this.tok = DictionariesTextArea.this.tokenizer;
            this.pane = DictionariesTextArea.this;
        }

        protected List<DictionaryEntry> search() {
            if (this.tok == null) {
                return null;
            }
            List<String> words = Stream.of(this.tok.tokenizeWordsToStrings(this.src, ITokenizer.StemmingMode.NONE)).distinct().collect(Collectors.toList());
            List<DictionaryEntry> result = DictionariesTextArea.this.manager.findWords(words);
            Collections.sort(result);
            return result;
        }

        @Override
        public void run() {
            List<DictionaryEntry> result = null;
            Exception error = null;
            try {
                result = this.search();
            }
            catch (Exception ex) {
                error = ex;
                Log.log(ex);
            }
            List<DictionaryEntry> fresult = result;
            Exception ferror = error;
            SwingUtilities.invokeLater(() -> {
                if (ferror != null) {
                    this.pane.setError(ferror);
                } else {
                    this.pane.setFoundResult(DictionariesTextArea.this.currentlyProcessedEntry, fresult);
                }
            });
        }
    }

    public class DictionaryEntriesSearchThread
    extends EntryInfoSearchThread<List<DictionaryEntry>> {
        protected final String src;
        protected final ITokenizer tok;

        public DictionaryEntriesSearchThread(SourceTextEntry newEntry) {
            super(DictionariesTextArea.this, newEntry);
            this.src = newEntry.getSrcText();
            this.tok = DictionariesTextArea.this.tokenizer;
        }

        @Override
        protected List<DictionaryEntry> search() {
            if (this.tok == null) {
                return null;
            }
            List<String> words = Stream.of(this.tok.tokenizeWordsToStrings(this.src, ITokenizer.StemmingMode.NONE)).distinct().collect(Collectors.toList());
            List<DictionaryEntry> result = DictionariesTextArea.this.manager.findWords(words);
            Collections.sort(result);
            return result;
        }
    }
}

