/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.exttrans;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.machinetranslators.MachineTranslators;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.exttrans.MachineTranslationInfo;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.preferences.PreferencesWindowController;
import org.omegat.gui.preferences.view.MachineTranslationPreferencesController;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class MachineTranslateTextArea
extends EntryInfoThreadPane<MachineTranslationInfo>
implements IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_MACHINETRANSLATESWINDOW_explanation");
    protected Set<MachineTranslationInfo> displayed = new HashSet<MachineTranslationInfo>();
    private Iterator<MachineTranslationInfo> cycle;

    public MachineTranslateTextArea(IMainWindow mw) {
        super(true);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_MachineTranslate");
        mw.addDockable(new DockableScrollPane("MACHINE_TRANSLATE", title, this, true));
        for (Class<?> mtc : PluginUtils.getMachineTranslationClasses()) {
            try {
                MachineTranslators.add((IMachineTranslation)mtc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public String getDisplayedTranslation() {
        if (this.cycle == null || !this.cycle.hasNext()) {
            this.cycle = this.displayed.iterator();
        }
        if (!this.cycle.hasNext()) {
            return null;
        }
        return this.cycle.next().result;
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(EXPLANATION);
    }

    public void forceLoad() {
        this.startSearchThread(this.currentlyProcessedEntry, true);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        this.startSearchThread(newEntry, false);
    }

    private void startSearchThread(SourceTextEntry newEntry, boolean force) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        for (IMachineTranslation mt : MachineTranslators.getMachineTranslators()) {
            if (!mt.isEnabled()) continue;
            new FindThread(mt, newEntry, force).start();
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, MachineTranslationInfo data) {
        UIThreadsUtil.mustBeSwingThread();
        if (data != null && data.result != null) {
            this.displayed.add(data);
            this.setText(this.getText() + data.result + "\n<" + data.translatorName + ">\n\n");
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.displayed.clear();
        this.cycle = null;
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        JMenuItem prefs = new JMenuItem(OStrings.getString("GUI_MACHINETRANSLATESWINDOW_OPEN_PREFS"));
        prefs.addActionListener(e -> new PreferencesWindowController().show(Core.getMainWindow().getApplicationFrame(), MachineTranslationPreferencesController.class));
        menu.add(prefs);
    }

    protected class FindThread
    extends EntryInfoSearchThread<MachineTranslationInfo> {
        private final IMachineTranslation translator;
        private final String src;
        private final boolean force;

        public FindThread(IMachineTranslation translator, SourceTextEntry newEntry, boolean force) {
            super(MachineTranslateTextArea.this, newEntry);
            this.translator = translator;
            this.src = newEntry.getSrcText();
            this.force = force;
        }

        @Override
        protected MachineTranslationInfo search() throws Exception {
            Language source = null;
            Language target = null;
            ProjectProperties pp = Core.getProject().getProjectProperties();
            if (pp != null) {
                source = pp.getSourceLanguage();
                target = pp.getTargetLanguage();
            }
            if (source == null || target == null) {
                return null;
            }
            String result = this.getTranslation(source, target);
            return result == null ? null : new MachineTranslationInfo(this.translator.getName(), result);
        }

        private String getTranslation(Language source, Language target) throws Exception {
            if (!this.force) {
                TMXEntry entry;
                if (!Preferences.isPreferenceDefault("mt_auto_fetch", true)) {
                    return this.translator.getCachedTranslation(source, target, this.src);
                }
                if (Preferences.isPreference("mt_only_untranslated") && (entry = Core.getProject().getTranslationInfo(this.currentlyProcessedEntry)).isTranslated()) {
                    return this.translator.getCachedTranslation(source, target, this.src);
                }
            }
            return this.translator.getTranslation(source, target, this.src);
        }
    }
}

