/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.Styles;

public final class JTextPaneLinkifier {
    private static final String ATTR_LINK = "linkbuilder_link";

    private JTextPaneLinkifier() {
    }

    public static void linkify(JTextPane jTextPane) {
        AttributeInserterMouseListener mouseAdapter = new AttributeInserterMouseListener(jTextPane);
        jTextPane.addMouseListener(mouseAdapter);
        jTextPane.addMouseMotionListener(mouseAdapter);
        JTextPaneLinkifier.setDocumentFilter(jTextPane);
        jTextPane.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object source = evt.getSource();
                if (source instanceof JTextPane) {
                    JTextPaneLinkifier.setDocumentFilter((JTextPane)source);
                }
            }
        });
    }

    private static void setDocumentFilter(JTextPane textPane) {
        StyledDocument doc = textPane.getStyledDocument();
        if (doc instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)((Object)doc);
            abstractDocument.setDocumentFilter(new AttributeInserterDocumentFilter(doc));
        }
    }

    private static class AttributeInserterDocumentFilter
    extends DocumentFilter {
        private static final int REFRESH_DELAY = 200;
        private static final String REGEX_URL = "(?:(?:https?|ftp):\\/\\/)(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,}))\\.?)(?::\\d{2,5})?(?:[/?#]\\S*)?";
        private static final Pattern URL_PATTERN = Pattern.compile("(?:(?:https?|ftp):\\/\\/)(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,}))\\.?)(?::\\d{2,5})?(?:[/?#]\\S*)?", 2);
        private static final AttributeSet DEFAULT_ATTRIBUTES = new SimpleAttributeSet();
        private static final AttributeSet LINK_ATTRIBUTES;
        private final StyledDocument doc;
        private final Timer timer;

        AttributeInserterDocumentFilter(StyledDocument doc) {
            this.doc = doc;
            this.timer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.refreshPane();
                }
            });
            this.timer.setRepeats(false);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            super.insertString(fb, offset, string, attr);
            if (attr == null || !attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                SwingUtilities.invokeLater(this::refreshPane);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            boolean refresh = true;
            AttributeSet attr = ((StyledDocument)fb.getDocument()).getCharacterElement(offset).getAttributes();
            if (attr != null && attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                refresh = false;
            }
            super.remove(fb, offset, length);
            if (refresh && length != 0 && fb.getDocument().getLength() != 0) {
                this.timer.restart();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, offset, length, text, attrs);
            if (fb.getDocument().getLength() != 0) {
                this.timer.restart();
            }
        }

        private void refreshPane() {
            int docLength = this.doc.getLength();
            if (docLength == 0) {
                return;
            }
            try {
                for (int i = 0; i < docLength; ++i) {
                    if (!this.doc.getCharacterElement(i).getAttributes().containsAttributes(LINK_ATTRIBUTES)) continue;
                    this.doc.setCharacterAttributes(i, 1, DEFAULT_ATTRIBUTES, true);
                }
                String text = this.doc.getText(0, docLength);
                Matcher matcher = URL_PATTERN.matcher(text);
                while (matcher.find()) {
                    int offset = matcher.start();
                    int targetLength = matcher.end() - offset;
                    try {
                        AttributeSet atts = this.makeAttributes(offset, new URI(matcher.group()));
                        this.doc.setCharacterAttributes(offset, targetLength, atts, true);
                    }
                    catch (URISyntaxException ex) {
                        Log.log(ex);
                    }
                }
            }
            catch (BadLocationException ex) {
                Log.log(ex);
            }
        }

        private AttributeSet makeAttributes(int offset, final URI target) {
            SimpleAttributeSet atts = new SimpleAttributeSet(this.doc.getCharacterElement(offset).getAttributes());
            atts.addAttributes(LINK_ATTRIBUTES);
            atts.addAttribute(JTextPaneLinkifier.ATTR_LINK, new IAttributeAction(){

                @Override
                public void execute() {
                    try {
                        Desktop.getDesktop().browse(target);
                    }
                    catch (Exception e) {
                        JOptionPane.showConfirmDialog(null, e.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
                        Log.log(e);
                    }
                }
            });
            return atts;
        }

        static {
            SimpleAttributeSet tmp = new SimpleAttributeSet();
            StyleConstants.setUnderline(tmp, true);
            StyleConstants.setForeground(tmp, Styles.EditorColor.COLOR_HYPERLINK.getColor());
            LINK_ATTRIBUTES = tmp;
        }
    }

    private static class AttributeInserterMouseListener
    extends MouseAdapter {
        private final JTextPane jTextPane;

        AttributeInserterMouseListener(JTextPane jTextPane) {
            this.jTextPane = jTextPane;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                StyledDocument doc = this.jTextPane.getStyledDocument();
                Element characterElement = doc.getCharacterElement(this.jTextPane.viewToModel(e.getPoint()));
                AttributeSet as = characterElement.getAttributes();
                Object attr = as.getAttribute(JTextPaneLinkifier.ATTR_LINK);
                if (attr instanceof IAttributeAction) {
                    ((IAttributeAction)attr).execute();
                }
            } else {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            StyledDocument doc = this.jTextPane.getStyledDocument();
            Element characterElement = doc.getCharacterElement(this.jTextPane.viewToModel(e.getPoint()));
            AttributeSet as = characterElement.getAttributes();
            Object attr = as.getAttribute(JTextPaneLinkifier.ATTR_LINK);
            if (attr instanceof IAttributeAction) {
                this.jTextPane.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.jTextPane.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private static interface IAttributeAction {
        public void execute();
    }
}

